/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.WorldRect;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.ShapeGeoInfoDialog;
import hec.map.aishape.ShapeHighlight;
import hec.map.aishape.ShapeTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectListener;
import rma.swing.list.RmaListModel;

public class ShapeQueryDialog
extends RmaJDialog
implements ListSelectionListener {
    AiShapeGlyph _selectedGlyph;
    JComboBox _glyphSelectionList = new JComboBox();
    RmaListModel _glyphSelectionModel = new RmaListModel(true);
    JPanel _glyphCardPanel = new JPanel(new CardLayout());
    Map _glyphPanelMap = new HashMap();

    public ShapeQueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildMenus();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this._glyphSelectionList, gbc);
        this._glyphSelectionList.setModel(this._glyphSelectionModel);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this._glyphCardPanel, gbc);
        this.pack();
        Dimension d = new Dimension(500, 250);
        this.setSize(d);
        this.setDefaultHeight(d.height);
        this.addWindowListener(new SymWindow());
        this._glyphSelectionList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                AiShapeGlyph glyph = (AiShapeGlyph)ShapeQueryDialog.this._glyphSelectionList.getSelectedItem();
                ((CardLayout)ShapeQueryDialog.this._glyphCardPanel.getLayout()).show(ShapeQueryDialog.this._glyphCardPanel, glyph.getName());
                ShapeQueryDialog.this._selectedGlyph = glyph;
            }
        });
    }

    private void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Exit", 69);
        menuItem.addActionListener(new ReflectListener(this, "closeDialog"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        menuBar.add(menu);
        menuItem = new JMenuItem("Clear");
        menuItem.addActionListener(new ReflectListener(this, "clearForm"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Set Columns");
        menuItem.addActionListener(new ReflectListener(this, "chooseColumns"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Remove Glyph");
        menuItem.addActionListener(new ReflectListener(this, "removeGlyph"));
        menu.add(menuItem);
        menu = new JMenu("View");
        menu.setMnemonic('V');
        menuBar.add(menu);
        menuItem = new JMenuItem("Zoom to Shapes", 90);
        menuItem.addActionListener(new ReflectListener(this, "zoomToShapesAction"));
        menu.add(menuItem);
        this.getRootPane().setMenuBar(menuBar);
    }

    public void setGlyphs(AiShapeGlyph[] glyphs) {
        if (glyphs == null) {
            return;
        }
        boolean startWithEmptyList = this._glyphSelectionModel.size() == 0;
        for (int i = 0; i < glyphs.length; ++i) {
            if (glyphs[i] == null || this._glyphPanelMap.get(glyphs[i].toString()) != null) continue;
            ReportPanel panel = new ReportPanel(glyphs[i]);
            this._glyphPanelMap.put(glyphs[i].toString(), panel);
            this._glyphSelectionModel.addElement(glyphs[i]);
            this._glyphCardPanel.add((Component)panel, glyphs[i].getName());
        }
        if (startWithEmptyList && this._glyphSelectionModel.size() > 0) {
            this._glyphSelectionList.setSelectedIndex(0);
        }
        this.setTitle("Attributes Table");
    }

    public void addShapes(AiShapeGlyph glyph, List shapes) {
        if (glyph == null) {
            return;
        }
        ReportPanel panel = (ReportPanel)this._glyphPanelMap.get(glyph.toString());
        if (panel == null) {
            return;
        }
        panel.addShapes(shapes);
    }

    @Override
    public void clearForm() {
        ReportPanel panel = (ReportPanel)this._glyphPanelMap.get(this._selectedGlyph.toString());
        if (panel == null) {
            return;
        }
        panel.getTableModel().clear();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel table = (ListSelectionModel)e.getSource();
        JTable visibleTable = null;
        int[] rows = this.getSelectedRows(table);
        ReportPanel panel = this.getVisiblePanel();
        if (panel == null) {
            return;
        }
        visibleTable = panel.getTable();
        if (visibleTable == null) {
            return;
        }
        ShapeTableModel tableModel = (ShapeTableModel)visibleTable.getModel();
        if (rows == null || rows.length < 1) {
            tableModel.clearHighlights();
        } else {
            tableModel.rowsSelected(rows);
        }
    }

    private ReportPanel getVisiblePanel() {
        Component[] comps = this._glyphCardPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (!comp.isVisible()) continue;
            return (ReportPanel)comp;
        }
        return null;
    }

    private int[] getSelectedRows(ListSelectionModel selectionModel) {
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        if (iMin == -1 || iMax == -1) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public void removeGlyph() {
        AiShapeGlyph glyph = (AiShapeGlyph)this._glyphSelectionList.getSelectedItem();
        if (glyph == null) {
            return;
        }
        this._glyphSelectionModel.removeElement(glyph);
        ReportPanel panel = (ReportPanel)this._glyphPanelMap.remove(glyph.toString());
        this._glyphCardPanel.remove(panel);
        if (this._glyphSelectionModel.size() > 0) {
            this._glyphSelectionList.setSelectedIndex(0);
        }
    }

    public void chooseColumns() {
        ReportPanel panel = (ReportPanel)this._glyphPanelMap.get(this._selectedGlyph.toString());
        if (panel == null) {
            return;
        }
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._selectedGlyph.getDataRecord();
        boolean tf = data.chooseQueryFields(this, this._selectedGlyph.getFieldDescriptors());
        if (tf) {
            panel.getTableModel().fireQueryFieldsChanged();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
        if (b && this._glyphSelectionModel.size() > 0) {
            this._glyphSelectionList.setSelectedIndex(0);
        }
    }

    public boolean closeDialog() {
        this.setVisible(false);
        return true;
    }

    public void showShapeGeoInfoDialog(AiShapeObject shape) {
        if (shape == null) {
            return;
        }
        ShapeGeoInfoDialog dlg = new ShapeGeoInfoDialog(this, shape, this._selectedGlyph);
        dlg.setVisible(true);
    }

    public void zoomToShapesAction() {
        ReportPanel panel = this.getVisiblePanel();
        if (panel == null) {
            return;
        }
        ShapeHighlight highlight = panel.getTableModel().getShapeHighlight();
        if (highlight == null) {
            return;
        }
        List shapes = highlight.getShapes();
        if (shapes == null) {
            return;
        }
        WorldRect wr = new WorldRect();
        for (int i = 0; i < shapes.size(); ++i) {
            AiShapeObject obj = (AiShapeObject)shapes.get(i);
            wr.grow(obj.getExtent());
        }
        panel.getGlyph().getMapPanel().scale().zoomIn(wr);
        panel.getGlyph().getMapPanel().paintMap();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ShapeQueryDialog.this) {
                ShapeQueryDialog.this.closeDialog();
            }
        }
    }

    private class ReportPanel
    extends JPanel {
        RmaJTable _table = null;
        ShapeTableModel _tableModel = null;
        AiShapeGlyph _glyph = null;

        public ReportPanel(AiShapeGlyph glyph) {
            this.setLayout(new BorderLayout());
            this._table = new RmaJTable(this){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = this.getRowHeight() * 5 + this.getTableHeader().getHeight();
                    d.width = this.getRowHeight() * 20 + this.getTableHeader().getHeight();
                    return d;
                }
            };
            this._table.getSelectionModel().addListSelectionListener(ShapeQueryDialog.this);
            this._tableModel = new ShapeTableModel(this._table);
            this._table.setPopupMenuEnabled(true);
            this._table.setPopupMenu(this.createPopupMenu());
            this._tableModel.setGlyph(glyph);
            this._table.setBackground(Color.cyan);
            this._table.setAutoResizeMode(0);
            this.add((Component)new JScrollPane(this._table), "Center");
            this._glyph = glyph;
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        ReportPanel.this.mouseDoubleClicked(e.getPoint());
                    }
                }
            });
            this._table.setRowSorter(new TableRowSorter<ShapeTableModel>(this._tableModel));
        }

        private JPopupMenu createPopupMenu() {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Zoom to Shapes", 90);
            menuItem.addActionListener(new ReflectListener(ShapeQueryDialog.this, "zoomToShapesAction"));
            popup.add(menuItem);
            return popup;
        }

        public AiShapeGlyph getGlyph() {
            return this._glyph;
        }

        public void addShapes(List shapes) {
            this._table.setRowSorter(null);
            this._tableModel.addShapes(shapes);
            this._table.setRowSorter(new TableRowSorter<ShapeTableModel>(this._tableModel));
        }

        private void mouseDoubleClicked(Point point) {
            int row = this._table.rowAtPoint(point);
            if (row == -1) {
                return;
            }
            AiShapeObject shape = this._tableModel.getShapeAt(row);
            ShapeQueryDialog.this.showShapeGeoInfoDialog(shape);
        }

        public JTable getTable() {
            return this._table;
        }

        public ShapeTableModel getTableModel() {
            return this._tableModel;
        }
    }
}

