/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.appInterface.AppDaddy;
import hec.map.ButtonGifStrings;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.aishape.AiShapeConst;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.ShapeQueryDialog;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.List;
import rma.swing.RmaImage;

public class ShapeQueryMouseAdapter
extends MapMouseAdapter
implements AiShapeConst {
    public static final String CURSOR = "";
    static Cursor _cursor;
    ShapeQueryDialog _dialog;

    public ShapeQueryMouseAdapter(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
        Image cursor;
        if (_cursor == null && (cursor = RmaImage.loadURLImage("Images/ShapeQueryCursor.gif")) != null) {
            _cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursor, new Point(14, 14), CURSOR);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (ShapeQueryMouseAdapter.pressedButton1(e)) {
            List glyphVector = this._mapPanel.glyphList();
            for (int ii = glyphVector.size() - 1; ii >= 0; --ii) {
                AiShapeGlyph glyph;
                Object o = glyphVector.get(ii);
                if (!(o instanceof AiShapeGlyph) || !(glyph = (AiShapeGlyph)o).isShown()) continue;
                this.query(e.getX(), e.getY(), glyph);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private void query(int x, int y, AiShapeGlyph glyph) {
        List shapes = glyph.getShapeObjects(x, y);
        if (shapes.size() > 0) {
            AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)glyph.getDataRecord();
            if (this._dialog == null) {
                this._dialog = new ShapeQueryDialog((Frame)((Object)AppDaddy.getFrame()), false);
            }
            this._dialog.setGlyphs(new AiShapeGlyph[]{glyph});
            this._dialog.addShapes(glyph, shapes);
            if (!this._dialog.isVisible()) {
                this._dialog.setVisible(true);
            }
        }
    }

    public static ButtonGifStrings buildDefaultButtonGifStrings() {
        ButtonGifStrings bgstr = new ButtonGifStrings();
        bgstr.up = "Images/ShapeQueryTool2.gif";
        bgstr.down = "Images/ShapeQueryTool2.gif";
        bgstr.over = "Images/ShapeQueryTool2.gif";
        bgstr.on = "Images/ShapeQueryTool2.gif";
        bgstr.borderPainted = true;
        bgstr.adapter = ShapeQueryMouseAdapter.class.getName();
        bgstr.toolTipText = "Shapefile Query Tool";
        return bgstr;
    }

    @Override
    public Cursor getCursor() {
        if (_cursor == null) {
            return super.getCursor();
        }
        return _cursor;
    }
}

