/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape;

import hec.map.MapPanel;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.Attribute;
import hec.map.aishape.ShapeHighlight;
import java.util.List;
import java.util.Vector;
import javax.swing.JPopupMenu;
import rma.swing.RmaJTable;
import rma.swing.table.AbstractRmaTableModel;

public class ShapeTableModel
extends AbstractRmaTableModel {
    RmaJTable _table;
    AiShapeGlyph _glyph;
    Vector _attributes = new Vector();
    Vector _shapes = new Vector();
    int[] _query2Attribute;
    ShapeHighlight _shapeHighlight = null;

    public ShapeTableModel(RmaJTable table) {
        this._table = table;
        this._table.setModel(this);
        this._table.setPopupMenuEnabled(false);
        this._table.setCellSelectionEnabled(false);
        this._table.setRowSelectionAllowed(true);
    }

    private JPopupMenu createPopupMenu() {
        System.out.println("createPopupMenu TODO implement me");
        return null;
    }

    public void setGlyph(AiShapeGlyph glyph) {
        this._glyph = glyph;
        this.fireQueryFieldsChanged();
    }

    public void clear() {
        this._attributes.clear();
        this._shapes.clear();
        this.fireTableDataChanged();
    }

    public void rowSelected(int row) {
        AiShapeObject shape = (AiShapeObject)this._shapes.get(row);
        if (this._shapeHighlight != null) {
            this._shapeHighlight.clearHighlight();
        }
        Vector<AiShapeObject> shapes = new Vector<AiShapeObject>(1);
        shapes.add(shape);
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._glyph.getDataRecord();
        int fieldIdx = data.getFieldIndex();
        MapPanel mapPanel = this._glyph.getMapPanel();
        this._shapeHighlight = new ShapeHighlight(shapes, fieldIdx, data, mapPanel, 0);
    }

    public void rowsSelected(int[] rows) {
        Vector<AiShapeObject> shapes = new Vector<AiShapeObject>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            AiShapeObject shape = (AiShapeObject)this._shapes.get(rows[i]);
            shapes.add(shape);
        }
        if (this._shapeHighlight != null) {
            this._shapeHighlight.clearHighlight();
        }
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._glyph.getDataRecord();
        int fieldIdx = data.getFieldIndex();
        MapPanel mapPanel = this._glyph.getMapPanel();
        this._shapeHighlight = new ShapeHighlight(shapes, fieldIdx, data, mapPanel, 0);
    }

    public AiShapeObject getShapeAt(int row) {
        AiShapeObject shape = (AiShapeObject)this._shapes.get(row);
        return shape;
    }

    public void addShapes(List shapes) {
        int oldSize = this._attributes.size();
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._glyph.getDataRecord();
        int fieldIdx = data.getFieldIndex();
        MapPanel mapPanel = this._glyph.getMapPanel();
        Vector<AiShapeObject> highlightShapes = new Vector<AiShapeObject>(shapes.size());
        for (int ii = 0; ii < shapes.size(); ++ii) {
            AiShapeObject shape = (AiShapeObject)shapes.get(ii);
            if (this._shapes.contains(shape)) continue;
            Attribute attrib = shape.getAttribute();
            this._attributes.add(attrib);
            this._shapes.add(shape);
            if (this._shapeHighlight != null && this._shapeHighlight.contains(shape)) continue;
            highlightShapes.add(shape);
        }
        Thread thread = new Thread(new ShapeHighlight(highlightShapes, fieldIdx, data, mapPanel, 0, 500L));
        thread.start();
        int newSize = this._attributes.size();
        if (newSize > oldSize) {
            this.fireTableRowsInserted(oldSize, newSize);
        }
    }

    public void clearHighlights() {
        if (this._shapeHighlight == null) {
            return;
        }
        this._table.clearSelection();
        this._shapeHighlight.clearHighlight();
    }

    @Override
    public int getColumnCount() {
        if (this._glyph == null) {
            return 0;
        }
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._glyph.getDataRecord();
        List fields = data.getQueryFields();
        if (fields == null) {
            return 0;
        }
        return fields.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this._glyph == null) {
            return null;
        }
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._glyph.getDataRecord();
        List fields = data.getQueryFields();
        if (fields == null) {
            return null;
        }
        AiShapeFieldDescriptor field = (AiShapeFieldDescriptor)fields.get(columnIndex);
        return field.toString();
    }

    public void fireQueryFieldsChanged() {
        if (this._glyph == null) {
            return;
        }
        AiShapeGlyphDataRecord data = (AiShapeGlyphDataRecord)this._glyph.getDataRecord();
        Vector queryFields = data.getQueryFields();
        Vector allFields = this._glyph.getFieldDescriptors();
        if (queryFields == null) {
            queryFields = new Vector(allFields.size());
            queryFields.addAll(allFields);
            data.setQueryFields(queryFields);
        }
        this._query2Attribute = new int[queryFields.size()];
        for (int ii = 0; ii < queryFields.size(); ++ii) {
            AiShapeFieldDescriptor field = (AiShapeFieldDescriptor)queryFields.get(ii);
            this._query2Attribute[ii] = allFields.indexOf(field);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this._attributes.size()) {
            return null;
        }
        Attribute attrib = (Attribute)this._attributes.get(rowIndex);
        int fieldIdx = this._query2Attribute[columnIndex];
        if (fieldIdx < 0 || fieldIdx >= attrib.getNumberOfFields()) {
            return null;
        }
        return attrib.getField(fieldIdx);
    }

    @Override
    public int getRowCount() {
        return this._attributes.size();
    }

    public ShapeHighlight getShapeHighlight() {
        return this._shapeHighlight;
    }
}

