/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.stream;

import hec.map.WorldLine;
import hec.map.aishape.ShapeImport;
import hec.map.importer.ImportArc;
import hec.model.StreamPolyLine;
import java.util.List;
import java.util.Vector;

public class OrderedShapeStream
extends ShapeImport {
    public static final String FORWARD = "Forward";
    public static final String BACKWARD = "Backward";
    public static final String[] DIRECTIONS = new String[]{"Forward", "Backward"};
    private String _userName;
    boolean _hiToLow = true;
    StreamPolyLine _streamLine = new StreamPolyLine();

    public OrderedShapeStream(String shapeName) {
        super(shapeName);
        this.setType("Stream");
    }

    public StreamPolyLine getStreamPolyLine() {
        return this._streamLine;
    }

    @Override
    public boolean validate() {
        this.clearErrors();
        if (this.getShapeCount() < 1) {
            this.addError("No Shape Objects for " + this.getType() + " " + this.getName() + ".");
            return false;
        }
        Vector<WorldLine> remainingLines = new Vector<WorldLine>();
        List shapes = this.getShapes();
        for (int ii = shapes.size() - 1; ii >= 0; --ii) {
            ImportArc arc = (ImportArc)shapes.get(ii);
            Vector<WorldLine> arcLines = arc.getArcLines();
            for (int jj = arcLines.size() - 1; jj >= 0; --jj) {
                WorldLine wline = arcLines.get(jj);
                remainingLines.add(wline);
            }
        }
        if (!this.recurseLines(remainingLines)) {
            this.addError("Shapes in " + this.getType() + " " + this.getName() + " do not form a continuous line.");
            return false;
        }
        this._streamLine.validate();
        return true;
    }

    @Override
    public void removeExistsError() {
        this.removeError(this.getType() + " already exists.");
    }

    @Override
    public void addExistsError() {
        this.addError(this.getType() + " already exists.");
    }

    @Override
    public int getShapeGraphicType() {
        int type = 1;
        if (this.isBackwards()) {
            type = 2;
        }
        return type;
    }

    private boolean recurseLines(Vector worldLines) {
        Vector<WorldLine> remainingLines = new Vector<WorldLine>();
        for (int ii = 0; ii < worldLines.size(); ++ii) {
            WorldLine wline = (WorldLine)worldLines.get(ii);
            if (this._streamLine.add(wline)) continue;
            remainingLines.add(wline);
        }
        if (remainingLines.size() == 0) {
            return true;
        }
        if (worldLines.size() != remainingLines.size()) {
            return this.recurseLines(remainingLines);
        }
        return false;
    }

    public String getDirection() {
        if (this._hiToLow) {
            return FORWARD;
        }
        return BACKWARD;
    }

    public boolean isForward() {
        return this._hiToLow;
    }

    public boolean isBackwards() {
        return !this._hiToLow;
    }

    public void setDirection(String direction) {
        if (direction.equals(FORWARD)) {
            if (!this._hiToLow) {
                this._streamLine.reverseDirection();
                this._hiToLow = true;
            }
        } else if (direction.equals(BACKWARD) && this._hiToLow) {
            this._streamLine.reverseDirection();
            this._hiToLow = false;
        }
    }

    public void setUserName(String name) {
        this._userName = name;
    }

    public String getUserName() {
        return this._userName;
    }

    public String toString() {
        if (this._userName != null) {
            return this._userName;
        }
        return this.getName();
    }
}

