/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.stream;

import hec.map.aishape.stream.OrderedShapeStream;
import hec.map.aishape.stream.ShapeFileSelector;
import hec.map.aishape.stream.ShapeStreamAlignmentTableModel;
import hec.map.importer.AbstractShapeImportDialog;
import hec.map.importer.ShapeSource;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJTable;

public class ShapeStreamAlignmentDialog
extends AbstractShapeImportDialog {
    RmaJCheckBox _replaceExistingCheckBox;
    RmaJCheckBox _useGapCheckBox;
    RmaJDecimalField _gapSizeTextField;
    private JButton _reverseAllButton;
    private ShapeStreamAlignmentTableModel _tableModel;

    public ShapeStreamAlignmentDialog(Frame parent, boolean modal, Vector<ShapeSource> sourceList, ShapeSource selectedShapeSource, StreamAlignmentGlyph streamGlyph, ShapeFileSelector selector) {
        super(parent, modal, sourceList, selectedShapeSource, streamGlyph, selector);
        this.setTitle("Import Stream Alignment");
    }

    @Override
    protected void buildControls(List<ShapeSource> sourceList, ShapeSource selectedShapeSource, StreamAlignmentGlyph streamGlyph) {
        super.buildControls(sourceList, selectedShapeSource, streamGlyph);
        this._reverseAllButton = new JButton("Reverse Direction");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._buttonPanel.add((Component)this._reverseAllButton, gbc);
        this._useGapCheckBox = new RmaJCheckBox("Gap Tolerance:");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        this._optionsPanel.add((Component)this._useGapCheckBox, gbc);
        this._gapSizeTextField = new RmaJDecimalField(0, 3);
        this._gapSizeTextField.setEnabled(false);
        this._gapSizeTextField.setMinValue(0.0);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.ipadx = 50;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this._optionsPanel.add((Component)this._gapSizeTextField, gbc);
        this._replaceExistingCheckBox = new RmaJCheckBox("Replace Existing Stream Elements");
        this._replaceExistingCheckBox.setToolTipText("<html>Selecting this replaces the existing Stream Elements with the selected ones.<br>Replacement is done by matching the names of the Stream Elements.");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.001;
        gbc.weighty = 0.01;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this._optionsPanel.add((Component)this._replaceExistingCheckBox, gbc);
        this.enableImport(false);
        this._replaceExistingCheckBox.setSelected(this._model.getReplaceExisting());
        this.replaceExistingCheckboxAction();
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this._reverseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapeStreamAlignmentDialog.this.reverseAllAction();
            }
        });
        this._replaceExistingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapeStreamAlignmentDialog.this.replaceExistingCheckboxAction();
            }
        });
        this._availableFieldsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ShapeStreamAlignmentDialog.this.checkIfTableEditable();
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ShapeStreamAlignmentDialog.this.checkIfTableEditable();
            }
        });
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ShapeStreamAlignmentDialog.this.checkIfTableEditable();
            }
        });
        this._useGapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapeStreamAlignmentDialog.this.gapSizeCheckBoxAction();
            }
        });
    }

    private void checkIfTableEditable() {
        this.enableImport(false);
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            if (this._table.getValueAt(i, 1).equals(Boolean.TRUE)) {
                this.enableImport(true);
            }
            if (!this._table.isCellEditable(i, 2) || !this._table.getValueAt(i, 2).equals(Boolean.TRUE)) continue;
            this.enableImport(true);
        }
    }

    private void enableImport(boolean enable) {
        if (enable) {
            this._importAllButton.setEnabled(enable);
        } else if (!this._replaceExistingCheckBox.isSelected() && !enable) {
            this._importAllButton.setEnabled(enable);
        }
        this._importButton.setEnabled(enable);
        this._reverseAllButton.setEnabled(enable);
        this._importMenuItem.setEnabled(enable);
        this._flagAllMenuItem.setEnabled(enable);
        this._clearAllMenuItem.setEnabled(enable);
    }

    protected void replaceExistingCheckboxAction() {
        int rowCount = this._tableModel.getRowCount();
        boolean existingStreamAllowed = this._replaceExistingCheckBox.isSelected();
        boolean fireTableChanged = false;
        for (int i = 0; i < rowCount; ++i) {
            OrderedShapeStream shapeImport = (OrderedShapeStream)this._tableModel.getShapeImport(i);
            if (existingStreamAllowed) {
                shapeImport.removeExistsError();
                continue;
            }
            this._tableModel.checkExistance(shapeImport);
            fireTableChanged = true;
        }
        if (fireTableChanged) {
            this._tableModel.fireTableDataChanged();
        }
        this.replaceExistingChanged();
        this._table.revalidate();
        this._table.repaint();
        this.revalidate();
        this.checkIfTableEditable();
    }

    public void gapSizeCheckBoxAction() {
        if (this._useGapCheckBox.isSelected()) {
            this._gapSizeTextField.setEnabled(true);
        } else {
            this._gapSizeTextField.setEnabled(false);
        }
    }

    @Override
    public void reverseAllAction() {
        int rowCnt = this._table.getNumRows();
        for (int i = 0; i < rowCnt; ++i) {
            this._table.setValueAt(Boolean.TRUE, i, 2);
        }
        this._model.fireTableRowsUpdated(0, rowCnt - 1);
    }

    public void replaceExistingChanged() {
        this._model.setReplaceExisting(this._replaceExistingCheckBox.isSelected());
    }

    @Override
    public void importShapes() {
        boolean success = false;
        success = this._useGapCheckBox.isSelected() ? this._tableModel.importShapes(this._gapSizeTextField.getValue()) : this._model.importShapes();
        if (success) {
            if (this._streamAlignmentGlyph != null) {
                this._streamAlignmentGlyph.getMapPanel().updateExtents();
            }
            JOptionPane.showMessageDialog(this, "Stream Alignment imported successfully.");
            this.closeDialog();
        }
    }

    @Override
    protected ShapeStreamAlignmentTableModel createTableModel(RmaJTable table) {
        this._tableModel = new ShapeStreamAlignmentTableModel(this._table){
            boolean _firstTime;
            {
                this._firstTime = true;
            }

            @Override
            protected void hasErrors(boolean tf) {
                if (tf) {
                    return;
                }
                if (!this._firstTime) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ShapeStreamAlignmentDialog.this.isVisible()) {
                            return;
                        }
                        JOptionPane.showMessageDialog(_table, "Some streams formed by this grouping of features are not continuous lines.  These streams cannot be imported.", "Warning", 1);
                    }
                });
                this._firstTime = false;
            }
        };
        return this._tableModel;
    }

    @Override
    protected String getTypeString() {
        return "Streams";
    }

    @Override
    protected boolean isStreamAlignmentImporter() {
        return true;
    }
}

