/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.stream;

import hec.map.aishape.ShapeImport;
import hec.map.aishape.ShapeImportTableModel;
import hec.map.aishape.stream.OrderedShapeStream;
import hec.model.StreamElement;
import hec.model.StreamPolyLine;
import java.awt.EventQueue;
import java.util.List;
import rma.swing.RmaJTable;

public class ShapeStreamAlignmentTableModel
extends ShapeImportTableModel {
    private static final int REVERSE_COLUMN = 2;

    public ShapeStreamAlignmentTableModel(final RmaJTable table) {
        super(table);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                table.setCheckBoxCellEditor(2);
            }
        });
    }

    @Override
    public boolean importShapes() {
        return this.importShapes(0.0);
    }

    @Override
    public ShapeImport buildShapeImport(String name) {
        return new OrderedShapeStream(name);
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        this._table.setCheckBoxCellEditor(2);
    }

    public boolean importShapes(double gapTolerance) {
        StreamPolyLine streamPolyLine;
        OrderedShapeStream oss;
        String streamName;
        int ii;
        this.clearHighlights(true);
        List<String> shapeImportNames = this.getShapeImportNames();
        for (ii = 0; ii < shapeImportNames.size(); ++ii) {
            streamName = shapeImportNames.get(ii);
            oss = (OrderedShapeStream)this.getShapeImport(streamName);
            String userName = oss.getUserName();
            if (userName != null && userName.length() > 0) {
                streamName = userName;
            }
            if (!oss.getImportShapes()) continue;
            streamPolyLine = oss.getStreamPolyLine();
            if (this.getReplaceExisting()) {
                StreamElement stream = this._streamAlignmentGlyph.findReach(streamName);
                if (stream != null) {
                    stream.setLine(streamPolyLine);
                }
            } else {
                StreamElement streamElement = this._streamAlignmentGlyph.createElement(streamName, streamPolyLine, 0.0, false);
            }
            if (!oss.isBackwards()) continue;
            streamPolyLine.reverseDirection();
        }
        for (ii = 0; ii < shapeImportNames.size(); ++ii) {
            streamName = shapeImportNames.get(ii);
            oss = (OrderedShapeStream)this.getShapeImport(streamName);
            if (!oss.getImportShapes() || !oss.isBackwards()) continue;
            streamPolyLine = oss.getStreamPolyLine();
            streamPolyLine.reverseDirection();
        }
        this._streamAlignmentGlyph.connectAlignment(gapTolerance);
        this._streamAlignmentGlyph.getStreamAlignment().setCoordinateReferenceSystem(this._shapeSource.getCoordinateReferenceSystem());
        this.fillModel();
        return true;
    }

    @Override
    public void checkExistance(ShapeImport shapeImport) {
        String streamName = shapeImport.getName();
        StreamElement reach = this._streamAlignmentGlyph.findReach(streamName);
        if (reach != null) {
            shapeImport.addExistsError();
        } else {
            shapeImport.removeExistsError();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return "Reverse Direction";
            }
        }
        return super.getColumnName(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        String shapeName = (String)this._shapeImportNames.get(rowIndex);
        ShapeImport shapeImport = (ShapeImport)this._shapeImportHash.get(shapeName);
        if (columnIndex == 2) {
            Boolean bool = aValue instanceof Boolean ? (Boolean)aValue : Boolean.valueOf(Boolean.parseBoolean(aValue.toString()));
            String dir = bool != false ? "Backward" : "Forward";
            ((OrderedShapeStream)shapeImport).setDirection(dir);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (columnIndex == 0) {
            OrderedShapeStream streamImport = (OrderedShapeStream)shapeImport;
            if (aValue != null && aValue.toString().length() > 0) {
                streamImport.setUserName(aValue.toString());
            } else {
                streamImport.setUserName(null);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String shapeName = (String)this._shapeImportNames.get(rowIndex);
        OrderedShapeStream shapeImport = (OrderedShapeStream)this._shapeImportHash.get(shapeName);
        if (columnIndex == 2) {
            return shapeImport.isBackwards();
        }
        if (columnIndex == 0) {
            String name = shapeImport.getUserName();
            if (name == null || name.length() == 0) {
                return shapeName;
            }
            return name;
        }
        return super.getValueAt(rowIndex, columnIndex);
    }
}

