/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.stream;

import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.WorldLine;
import hec.map.aishape.AiShapeArc;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamElement;
import java.util.Vector;

public class StreamAlignmentToShapefile {
    public static final String STREAM_ID_FIELD = "Stream_ID";
    public static final int STREAM_ID_FIELD_LENGTH = 32;

    public static boolean exportToShapefile(StreamAlignmentIfc streamAlignment, Identifier shapefileId) {
        AiShapeMap map = new AiShapeMap(new MapIdentifier(shapefileId));
        CoordinateReferenceSystem crs = streamAlignment.getCoordinateReferenceSystem();
        map.setCoordinateReferenceSystem(crs);
        Vector streamElements = streamAlignment.getElementVector();
        Vector<AiShapeArc> shapes = new Vector<AiShapeArc>(streamElements.size());
        Vector<Attribute> attributes = new Vector<Attribute>(streamElements.size());
        Vector<AiShapeFieldDescriptor> fieldDescriptors = new Vector<AiShapeFieldDescriptor>();
        AiShapeFieldDescriptor fieldDescriptor = new AiShapeFieldDescriptor(STREAM_ID_FIELD, 'C', 32, 0);
        fieldDescriptors.add(fieldDescriptor);
        for (int ii = 0; ii < streamElements.size(); ++ii) {
            StreamElement reach = (StreamElement)streamElements.get(ii);
            Field[] fields = new Field[]{new Field(reach.getName(), fieldDescriptor, ii + 1)};
            Attribute attr = new Attribute(ii + 1, fields);
            attributes.add(attr);
            Vector<WorldLine> worldLines = new Vector<WorldLine>();
            worldLines.add(reach.getLine());
            AiShapeArc arc = new AiShapeArc(ii + 1, worldLines);
            arc.setAttribute(attr);
            shapes.add(arc);
        }
        map.writeData(3, fieldDescriptors, shapes, attributes);
        return true;
    }
}

