/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AiShapeFilePropertiesDialog;
import hec.map.aishape.ui.AiShapePropertiesPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.JDOMException;

public abstract class AiGlyphDataRecordPropertiesDialog
extends AiShapeFilePropertiesDialog
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(AiGlyphDataRecordPropertiesDialog.class.getName());
    private String _filename;
    private AiShapeMap _map = new AiShapeMap();

    public AiGlyphDataRecordPropertiesDialog(Frame parent, boolean modal, String title) {
        super(parent, modal, title);
        this.pack();
        Dimension d = this.getSize();
        d.height += 75;
        this.setSize(d);
        this.addPropertyChangeListener(this);
    }

    public void setData(String gdrFile) {
        this._filename = gdrFile;
        File file = new File(gdrFile);
        if (!file.exists()) {
            LOGGER.log(Level.INFO, "File does not exist: " + gdrFile + ". Creating the file.");
            if (!AiGlyphDataRecordPropertiesDialog.createDefaultGDRFile(this._filename)) {
                return;
            }
        }
        AiShapeGlyphDataRecord dataRecord = new AiShapeGlyphDataRecord();
        try (BufferedReader rdr = new BufferedReader(new FileReader(gdrFile));){
            dataRecord.deserialize(rdr);
        }
        catch (IOException | JDOMException e1) {
            LOGGER.log(Level.SEVERE, "Cannot read file: " + gdrFile);
            return;
        }
        if (this._map.getMapIdentifier() == null) {
            this.mNameFld.setVisible(false);
        } else {
            this.mNameFld.setText(this._map.getName());
        }
        this.mDataRecord = dataRecord;
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            AiShapePropertiesPanel panel = (AiShapePropertiesPanel)this.mPanelList.get(i);
            panel.setData(dataRecord, this._map);
        }
        this.setModified(false);
    }

    public static boolean createDefaultGDRFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to create default GDR file: " + filename);
                return false;
            }
        }
        if (!file.canWrite()) {
            LOGGER.log(Level.SEVERE, "Unable to create default GDR file: " + filename);
            return false;
        }
        AiShapeGlyphDataRecord dr = new AiShapeGlyphDataRecord();
        try (BufferedWriter br = new BufferedWriter(new FileWriter(filename));){
            dr.serialize(br);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unable to create default GDR file: " + filename);
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "apply".equals(evt.getPropertyName()) && this.equals(evt.getSource()) && this._filename != null) {
            try (BufferedWriter br = new BufferedWriter(new FileWriter(this._filename));){
                this.mDataRecord.serialize(br);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to write GDR file: " + this._filename);
            }
        }
    }
}

