/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.JLayerSelection;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AiShapePropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDialog;

public class AiShapeFilePropertiesDialog
extends RmaJDialog {
    JTabbedPane mTabbedPane;
    List<AiShapePropertiesPanel> mPanelList = null;
    AiShapeGlyphDataRecord mDataRecord = null;
    JLayerSelection mLayerSelection = null;
    JTextField mNameFld;
    static final String APPLY = "apply";
    ButtonCmdPanel cmdPanel;

    public AiShapeFilePropertiesDialog(Frame parent, boolean modal, String title) {
        super(parent, modal);
        this.setTitle(title);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new BorderLayout());
        this.mNameFld = new JTextField();
        this.mNameFld.setEditable(false);
        this.getContentPane().add((Component)this.mNameFld, "North");
        this.mTabbedPane = new JTabbedPane();
        this.mPanelList = this.createPropertiesPanels();
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            AiShapePropertiesPanel panel = this.mPanelList.get(i);
            this.mTabbedPane.add((Component)((Object)panel), panel.getTitle());
        }
        this.getContentPane().add((Component)this.mTabbedPane, "Center");
        this.cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)this.cmdPanel, "South");
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        AiShapeFilePropertiesDialog.this.buttonOkActionPerformed();
                        break;
                    }
                    case 2: {
                        AiShapeFilePropertiesDialog.this.buttonApplyActionPerformed();
                        break;
                    }
                    case 4: {
                        AiShapeFilePropertiesDialog.this.buttonCancelActionPerformed();
                    }
                }
            }
        });
    }

    public void addButtonCmdPanelListener(ButtonCmdPanelListener listener) {
        this.cmdPanel.addCmdPanelListener(listener);
    }

    private void buttonApplyActionPerformed() {
        for (int i = 0; this.mPanelList != null && i < this.mPanelList.size(); ++i) {
            AiShapePropertiesPanel panel = this.mPanelList.get(i);
            panel.saveData();
        }
        if (this.mDataRecord != null) {
            if (this.mLayerSelection != null) {
                this.mLayerSelection.setDataRecord(this.mDataRecord);
            }
            this.mDataRecord.setModified(true);
            this.mDataRecord.notifyObservers(this.mLayerSelection);
        }
        this.firePropertyChange(APPLY, false, true);
        this.setModified(false);
    }

    private void buttonOkActionPerformed() {
        this.buttonApplyActionPerformed();
        this.setModified(false);
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed() {
        this.setVisible(false);
    }

    public List<AiShapePropertiesPanel> createPropertiesPanels() {
        return new ArrayList<AiShapePropertiesPanel>();
    }

    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        if (aiShapeMap != null) {
            this.mNameFld.setText(aiShapeMap.getName());
        }
        this.mDataRecord = dataRecord;
        for (int i = 0; i < this.mPanelList.size(); ++i) {
            AiShapePropertiesPanel panel = this.mPanelList.get(i);
            panel.setData(dataRecord, aiShapeMap);
        }
        this.setModified(false);
    }

    public void setLayerSelection(JLayerSelection layerSelection) {
        this.mLayerSelection = layerSelection;
    }
}

