/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.MapLabelItem;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.FontChooserPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;
import rma.util.RMAUtil;

public class AiShapePointLabelsPanel
extends AbstractAiShapeProperitesPanel {
    JComboBox mFieldComboBox = null;
    RmaJComboBox mPositionComboBox = null;
    FontChooserPanel mFontChooserPanel = null;
    JSlider mRotationSlider = null;
    AiShapeGlyphDataRecord mGlyphDataRecord = null;

    public AiShapePointLabelsPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Label features using:"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)panel, gbc);
        this.mFieldComboBox = new RmaJComboBox();
        ((RmaJComboBox)this.mFieldComboBox).setModifiable(true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        panel.add((Component)this.mFieldComboBox, gbc);
        this.mFontChooserPanel = new FontChooserPanel(null);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this.mFontChooserPanel, gbc);
        JPanel placemenPanel = new JPanel(new GridBagLayout());
        placemenPanel.setBorder(BorderFactory.createTitledBorder("Placement"));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)placemenPanel, gbc);
        JLabel label = new JLabel("Position:");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        placemenPanel.add((Component)label, gbc);
        this.mPositionComboBox = new RmaJComboBox<String>(MapLabelItem.POSITION_STRINGS);
        this.mPositionComboBox.setModifiable(true);
        this.mPositionComboBox.setSelectedIndex(0);
        label.setLabelFor(this.mPositionComboBox);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        placemenPanel.add((Component)this.mPositionComboBox, gbc);
        label = new JLabel("Rotation");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        placemenPanel.add((Component)label, gbc);
        this.mRotationSlider = new JSlider();
        this.mRotationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(AiShapePointLabelsPanel.this.mRotationSlider);
            }
        });
        this.mRotationSlider.setMinimum(0);
        this.mRotationSlider.setMaximum(360);
        this.mRotationSlider.setMajorTickSpacing(90);
        this.mRotationSlider.setMinorTickSpacing(45);
        this.mRotationSlider.setPaintLabels(true);
        this.mRotationSlider.setPaintTicks(true);
        label.setLabelFor(this.mRotationSlider);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5005;
        placemenPanel.add((Component)this.mRotationSlider, gbc);
    }

    @Override
    public String getTitle() {
        return "Labels";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        int index;
        ArrayList fieldDescriptors = new ArrayList();
        if (aiShapeMap != null) {
            fieldDescriptors.addAll(aiShapeMap.getFieldDescriptors());
        }
        ArrayList<String> finalList = new ArrayList<String>();
        finalList.add("<None>");
        finalList.addAll(fieldDescriptors);
        this.mFieldComboBox.setModel(new RmaListModel(false, finalList));
        this.mFieldComboBox.setSelectedIndex(0);
        this.mGlyphDataRecord = dataRecord;
        Font labelFont = dataRecord.getLabelFont();
        this.mFontChooserPanel.setSelectedFont(labelFont);
        double rotation = dataRecord.getLabelRotation();
        this.mRotationSlider.setValue((int)rotation);
        int selectedIndex = this.mGlyphDataRecord.getLabelPosition();
        if (selectedIndex >= 0 && selectedIndex < this.mPositionComboBox.getItemCount()) {
            this.mPositionComboBox.setSelectedIndex(selectedIndex);
        }
        if ((index = this.mGlyphDataRecord.getLabelFieldIndex() + 1) < 0) {
            index = 0;
        }
        this.mFieldComboBox.setSelectedIndex(index);
    }

    @Override
    public void saveData() {
        if (this.mGlyphDataRecord == null) {
            return;
        }
        this.mGlyphDataRecord.setLabelRotation(this.mRotationSlider.getValue());
        this.mGlyphDataRecord.setLabelFont(this.mFontChooserPanel.getSelectedFont());
        this.mGlyphDataRecord.setLabelPosition(this.mPositionComboBox.getSelectedIndex());
        int index = this.mFieldComboBox.getSelectedIndex() - 1;
        this.mGlyphDataRecord.setLabelFieldIndex(index);
    }
}

