/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.list.LinePatternRenderer;
import rma.swing.list.LineWidthRenderer;
import rma.util.RmaDrawConst;

public class AiShapePolygonBorderPanel
extends AbstractAiShapeProperitesPanel {
    public static final float[] SOLID_LINE = new float[]{50.0f};
    LinePatternRenderer mBorderLinePatternRenderer = new LinePatternRenderer(Color.blue);
    private RmaJColorComboBox mBorderColorComboBox;
    private RmaJCheckBox mDisplayBorder;
    private RmaJComboBox mBorderStyleComboBox;
    private RmaJComboBox mBorderWeightComboBox;
    LineWidthRenderer mLineWidthRenderer = new LineWidthRenderer(Color.blue);
    AiShapeGlyphDataRecord mGlyphRecord = null;

    public AiShapePolygonBorderPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.mDisplayBorder = new RmaJCheckBox("Display Border");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 0;
        this.add((Component)this.mDisplayBorder, gbc);
        JLabel label = new JLabel("Color");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.ipady = 0;
        this.add((Component)label, gbc);
        this.mBorderColorComboBox = new RmaJColorComboBox();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mBorderColorComboBox, gbc);
        this.mBorderColorComboBox.setSelectedColor(Color.blue);
        this.mBorderColorComboBox.setModifiable(true);
        this.mBorderColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c2 = AiShapePolygonBorderPanel.this.mBorderColorComboBox.getSelectedColor();
                if (c2 != null) {
                    AiShapePolygonBorderPanel.this.mBorderLinePatternRenderer.setColor(c2);
                    AiShapePolygonBorderPanel.this.mLineWidthRenderer.setColor(c2);
                    AiShapePolygonBorderPanel.this.mBorderStyleComboBox.repaint();
                    AiShapePolygonBorderPanel.this.mBorderWeightComboBox.repaint();
                }
            }
        });
        label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.ipady = 0;
        this.add((Component)label, gbc);
        this.mBorderStyleComboBox = new RmaJComboBox();
        this.mBorderStyleComboBox.setModifiable(true);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{SOLID_LINE, RmaDrawConst.DASH_STYLE_PATTERN, RmaDrawConst.DOT_STYLE_PATTERN, RmaDrawConst.DASHDOT_STYLE_PATTERN, RmaDrawConst.DASHDOTDOT_STYLE_PATTERN});
        this.mBorderStyleComboBox.setModel(comboModel);
        this.mBorderStyleComboBox.setRenderer(this.mBorderLinePatternRenderer);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 0;
        this.add((Component)this.mBorderStyleComboBox, gbc);
        label = new JLabel("Weight");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.ipady = 0;
        this.add((Component)label, gbc);
        this.mBorderWeightComboBox = new RmaJComboBox();
        this.mBorderWeightComboBox.setModifiable(true);
        comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Float(1.0f), new Float(2.0f), new Float(3.0f), new Float(4.0f), new Float(5.0f), new Float(6.0f), new Float(7.0f), new Float(8.0f), new Float(9.0f), new Float(10.0f)});
        this.mBorderWeightComboBox.setModel(comboModel);
        this.mBorderWeightComboBox.setRenderer(this.mLineWidthRenderer);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 0;
        this.add((Component)this.mBorderWeightComboBox, gbc);
    }

    @Override
    public String getTitle() {
        return "Border";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        this.mGlyphRecord = dataRecord;
        if (this.mGlyphRecord == null) {
            return;
        }
        this.mDisplayBorder.setSelected(this.mGlyphRecord.isBorderDisplayed());
        float[] lineStyle = this.mGlyphRecord.getBorderLineStyle();
        if (lineStyle == null) {
            this.mBorderStyleComboBox.setSelectedItem(SOLID_LINE);
        } else {
            ComboBoxModel propertiesModel = this.mBorderStyleComboBox.getModel();
            for (int i = 0; i < propertiesModel.getSize(); ++i) {
                if (!Arrays.equals(lineStyle, (float[])propertiesModel.getElementAt(i))) continue;
                this.mBorderStyleComboBox.setSelectedIndex(i);
                break;
            }
        }
        Color borderColor = this.mGlyphRecord.getBorderLineColor();
        this.mBorderColorComboBox.setSelectedColor(borderColor);
        Float width = new Float(this.mGlyphRecord.getBorderWidth());
        this.mBorderWeightComboBox.setSelectedItem(width);
    }

    @Override
    public void saveData() {
        if (this.mGlyphRecord == null) {
            return;
        }
        this.mGlyphRecord.setDisplayBorder(this.mDisplayBorder.isSelected());
        float[] lineStyle = (float[])this.mBorderStyleComboBox.getSelectedItem();
        if (lineStyle == SOLID_LINE) {
            lineStyle = null;
        }
        this.mGlyphRecord.setBorderLineStyle(lineStyle);
        Color borderColor = this.mBorderColorComboBox.getSelectedColor();
        this.mGlyphRecord.setBorderLineColor(borderColor);
        int width = ((Float)this.mBorderWeightComboBox.getSelectedItem()).intValue();
        this.mGlyphRecord.setBorderWidth(width);
    }
}

