/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import hec.map.aishape.ui.AiShapePropertiesPanel;
import hec.map.aishape.ui.SinglePolygonSymbolPanel;
import hec.map.aishape.ui.UniquePolygonSymbolPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;

public class AiShapePolygonSymbolPanel
extends AbstractAiShapeProperitesPanel {
    RmaJCheckBox mFillPolygons = null;
    JPanel mPanelContainer = null;
    AiShapePropertiesPanel mUniqueSymbolPanel = null;
    AiShapePropertiesPanel mSingleSymbolPanel = null;
    AiShapeGlyphDataRecord mRecord = null;

    public AiShapePolygonSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Draw Features using:"));
        panel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)panel, gbc);
        this.mDrawingFeatureComboBox = new RmaJComboBox();
        this.mDrawingFeatureComboBox.setModifiable(true);
        RmaListModel<String> model = new RmaListModel<String>(false, "One Style", "Attribute Values");
        this.mDrawingFeatureComboBox.setModel(model);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        panel.add((Component)this.mDrawingFeatureComboBox, gbc);
        this.mFillPolygons = new RmaJCheckBox("Display Fill");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0500;
        this.add((Component)this.mFillPolygons, gbc);
        this.mPanelContainer = new JPanel(new CardLayout());
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)this.mPanelContainer, gbc);
        this.mSingleSymbolPanel = new SinglePolygonSymbolPanel();
        this.mPanelContainer.add((Component)((JPanel)((Object)this.mSingleSymbolPanel)), "One Style");
        this.mUniqueSymbolPanel = new UniquePolygonSymbolPanel();
        this.mPanelContainer.add((Component)((JPanel)((Object)this.mUniqueSymbolPanel)), "Attribute Values");
        ((CardLayout)this.mPanelContainer.getLayout()).show(this.mPanelContainer, "Attribute Values");
        this.mDrawingFeatureComboBox.setSelectedItem("Attribute Values");
        this.mDrawingFeatureComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = AiShapePolygonSymbolPanel.this.mDrawingFeatureComboBox.getSelectedItem();
                if (obj == null) {
                    return;
                }
                ((CardLayout)AiShapePolygonSymbolPanel.this.mPanelContainer.getLayout()).show(AiShapePolygonSymbolPanel.this.mPanelContainer, obj.toString());
            }
        });
    }

    @Override
    public String getTitle() {
        return "Fill";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        if (dataRecord != null) {
            this.mRecord = dataRecord;
            String layoutType = dataRecord.getSymbolDrawType() == 0 ? "One Style" : "Attribute Values";
            ((CardLayout)this.mPanelContainer.getLayout()).show(this.mPanelContainer, layoutType);
            this.mDrawingFeatureComboBox.setSelectedItem(layoutType);
            int symbolDrawType = this.mRecord.getSymbolDrawType();
            if (symbolDrawType == 0) {
                this.mDrawingFeatureComboBox.setSelectedItem("One Style");
            } else {
                this.mDrawingFeatureComboBox.setSelectedItem("Attribute Values");
            }
            this.mFillPolygons.setSelected(this.mRecord.getDrawAreas());
        }
        this.mUniqueSymbolPanel.setData(dataRecord, aiShapeMap);
        this.mSingleSymbolPanel.setData(dataRecord, aiShapeMap);
        if (aiShapeMap == null) {
            RmaListModel<String> model = new RmaListModel<String>(false, "One Style");
            this.mDrawingFeatureComboBox.setModel(model);
            this.mDrawingFeatureComboBox.setSelectedItem("One Style");
        }
    }

    @Override
    public void saveData() {
        Object layoutType = this.mDrawingFeatureComboBox.getSelectedItem();
        int type = 0;
        if ("One Style".equals(layoutType)) {
            type = 0;
            this.mSingleSymbolPanel.saveData();
        } else {
            type = 1;
            this.mUniqueSymbolPanel.saveData();
        }
        if (this.mRecord != null) {
            this.mRecord.setSymbolDrawType(type);
            this.mRecord.setDrawAreas(this.mFillPolygons.isSelected());
        }
    }
}

