/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapeUtilities;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.aishape.ShapeDrawingAttribute;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.ColorContour;

public class FieldColorTableModel
extends AbstractRmaTableModel
implements PropertyChangeListener {
    AiShapeMap mMap = null;
    AiShapeGlyphDataRecord mDataRecord = null;
    List<Attribute> mAttributeList = null;
    List<String> mAttributeGradList = null;
    List<Color> mColorImageList = null;
    int mFieldIdx = -1;
    Map<Attribute, Integer> mAttributeToRow = new HashMap<Attribute, Integer>();
    ColorContour mColorContour = null;
    boolean mUseGradations = false;
    int mNumGradations = 5;

    public FieldColorTableModel() {
        this.m_columnNames = new String[]{"Color", "Value"};
        this.mAttributeGradList = new ArrayList<String>();
    }

    public void commitData() {
        HashMap<Object, Color> dataMap = new HashMap<Object, Color>();
        if (this.mAttributeList != null) {
            for (int i = 0; i < this.mAttributeList.size(); ++i) {
                Color color;
                Attribute attrib = this.mAttributeList.get(i);
                int iRow = i;
                if (this.mUseGradations) {
                    Integer row = this.mAttributeToRow.get(attrib);
                    if (row == null) continue;
                    iRow = row;
                }
                if ((color = this.mColorImageList.get(iRow)) == null) {
                    color = this.mColorContour.getColor(iRow);
                }
                dataMap.put(attrib.getField(this.mFieldIdx).getValue(), color);
            }
            Vector<Attribute> list = this.mMap.getAttributes();
            for (int i = 0; i < list.size(); ++i) {
                Attribute attrib = (Attribute)list.get(i);
                Field f = attrib.getField(this.mFieldIdx);
                ShapeDrawingAttribute drawAttrib = this.mDataRecord.getDrawingAttribute(f);
                Color c2 = (Color)dataMap.get(f.getValue());
                drawAttrib.setColor(c2);
            }
        }
    }

    public void setNumGradations(int numGradations) {
        this.mNumGradations = numGradations;
        this.resetAttriuteList();
        this.resetColorImageList();
        this.fireTableDataChanged();
    }

    public void setUseGradations(boolean b) {
        this.mUseGradations = b;
        this.resetAttriuteList();
        this.resetColorImageList();
        this.fireTableDataChanged();
    }

    public void setData(AiShapeMap map, AiShapeGlyphDataRecord record, int fieldIdx) {
        this.mMap = map;
        this.mDataRecord = record;
        this.mFieldIdx = fieldIdx;
        this.resetAttriuteList();
        this.resetColorImageList();
        int attributeListSize = 0;
        if (this.mAttributeList != null) {
            attributeListSize = this.mAttributeList.size();
        }
        for (int i = 0; !record.drawUsingDefaultColor() && i < this.mAttributeList.size(); ++i) {
            ShapeDrawingAttribute sda;
            Field f;
            Attribute atb = this.mAttributeList.get(i);
            if (atb == null || (f = atb.getField(fieldIdx)) == null || (sda = record.getDrawingAttribute(f)) == null) continue;
            int row = i;
            if (this.mUseGradations) {
                row = this.mAttributeToRow.get(atb);
            }
            this.mColorImageList.set(row, sda.getColor());
        }
        this.fireTableDataChanged();
    }

    private void resetAttriuteList() {
        this.mAttributeList = null;
        if (this.mMap == null) {
            return;
        }
        this.mAttributeList = AiShapeUtilities.getUniqueAttributeList(this.mMap, this.mFieldIdx);
        this.mAttributeGradList = new ArrayList<String>();
        this.mAttributeToRow.clear();
        if (this.mAttributeList.size() == 0) {
            return;
        }
        if (this.mUseGradations) {
            int numItemsPerRow = (int)Math.ceil((double)this.mAttributeList.size() / (double)this.mNumGradations);
            for (int i = 0; i < this.mNumGradations; ++i) {
                Field f;
                int lowIdx = i * numItemsPerRow;
                int highIdx = (i + 1) * numItemsPerRow - 1;
                if (highIdx > this.mAttributeList.size() - 1) {
                    highIdx = this.mAttributeList.size() - 1;
                }
                if (lowIdx >= this.mAttributeList.size() || highIdx >= this.mAttributeList.size()) continue;
                Attribute lowAttrib = this.mAttributeList.get(lowIdx);
                Attribute highAttrib = this.mAttributeList.get(highIdx);
                Object value = "";
                if (lowAttrib != null) {
                    f = lowAttrib.getField(this.mFieldIdx);
                    value = (String)value + (f != null ? f.getValue() : "");
                }
                value = (String)value + " - ";
                if (highAttrib != null) {
                    f = highAttrib.getField(this.mFieldIdx);
                    value = (String)value + (f != null ? f.getValue() : "");
                }
                this.mAttributeGradList.add((String)value);
                for (int j = lowIdx; j <= highIdx; ++j) {
                    this.mAttributeToRow.put(this.mAttributeList.get(j), i);
                }
            }
        }
    }

    public void setFieldIndex(int fieldIdx) {
        this.mFieldIdx = fieldIdx;
        this.resetAttriuteList();
        this.resetColorImageList();
        this.fireTableDataChanged();
    }

    public void setColorContour(ColorContour colorContour) {
        if (this.mColorContour != null) {
            this.mColorContour.removePropertyChangeSupport(this);
        }
        this.mColorContour = colorContour;
        if (this.mColorContour != null) {
            this.mColorContour.addPropertyChangeListener(this);
        }
        this.resetColorImageList();
        this.fireTableDataChanged();
    }

    private void resetColorImageList() {
        int rowCount = this.getRowCount();
        this.mColorImageList = new ArrayList<Color>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.mColorImageList.add(null);
        }
        if (this.mColorContour != null) {
            this.mColorContour.setMinValue(0.0);
            this.mColorContour.setMaxValue(this.getRowCount() - 1);
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        if (column < 0 || column >= this.getColumnCount()) {
            return;
        }
        if (aValue == null || !(aValue instanceof Color)) {
            return;
        }
        this.mColorImageList.set(row, (Color)aValue);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Field field;
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (column < 0 || column >= this.getColumnCount()) {
            return null;
        }
        if (column == 0) {
            Color img = null;
            if (row < this.mColorImageList.size()) {
                img = this.mColorImageList.get(row);
            }
            if (this.mColorContour == null) {
                return null;
            }
            if (img != null) {
                return img;
            }
            img = this.mColorContour.getColor(row);
            this.mColorImageList.set(row, img);
            return img;
        }
        if (this.mUseGradations) {
            return this.mAttributeGradList.get(row);
        }
        Attribute attribute = this.mAttributeList.get(row);
        if (attribute != null && (field = attribute.getField(this.mFieldIdx)) != null) {
            return ((Object)field).toString();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.mUseGradations) {
            return this.mAttributeGradList != null ? this.mAttributeGradList.size() : 0;
        }
        return this.mAttributeList != null ? this.mAttributeList.size() : 0;
    }

    Image makeImage(Color clr) {
        int i;
        int w = 14;
        int h = 14;
        int myClr = clr.getRGB();
        int[] pix = new int[w * h];
        for (int i2 = 0; i2 < pix.length; ++i2) {
            pix[i2] = myClr;
        }
        int lastrow = pix.length - w;
        int blk = Color.black.getRGB();
        for (i = 0; i < w; ++i) {
            pix[i] = blk;
            pix[i + lastrow] = blk;
        }
        for (i = 0; i < pix.length - w; i += w) {
            pix[i] = blk;
            pix[i + w - 1] = blk;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        return img;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.resetColorImageList();
        this.fireTableDataChanged();
    }
}

