/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.list.LinePatternRenderer;
import rma.swing.list.LineWidthRenderer;
import rma.util.RmaDrawConst;

public class SingleLineSymbolPanel
extends AbstractAiShapeProperitesPanel {
    public static final float[] SOLID_LINE = new float[]{50.0f};
    RmaJColorComboBox mColorComboBox;
    RmaJComboBox mStyleComboBox;
    RmaJComboBox mWeightComboBox;
    LineWidthRenderer mLineWidthRenderer = new LineWidthRenderer(Color.blue);
    LinePatternRenderer mLinePatternRenderer = new LinePatternRenderer(Color.blue);
    AiShapeGlyphDataRecord mGlyphDataRecord = null;

    public SingleLineSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Color");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mColorComboBox = new RmaJColorComboBox();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mColorComboBox, gbc);
        this.mColorComboBox.setSelectedColor(Color.blue);
        this.mColorComboBox.setModifiable(true);
        this.mColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c2 = SingleLineSymbolPanel.this.mColorComboBox.getSelectedColor();
                if (c2 != null) {
                    SingleLineSymbolPanel.this.mLinePatternRenderer.setColor(c2);
                    SingleLineSymbolPanel.this.mLineWidthRenderer.setColor(c2);
                    SingleLineSymbolPanel.this.mStyleComboBox.repaint();
                    SingleLineSymbolPanel.this.mWeightComboBox.repaint();
                }
            }
        });
        label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mStyleComboBox = new RmaJComboBox();
        this.mStyleComboBox.setModifiable(true);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{SOLID_LINE, RmaDrawConst.DASH_STYLE_PATTERN, RmaDrawConst.DOT_STYLE_PATTERN, RmaDrawConst.DASHDOT_STYLE_PATTERN, RmaDrawConst.DASHDOTDOT_STYLE_PATTERN});
        this.mStyleComboBox.setModel(comboModel);
        this.mStyleComboBox.setRenderer(this.mLinePatternRenderer);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 0;
        this.add((Component)this.mStyleComboBox, gbc);
        label = new JLabel("Weight");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5550;
        this.add((Component)label, gbc);
        this.mWeightComboBox = new RmaJComboBox();
        this.mWeightComboBox.setModifiable(true);
        comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Float(1.0f), new Float(2.0f), new Float(3.0f), new Float(4.0f), new Float(5.0f), new Float(6.0f), new Float(7.0f), new Float(8.0f), new Float(9.0f), new Float(10.0f)});
        this.mWeightComboBox.setModel(comboModel);
        this.mWeightComboBox.setRenderer(this.mLineWidthRenderer);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 0;
        this.add((Component)this.mWeightComboBox, gbc);
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        this.mGlyphDataRecord = dataRecord;
        if (this.mGlyphDataRecord == null) {
            return;
        }
        float[] lineStyle = this.mGlyphDataRecord.getBorderLineStyle();
        if (lineStyle == null) {
            this.mStyleComboBox.setSelectedItem(SOLID_LINE);
        } else {
            ComboBoxModel propertiesModel = this.mStyleComboBox.getModel();
            for (int i = 0; i < propertiesModel.getSize(); ++i) {
                if (!Arrays.equals(lineStyle, (float[])propertiesModel.getElementAt(i))) continue;
                this.mStyleComboBox.setSelectedIndex(i);
                break;
            }
        }
        Float width = new Float(this.mGlyphDataRecord.getBorderWidth());
        this.mWeightComboBox.setSelectedItem(width);
        Color c2 = this.mGlyphDataRecord.getDefaultColor();
        if (c2 == null) {
            this.mColorComboBox.setSelectedIndex(0);
        } else {
            this.mColorComboBox.setSelectedColor(c2);
        }
    }

    @Override
    public void saveData() {
        if (this.mGlyphDataRecord == null) {
            return;
        }
        Color c2 = this.mColorComboBox.getSelectedColor();
        this.mGlyphDataRecord.setDefaultColor(c2);
        this.mGlyphDataRecord.setDrawUsingDefaultColor(true);
        Float fillStyle = (Float)this.mWeightComboBox.getSelectedItem();
        this.mGlyphDataRecord.setBorderWidth(fillStyle.intValue());
        float[] lineStyle = (float[])this.mStyleComboBox.getSelectedItem();
        if (lineStyle == SOLID_LINE) {
            lineStyle = null;
        }
        this.mGlyphDataRecord.setBorderLineStyle(lineStyle);
    }
}

