/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.list.FillPatternRenderer;
import rma.swing.list.LinePatternRenderer;
import rma.util.RMAUtil;

public class SinglePolygonSymbolPanel
extends AbstractAiShapeProperitesPanel {
    public static final float[] SOLID_LINE = new float[]{50.0f};
    RmaJComboBox mStyleComboBox = null;
    RmaJColorComboBox mColorComboBox = null;
    LinePatternRenderer mBorderLinePatternRenderer = new LinePatternRenderer(Color.blue);
    FillPatternRenderer mFillPatternRenderer = new FillPatternRenderer();
    JTextField mAlphaTxt = null;
    JSlider mAlphaSlider;
    AiShapeGlyphDataRecord mDataRecord = null;

    public SinglePolygonSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Color");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mColorComboBox = new RmaJColorComboBox();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mColorComboBox, gbc);
        this.mColorComboBox.setSelectedColor(Color.blue);
        this.mColorComboBox.setModifiable(true);
        this.mColorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c2 = SinglePolygonSymbolPanel.this.mColorComboBox.getSelectedColor();
                if (c2 != null) {
                    SinglePolygonSymbolPanel.this.mFillPatternRenderer.setColor(c2);
                    SinglePolygonSymbolPanel.this.mStyleComboBox.repaint();
                }
            }
        });
        label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.ipady = 0;
        this.add((Component)label, gbc);
        this.mStyleComboBox = new RmaJComboBox();
        this.mStyleComboBox.setModifiable(true);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(4), new Integer(3), new Integer(5), new Integer(6)});
        this.mStyleComboBox.setModel(comboModel);
        this.mStyleComboBox.setModifiable(true);
        this.mFillPatternRenderer.setColor(Color.blue);
        this.mStyleComboBox.setRenderer(this.mFillPatternRenderer);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mStyleComboBox, gbc);
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new TitledBorder("Transparency"));
        sizePanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)sizePanel, gbc);
        this.mAlphaTxt = new JTextField();
        this.mAlphaTxt.setEditable(false);
        final JTextField tempAlphaTxt = this.mAlphaTxt;
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        sizePanel.add((Component)this.mAlphaTxt, gbc);
        this.mAlphaSlider = new JSlider(0, 5, 40, 10);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        sizePanel.add((Component)this.mAlphaSlider, gbc);
        final JSlider tempSlider = this.mAlphaSlider;
        this.mAlphaSlider.setMinimum(0);
        this.mAlphaSlider.setMaximum(100);
        this.mAlphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(tempSlider);
                tempAlphaTxt.setText("" + tempSlider.getValue());
            }
        });
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        this.mDataRecord = dataRecord;
        if (this.mDataRecord == null) {
            return;
        }
        int fillStyle = this.mDataRecord.getFillStyle();
        this.mStyleComboBox.setSelectedItem(new Integer(fillStyle));
        Color fillColor = this.mDataRecord.getDefaultColor();
        if (fillColor == null) {
            fillColor = Color.BLUE;
        }
        this.mFillPatternRenderer.setColor(fillColor);
        this.mColorComboBox.setSelectedColor(fillColor);
        double alpha = this.mDataRecord.getAlpha();
        this.mAlphaTxt.setText("" + (100.0 - alpha));
        this.mAlphaSlider.setValue((int)(100.0 - alpha));
    }

    @Override
    public void saveData() {
        if (this.mDataRecord == null) {
            return;
        }
        Color fillColor = this.mColorComboBox.getSelectedColor();
        this.mDataRecord.setDefaultColor(fillColor);
        this.mDataRecord.setDrawUsingDefaultColor(true);
        int fillStyle = (Integer)this.mStyleComboBox.getSelectedItem();
        this.mDataRecord.setFillStyle(fillStyle);
        double transparency = this.mAlphaSlider.getValue();
        this.mDataRecord.setAlpha(100.0 - transparency);
    }
}

