/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractSymbolSubPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJSpinner;
import rma.swing.list.RmaSymbolRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.RmaSymbol;

public class SingleSymbolPanel
extends AbstractSymbolSubPanel {
    RmaJComboBox mSymbolComboBox = null;
    RmaJColorComboBox mColorComboBox = null;
    SpinnerNumberModel mSpinnerModel = null;
    AiShapeGlyphDataRecord mGlyphDataRecord = null;

    public SingleSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 15, 0, 0);
        this.add((Component)label, gbc);
        this.mSymbolComboBox = new RmaJComboBox();
        Integer[] symbolTypes = new Integer[RmaSymbol.numSymbols()];
        for (int i = 0; i < RmaSymbol.numSymbols(); ++i) {
            symbolTypes[i] = new Integer(i);
        }
        DefaultComboBoxModel<Integer> comboModel = new DefaultComboBoxModel<Integer>(symbolTypes);
        this.mSymbolComboBox.setModel(comboModel);
        this.mSymbolComboBox.setRenderer(new RmaSymbolRenderer(Color.blue, Color.blue));
        this.mSymbolComboBox.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)this.mSymbolComboBox, gbc);
        label = new JLabel("Color");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 15, 0, 0);
        this.add((Component)label, gbc);
        this.mColorComboBox = new RmaJColorComboBox();
        this.mColorComboBox.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        gbc.ipady = 5;
        this.add((Component)this.mColorComboBox, gbc);
        label = new JLabel("Size");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 15, 0, 0);
        this.add((Component)label, gbc);
        final RmaJSpinner mSizeBox = new RmaJSpinner();
        this.mSpinnerModel = new SpinnerNumberModel(6, 1, 72, 1);
        mSizeBox.setModel(this.mSpinnerModel);
        this.mSpinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(mSizeBox);
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)mSizeBox, gbc);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)new SingleSymbolPanel(), "Center");
        frame.setLocation(100, 100);
        frame.setSize(250, 250);
        frame.setVisible(true);
    }

    @Override
    public void setData(AiShapeGlyphDataRecord record, AiShapeMap map) {
        this.mGlyphDataRecord = record;
        if (this.mGlyphDataRecord == null) {
            return;
        }
        int symbol = this.mGlyphDataRecord.getSymbolIndex();
        this.mSymbolComboBox.setSelectedItem(new Integer(symbol));
        Color c2 = this.mGlyphDataRecord.getDefaultColor();
        this.mColorComboBox.setSelectedItem(c2);
        this.mSpinnerModel.setValue(new Integer(this.mGlyphDataRecord.getPointSize()));
    }

    @Override
    public void saveData() {
        if (this.mGlyphDataRecord == null) {
            return;
        }
        int size = RMAIO.parseInt(this.mSpinnerModel.getValue());
        if (RMAConst.isUndefinedValue(size)) {
            size = 5;
        }
        this.mGlyphDataRecord.setPointSize(size);
        Color c2 = this.mColorComboBox.getSelectedColor();
        this.mGlyphDataRecord.setDefaultColor(c2);
        this.mGlyphDataRecord.setDrawUsingDefaultColor(true);
        Object selectedItem = this.mSymbolComboBox.getSelectedItem();
        int symbol = RMAIO.parseInt(selectedItem);
        if (RMAConst.isUndefinedValue(symbol)) {
            symbol = 0;
        }
        if (this.mGlyphDataRecord != null) {
            this.mGlyphDataRecord.setSymbolIndex(symbol);
        }
    }
}

