/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import hec.map.aishape.ui.FieldColorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.FillPatternRenderer;
import rma.swing.list.LinePatternRenderer;
import rma.swing.list.LineWidthRenderer;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaColorRenderer;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.RmaDrawConst;
import rma.util.TwoColorColorContour;

public class UniqueLineSymbolPanel
extends AbstractAiShapeProperitesPanel {
    public static final float[] SOLID_LINE = new float[]{50.0f};
    private static final Color START_COLOR = Color.BLUE;
    private static final Color END_COLOR = Color.RED;
    RmaJComboBox mFieldComboBox = null;
    RmaJComboBox mStyleComboBox = null;
    FillPatternRenderer mFillPatternRenderer = new FillPatternRenderer();
    final JSpinner mNumGradationsSpinner = new JSpinner();
    final JCheckBox mUseGradationsCheck = new JCheckBox("Use Gradations");
    RmaJColorComboBox mStartColor = null;
    RmaJColorComboBox mEndColor = null;
    TwoColorColorContour mColorContour = null;
    RmaJTable mColorTable = null;
    FieldColorTableModel mColorTableModel = null;
    RmaJComboBox mWeightComboBox;
    private JSpinner mSizeSpinBox;
    LineWidthRenderer mLineWidthRenderer = new LineWidthRenderer(Color.blue);
    LinePatternRenderer mLinePatternRenderer = new LinePatternRenderer(Color.blue);
    AiShapeGlyphDataRecord mGlyphDataRecord = null;

    public UniqueLineSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Field for values");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mFieldComboBox = new RmaJComboBox();
        this.mFieldComboBox.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this.mFieldComboBox, gbc);
        this.mFieldComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                int idx = UniqueLineSymbolPanel.this.mFieldComboBox.getSelectedIndex();
                UniqueLineSymbolPanel.this.mColorTableModel.setFieldIndex(idx);
                AiShapeFieldDescriptor fd = (AiShapeFieldDescriptor)UniqueLineSymbolPanel.this.mFieldComboBox.getSelectedItem();
                UniqueLineSymbolPanel.this.setGradationsComponentsEnabled(fd.getType());
            }
        });
        label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mStyleComboBox = new RmaJComboBox();
        this.mStyleComboBox.setModifiable(true);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{SOLID_LINE, RmaDrawConst.DASH_STYLE_PATTERN, RmaDrawConst.DOT_STYLE_PATTERN, RmaDrawConst.DASHDOT_STYLE_PATTERN, RmaDrawConst.DASHDOTDOT_STYLE_PATTERN});
        this.mStyleComboBox.setModel(comboModel);
        this.mStyleComboBox.setRenderer(this.mLinePatternRenderer);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mStyleComboBox, gbc);
        label = new JLabel("Weight");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5550;
        this.add((Component)label, gbc);
        this.mWeightComboBox = new RmaJComboBox();
        this.mWeightComboBox.setModifiable(true);
        comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Float(1.0f), new Float(2.0f), new Float(3.0f), new Float(4.0f), new Float(5.0f), new Float(6.0f), new Float(7.0f), new Float(8.0f), new Float(9.0f), new Float(10.0f)});
        this.mWeightComboBox.setModel(comboModel);
        this.mWeightComboBox.setRenderer(this.mLineWidthRenderer);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mWeightComboBox, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)panel, gbc);
        this.mUseGradationsCheck.setMargin(RmaInsets.INSETS0000);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5000;
        panel.add((Component)this.mUseGradationsCheck, gbc);
        this.mUseGradationsCheck.setSelected(false);
        this.mUseGradationsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean useGrad = UniqueLineSymbolPanel.this.mUseGradationsCheck.isSelected();
                UniqueLineSymbolPanel.this.mNumGradationsSpinner.setEnabled(useGrad);
                if (useGrad) {
                    UniqueLineSymbolPanel.this.mColorTableModel.setNumGradations(RMAIO.parseInt(UniqueLineSymbolPanel.this.mNumGradationsSpinner.getValue()));
                }
                UniqueLineSymbolPanel.this.mColorTableModel.setUseGradations(UniqueLineSymbolPanel.this.mUseGradationsCheck.isSelected());
                RMAUtil.setParentModified(UniqueLineSymbolPanel.this.mUseGradationsCheck);
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 25, 1);
        this.mNumGradationsSpinner.setModel(model);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5500;
        panel.add((Component)this.mNumGradationsSpinner, gbc);
        this.mNumGradationsSpinner.setEnabled(false);
        this.mNumGradationsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(UniqueLineSymbolPanel.this.mUseGradationsCheck);
                UniqueLineSymbolPanel.this.mColorTableModel.setNumGradations(RMAIO.parseInt(UniqueLineSymbolPanel.this.mNumGradationsSpinner.getValue()));
            }
        });
        JPanel colorPanel = new JPanel(new GridBagLayout());
        colorPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 10, 0, 10);
        gbc.ipady = 0;
        this.add((Component)colorPanel, gbc);
        label = new JLabel("Start");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.ipady = 3;
        colorPanel.add((Component)label, gbc);
        this.mStartColor = new RmaJColorComboBox();
        this.mColorContour = new TwoColorColorContour();
        this.mColorContour.setMinColor(START_COLOR);
        this.mColorContour.setMaxColor(END_COLOR);
        this.mStartColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                UniqueLineSymbolPanel.this.mColorContour.setMinColor(UniqueLineSymbolPanel.this.mStartColor.getSelectedColor());
                if (UniqueLineSymbolPanel.this.mColorTable != null) {
                    UniqueLineSymbolPanel.this.mColorTable.invalidate();
                    UniqueLineSymbolPanel.this.mColorTable.repaint();
                }
            }
        });
        this.mStartColor.setSelectedItem(START_COLOR);
        this.mStartColor.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        colorPanel.add((Component)this.mStartColor, gbc);
        label = new JLabel("End");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        colorPanel.add((Component)label, gbc);
        this.mEndColor = new RmaJColorComboBox();
        this.mEndColor.setModifiable(true);
        this.mEndColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                UniqueLineSymbolPanel.this.mColorContour.setMaxColor(UniqueLineSymbolPanel.this.mEndColor.getSelectedColor());
                if (UniqueLineSymbolPanel.this.mColorTable != null) {
                    UniqueLineSymbolPanel.this.mColorTable.invalidate();
                    UniqueLineSymbolPanel.this.mColorTable.repaint();
                }
            }
        });
        this.mEndColor.setSelectedItem(END_COLOR);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        colorPanel.add((Component)this.mEndColor, gbc);
        this.mColorTableModel = new FieldColorTableModel();
        this.mColorTableModel.setColorContour(this.mColorContour);
        this.mColorTable = new RmaJTable();
        TableClickListener listener = new TableClickListener(this.mColorTable);
        this.mColorTable.addMouseListener(listener);
        this.mColorTable.setModel(this.mColorTableModel);
        this.mColorTable.getColumnModel().getColumn(0).setCellRenderer(new RmaColorRenderer());
        JScrollPane jsp = new JScrollPane(this.mColorTable);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.ipady = 0;
        this.add((Component)jsp, gbc);
    }

    @Override
    public String getTitle() {
        return "Unique";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        float[] lineStyle;
        this.mGlyphDataRecord = dataRecord;
        if (this.mGlyphDataRecord == null) {
            return;
        }
        List fieldDescriptors = aiShapeMap.getFieldDescriptors();
        this.mFieldComboBox.setModel(new RmaListModel(false, fieldDescriptors));
        if (!fieldDescriptors.isEmpty()) {
            this.mFieldComboBox.setSelectedIndex(0);
            int fieldIdx = dataRecord.getFieldIndex();
            char fieldType = 'c';
            int tempFieldIdx = 0;
            if (fieldIdx >= 0 && fieldIdx < fieldDescriptors.size()) {
                this.mFieldComboBox.setSelectedIndex(fieldIdx);
                this.mColorTableModel.setFieldIndex(fieldIdx);
                fieldType = ((AiShapeFieldDescriptor)this.mFieldComboBox.getSelectedItem()).getType();
                tempFieldIdx = fieldIdx;
            }
            this.setGradationsComponentsEnabled(fieldType);
            this.mColorTableModel.setData(aiShapeMap, dataRecord, tempFieldIdx);
        }
        Color startColor = dataRecord.getColorContourStart();
        Color endColor = dataRecord.getColorContourEnd();
        if (startColor != null) {
            this.mStartColor.setSelectedColor(startColor);
        }
        if (endColor != null) {
            this.mEndColor.setSelectedColor(endColor);
        }
        if ((lineStyle = this.mGlyphDataRecord.getBorderLineStyle()) == null) {
            this.mStyleComboBox.setSelectedItem(SOLID_LINE);
        } else {
            ComboBoxModel propertiesModel = this.mStyleComboBox.getModel();
            for (int i = 0; i < propertiesModel.getSize(); ++i) {
                if (!Arrays.equals(lineStyle, (float[])propertiesModel.getElementAt(i))) continue;
                this.mStyleComboBox.setSelectedIndex(i);
                break;
            }
        }
        Float width = new Float(this.mGlyphDataRecord.getBorderWidth());
        this.mWeightComboBox.setSelectedItem(width);
        boolean enabled = dataRecord.getUseGradations();
        this.mUseGradationsCheck.setSelected(enabled);
        this.mNumGradationsSpinner.setValue(dataRecord.getNumGradations());
        this.mNumGradationsSpinner.setEnabled(enabled);
        this.mColorTableModel.setNumGradations(dataRecord.getNumGradations());
        this.mColorTableModel.setUseGradations(enabled);
    }

    @Override
    public void saveData() {
        if (this.mGlyphDataRecord == null) {
            return;
        }
        int fieldIdx = this.mFieldComboBox.getSelectedIndex();
        this.mGlyphDataRecord.setFieldIndex(fieldIdx);
        Color startColor = this.mStartColor.getSelectedColor();
        Color endColor = this.mEndColor.getSelectedColor();
        this.mGlyphDataRecord.setColorContourEnd(endColor);
        this.mGlyphDataRecord.setColorContourStart(startColor);
        this.mGlyphDataRecord.setDrawUsingDefaultColor(false);
        this.mColorTableModel.commitData();
        Float fillStyle = (Float)this.mWeightComboBox.getSelectedItem();
        this.mGlyphDataRecord.setBorderWidth(fillStyle.intValue());
        float[] lineStyle = (float[])this.mStyleComboBox.getSelectedItem();
        if (lineStyle == SOLID_LINE) {
            lineStyle = null;
        }
        this.mGlyphDataRecord.setBorderLineStyle(lineStyle);
        this.mGlyphDataRecord.setUseGradations(this.mUseGradationsCheck.isSelected());
        this.mGlyphDataRecord.setNumGradations(RMAIO.parseInt(this.mNumGradationsSpinner.getValue().toString(), 5));
    }

    private void setGradationsComponentsEnabled(char fieldType) {
        boolean enabled = true;
        this.mUseGradationsCheck.setEnabled(enabled &= fieldType == 'F' || fieldType == 'f' || fieldType == 'N' || fieldType == 'n');
        if (enabled) {
            this.mNumGradationsSpinner.setEnabled(this.mUseGradationsCheck.isSelected());
            this.mColorTableModel.setUseGradations(this.mUseGradationsCheck.isSelected());
        } else {
            this.mNumGradationsSpinner.setEnabled(false);
            this.mColorTableModel.setUseGradations(false);
        }
    }

    private class TableClickListener
    implements MouseListener {
        JTable mTable = null;

        public TableClickListener(JTable table) {
            this.mTable = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.mTable == null) {
                return;
            }
            if (e.getClickCount() < 2) {
                return;
            }
            int selectedRow = this.mTable.getSelectedRow();
            if (selectedRow < 0 || selectedRow >= this.mTable.getRowCount()) {
                RMAIO.postWarning(this.mTable, "Select a row first.");
                return;
            }
            Color c2 = (Color)this.mTable.getModel().getValueAt(selectedRow, 0);
            Color newColor = JColorChooser.showDialog(this.mTable, "Select Color", c2);
            if (newColor == null) {
                return;
            }
            this.mTable.getModel().setValueAt(newColor, selectedRow, 0);
            this.mTable.repaint();
            RMAUtil.setParentModified(this.mTable);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

