/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractAiShapeProperitesPanel;
import hec.map.aishape.ui.FieldColorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.FillPatternRenderer;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaColorRenderer;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.TwoColorColorContour;

public class UniquePolygonSymbolPanel
extends AbstractAiShapeProperitesPanel {
    public static final float[] SOLID_LINE = new float[]{50.0f};
    private static final Color START_COLOR = Color.BLUE;
    private static final Color END_COLOR = Color.RED;
    RmaJComboBox mFieldComboBox = null;
    RmaJComboBox mStyleComboBox = null;
    FillPatternRenderer mFillPatternRenderer = new FillPatternRenderer();
    final JSpinner mNumGradationsSpinner = new JSpinner();
    final JCheckBox mUseGradationsCheck = new JCheckBox("Use Gradations");
    RmaJColorComboBox mStartColor = null;
    RmaJColorComboBox mEndColor = null;
    TwoColorColorContour mColorContour = null;
    RmaJTable mColorTable = null;
    FieldColorTableModel mColorTableModel = null;
    JTextField mAlphaTxt = null;
    JSlider mAlphaSlider;
    AiShapeGlyphDataRecord mGlyphRecord = null;

    public UniquePolygonSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Field for values");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mFieldComboBox = new RmaJComboBox();
        this.mFieldComboBox.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this.mFieldComboBox, gbc);
        this.mFieldComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                int idx = UniquePolygonSymbolPanel.this.mFieldComboBox.getSelectedIndex();
                UniquePolygonSymbolPanel.this.mColorTableModel.setFieldIndex(idx);
                AiShapeFieldDescriptor fd = (AiShapeFieldDescriptor)UniquePolygonSymbolPanel.this.mFieldComboBox.getSelectedItem();
                UniquePolygonSymbolPanel.this.setGradationsComponentsEnabled(fd.getType());
            }
        });
        label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)label, gbc);
        this.mStyleComboBox = new RmaJComboBox();
        this.mStyleComboBox.setModifiable(true);
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(4), new Integer(3), new Integer(5), new Integer(6)});
        this.mStyleComboBox.setModel(comboModel);
        this.mFillPatternRenderer.setColor(Color.blue);
        this.mStyleComboBox.setRenderer(this.mFillPatternRenderer);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        gbc.ipady = 5;
        this.add((Component)this.mStyleComboBox, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)panel, gbc);
        this.mUseGradationsCheck.setMargin(RmaInsets.INSETS0000);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5000;
        panel.add((Component)this.mUseGradationsCheck, gbc);
        this.mUseGradationsCheck.setSelected(false);
        this.mUseGradationsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean useGrad = UniquePolygonSymbolPanel.this.mUseGradationsCheck.isSelected();
                UniquePolygonSymbolPanel.this.mNumGradationsSpinner.setEnabled(useGrad);
                if (useGrad) {
                    UniquePolygonSymbolPanel.this.mColorTableModel.setNumGradations(RMAIO.parseInt(UniquePolygonSymbolPanel.this.mNumGradationsSpinner.getValue()));
                }
                UniquePolygonSymbolPanel.this.mColorTableModel.setUseGradations(UniquePolygonSymbolPanel.this.mUseGradationsCheck.isSelected());
                RMAUtil.setParentModified(UniquePolygonSymbolPanel.this.mUseGradationsCheck);
            }
        });
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 25, 1);
        this.mNumGradationsSpinner.setModel(model);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5500;
        panel.add((Component)this.mNumGradationsSpinner, gbc);
        this.mNumGradationsSpinner.setEnabled(false);
        this.mNumGradationsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(UniquePolygonSymbolPanel.this.mUseGradationsCheck);
                UniquePolygonSymbolPanel.this.mColorTableModel.setNumGradations(RMAIO.parseInt(UniquePolygonSymbolPanel.this.mNumGradationsSpinner.getValue()));
            }
        });
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new TitledBorder("Transparency"));
        sizePanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5000;
        panel.add((Component)sizePanel, gbc);
        this.mAlphaTxt = new JTextField();
        this.mAlphaTxt.setEditable(false);
        final JTextField tempAlphaTxt = this.mAlphaTxt;
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        sizePanel.add((Component)this.mAlphaTxt, gbc);
        this.mAlphaSlider = new JSlider(0, 5, 40, 10);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.ipadx = 10;
        sizePanel.add((Component)this.mAlphaSlider, gbc);
        final JSlider tempSlider = this.mAlphaSlider;
        this.mAlphaSlider.setMinimum(0);
        this.mAlphaSlider.setMaximum(100);
        this.mAlphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(tempSlider);
                tempAlphaTxt.setText("" + tempSlider.getValue());
            }
        });
        JPanel colorPanel = new JPanel(new GridBagLayout());
        colorPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        gbc.ipady = 0;
        this.add((Component)colorPanel, gbc);
        label = new JLabel("Start");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.ipady = 3;
        colorPanel.add((Component)label, gbc);
        this.mStartColor = new RmaJColorComboBox();
        this.mColorContour = new TwoColorColorContour();
        this.mColorContour.setMinColor(START_COLOR);
        this.mColorContour.setMaxColor(END_COLOR);
        this.mStartColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                UniquePolygonSymbolPanel.this.mColorContour.setMinColor(UniquePolygonSymbolPanel.this.mStartColor.getSelectedColor());
                if (UniquePolygonSymbolPanel.this.mColorTable != null) {
                    UniquePolygonSymbolPanel.this.mColorTable.invalidate();
                    UniquePolygonSymbolPanel.this.mColorTable.repaint();
                }
            }
        });
        this.mStartColor.setSelectedItem(START_COLOR);
        this.mStartColor.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        colorPanel.add((Component)this.mStartColor, gbc);
        label = new JLabel("End");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        colorPanel.add((Component)label, gbc);
        this.mEndColor = new RmaJColorComboBox();
        this.mEndColor.setModifiable(true);
        this.mEndColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                UniquePolygonSymbolPanel.this.mColorContour.setMaxColor(UniquePolygonSymbolPanel.this.mEndColor.getSelectedColor());
                if (UniquePolygonSymbolPanel.this.mColorTable != null) {
                    UniquePolygonSymbolPanel.this.mColorTable.invalidate();
                    UniquePolygonSymbolPanel.this.mColorTable.repaint();
                }
            }
        });
        this.mEndColor.setSelectedItem(END_COLOR);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        colorPanel.add((Component)this.mEndColor, gbc);
        this.mColorTableModel = new FieldColorTableModel();
        this.mColorTableModel.setColorContour(this.mColorContour);
        this.mColorTable = new RmaJTable();
        TableClickListener listener = new TableClickListener(this.mColorTable);
        this.mColorTable.addMouseListener(listener);
        this.mColorTable.setModel(this.mColorTableModel);
        this.mColorTable.getColumnModel().getColumn(0).setCellRenderer(new RmaColorRenderer());
        JScrollPane jsp = new JScrollPane(this.mColorTable);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.ipady = 0;
        this.add((Component)jsp, gbc);
    }

    @Override
    public String getTitle() {
        return "Attribute Values";
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        this.mGlyphRecord = dataRecord;
        int fillStyle = this.mGlyphRecord.getFillStyle();
        this.mStyleComboBox.setSelectedItem(new Integer(fillStyle));
        ArrayList fieldDescriptors = new ArrayList();
        if (aiShapeMap != null) {
            fieldDescriptors.addAll(aiShapeMap.getFieldDescriptors());
        }
        this.mFieldComboBox.setModel(new RmaListModel(false, fieldDescriptors));
        if (this.mFieldComboBox.getItemCount() > 0) {
            this.mFieldComboBox.setSelectedIndex(0);
        }
        int fieldIdx = this.mGlyphRecord.getFieldIndex();
        int tempFieldIdx = 0;
        char fieldType = 'c';
        if (fieldIdx >= 0 && fieldIdx < fieldDescriptors.size()) {
            this.mFieldComboBox.setSelectedIndex(fieldIdx);
            tempFieldIdx = fieldIdx;
            fieldType = ((AiShapeFieldDescriptor)this.mFieldComboBox.getSelectedItem()).getType();
        }
        Color startColor = this.mGlyphRecord.getColorContourStart();
        Color endColor = this.mGlyphRecord.getColorContourEnd();
        if (startColor != null) {
            this.mStartColor.setSelectedColor(startColor);
        }
        if (endColor != null) {
            this.mEndColor.setSelectedColor(endColor);
        }
        double alpha = this.mGlyphRecord.getAlpha();
        this.mAlphaTxt.setText("" + (100.0 - alpha));
        this.mAlphaSlider.setValue((int)(100.0 - alpha));
        boolean enabled = dataRecord.getUseGradations();
        this.mUseGradationsCheck.setSelected(enabled);
        this.mNumGradationsSpinner.setValue(dataRecord.getNumGradations());
        this.mNumGradationsSpinner.setEnabled(enabled);
        this.mColorTableModel.setNumGradations(dataRecord.getNumGradations());
        this.mColorTableModel.setUseGradations(enabled);
        this.setGradationsComponentsEnabled(fieldType);
        this.mColorTableModel.setData(aiShapeMap, dataRecord, tempFieldIdx);
    }

    private void setGradationsComponentsEnabled(char fieldType) {
        boolean enabled = true;
        this.mUseGradationsCheck.setEnabled(enabled &= fieldType == 'F' || fieldType == 'f' || fieldType == 'N' || fieldType == 'n');
        if (enabled) {
            this.mNumGradationsSpinner.setEnabled(this.mUseGradationsCheck.isSelected());
            this.mColorTableModel.setUseGradations(this.mUseGradationsCheck.isSelected());
        } else {
            this.mNumGradationsSpinner.setEnabled(false);
            this.mColorTableModel.setUseGradations(false);
        }
    }

    @Override
    public void saveData() {
        if (this.mGlyphRecord == null) {
            return;
        }
        int fieldIdx = this.mFieldComboBox.getSelectedIndex();
        this.mGlyphRecord.setFieldIndex(fieldIdx);
        Integer fillStyle = (Integer)this.mStyleComboBox.getSelectedItem();
        this.mGlyphRecord.setFillStyle(fillStyle);
        Color startColor = this.mStartColor.getSelectedColor();
        Color endColor = this.mEndColor.getSelectedColor();
        this.mGlyphRecord.setColorContourEnd(endColor);
        this.mGlyphRecord.setColorContourStart(startColor);
        this.mGlyphRecord.setDrawUsingDefaultColor(false);
        this.mColorTableModel.commitData();
        double transparency = this.mAlphaSlider.getValue();
        this.mGlyphRecord.setAlpha(100.0 - transparency);
        this.mGlyphRecord.setUseGradations(this.mUseGradationsCheck.isSelected());
        this.mGlyphRecord.setNumGradations(RMAIO.parseInt(this.mNumGradationsSpinner.getValue().toString(), 5));
    }

    private class TableClickListener
    implements MouseListener {
        JTable mTable = null;

        public TableClickListener(JTable table) {
            this.mTable = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.mTable == null) {
                return;
            }
            if (e.getClickCount() < 2) {
                return;
            }
            int selectedRow = this.mTable.getSelectedRow();
            if (selectedRow < 0 || selectedRow >= this.mTable.getRowCount()) {
                RMAIO.postWarning(this.mTable, "Select a row first.");
                return;
            }
            Color c2 = (Color)this.mTable.getModel().getValueAt(selectedRow, 0);
            Color newColor = JColorChooser.showDialog(this.mTable, "Select Color", c2);
            if (newColor == null) {
                return;
            }
            this.mTable.getModel().setValueAt(newColor, selectedRow, 0);
            this.mTable.repaint();
            RMAUtil.setParentModified(this.mTable);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

