/*
 * Decompiled with CFR 0.152.
 */
package hec.map.aishape.ui;

import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.ui.AbstractSymbolSubPanel;
import hec.map.aishape.ui.FieldColorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.list.RmaSymbolRenderer;
import rma.swing.table.RmaColorRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.RmaSymbol;
import rma.util.TwoColorColorContour;

public class UniqueSymbolPanel
extends AbstractSymbolSubPanel {
    private static final Color START_COLOR = Color.BLUE;
    private static final Color END_COLOR = Color.RED;
    RmaJComboBox mShapeFieldComboBox = null;
    RmaJComboBox mStyleComboBox = null;
    JSpinner mSizeSpinBox = null;
    final JSpinner mNumGradationsSpinner = new JSpinner();
    final JCheckBox mUseGradationsCheck = new JCheckBox("Use Gradations");
    RmaJColorComboBox mStartColor = null;
    RmaJColorComboBox mEndColor = null;
    RmaJTable mColorTable = null;
    FieldColorTableModel mColorTableModel = null;
    TwoColorColorContour mColorContour = null;
    AiShapeGlyphDataRecord mGlyphRecord = null;

    public UniqueSymbolPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.mColorContour = new TwoColorColorContour();
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Field for Values");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)label, gbc);
        this.mShapeFieldComboBox = new RmaJComboBox();
        this.mShapeFieldComboBox.setModifiable(true);
        this.mShapeFieldComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                int idx = UniqueSymbolPanel.this.mShapeFieldComboBox.getSelectedIndex();
                UniqueSymbolPanel.this.mColorTableModel.setFieldIndex(idx);
                AiShapeFieldDescriptor fd = (AiShapeFieldDescriptor)UniqueSymbolPanel.this.mShapeFieldComboBox.getSelectedItem();
                UniqueSymbolPanel.this.setGradationsComponentsEnabled(fd.getType());
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)this.mShapeFieldComboBox, gbc);
        label = new JLabel("Style");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)label, gbc);
        this.mStyleComboBox = new RmaJComboBox();
        this.mStyleComboBox.setModifiable(true);
        Integer[] symbolTypes = new Integer[RmaSymbol.numSymbols()];
        for (int i = 0; i < RmaSymbol.numSymbols(); ++i) {
            symbolTypes[i] = new Integer(i);
        }
        DefaultComboBoxModel<Integer> comboModel = new DefaultComboBoxModel<Integer>(symbolTypes);
        this.mStyleComboBox.setModel(comboModel);
        gbc.ipady = 5;
        this.mStyleComboBox.setRenderer(new RmaSymbolRenderer(Color.blue, Color.blue));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)this.mStyleComboBox, gbc);
        label = new JLabel("Size");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)label, gbc);
        this.mSizeSpinBox = new JSpinner();
        SpinnerNumberModel model = new SpinnerNumberModel(5, 1, 64, 1);
        this.mSizeSpinBox.setModel(model);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 15);
        this.add((Component)this.mSizeSpinBox, gbc);
        this.mSizeSpinBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(UniqueSymbolPanel.this.mSizeSpinBox);
            }
        });
        this.mUseGradationsCheck.setMargin(RmaInsets.INSETS0000);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5000;
        this.add((Component)this.mUseGradationsCheck, gbc);
        this.mUseGradationsCheck.setSelected(false);
        this.mUseGradationsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean useGrad = UniqueSymbolPanel.this.mUseGradationsCheck.isSelected();
                UniqueSymbolPanel.this.mNumGradationsSpinner.setEnabled(useGrad);
                if (useGrad) {
                    UniqueSymbolPanel.this.mColorTableModel.setNumGradations(RMAIO.parseInt(UniqueSymbolPanel.this.mNumGradationsSpinner.getValue()));
                }
                UniqueSymbolPanel.this.mColorTableModel.setUseGradations(UniqueSymbolPanel.this.mUseGradationsCheck.isSelected());
                RMAUtil.setParentModified(UniqueSymbolPanel.this.mUseGradationsCheck);
            }
        });
        SpinnerNumberModel smodel = new SpinnerNumberModel(1, 1, 25, 1);
        this.mNumGradationsSpinner.setModel(smodel);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)this.mNumGradationsSpinner, gbc);
        this.mNumGradationsSpinner.setEnabled(false);
        this.mNumGradationsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RMAUtil.setParentModified(UniqueSymbolPanel.this.mUseGradationsCheck);
                UniqueSymbolPanel.this.mColorTableModel.setNumGradations(RMAIO.parseInt(UniqueSymbolPanel.this.mNumGradationsSpinner.getValue()));
            }
        });
        JPanel colorPanel = new JPanel(new GridBagLayout());
        colorPanel.setBorder(BorderFactory.createTitledBorder("Color"));
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 10, 0, 10);
        this.add((Component)colorPanel, gbc);
        label = new JLabel("Start");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        gbc.ipady = 3;
        colorPanel.add((Component)label, gbc);
        this.mStartColor = new RmaJColorComboBox();
        this.mStartColor.setModifiable(true);
        this.mStartColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                UniqueSymbolPanel.this.mColorContour.setMinColor(UniqueSymbolPanel.this.mStartColor.getSelectedColor());
                if (UniqueSymbolPanel.this.mColorTable != null) {
                    UniqueSymbolPanel.this.mColorTable.invalidate();
                    UniqueSymbolPanel.this.mColorTable.repaint();
                }
            }
        });
        this.mStartColor.setSelectedItem(START_COLOR);
        this.mStartColor.setModifiable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        colorPanel.add((Component)this.mStartColor, gbc);
        label = new JLabel("End");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 0);
        colorPanel.add((Component)label, gbc);
        this.mEndColor = new RmaJColorComboBox();
        this.mEndColor.setModifiable(true);
        this.mEndColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                UniqueSymbolPanel.this.mColorContour.setMaxColor(UniqueSymbolPanel.this.mEndColor.getSelectedColor());
                if (UniqueSymbolPanel.this.mColorTable != null) {
                    UniqueSymbolPanel.this.mColorTable.invalidate();
                    UniqueSymbolPanel.this.mColorTable.repaint();
                }
            }
        });
        this.mEndColor.setSelectedItem(END_COLOR);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        colorPanel.add((Component)this.mEndColor, gbc);
        this.mColorTableModel = new FieldColorTableModel();
        this.mColorTableModel.setColorContour(this.mColorContour);
        this.mColorTable = new RmaJTable();
        TableClickListener listener = new TableClickListener(this.mColorTable);
        this.mColorTable.addMouseListener(listener);
        this.mColorTable.setModel(this.mColorTableModel);
        this.mColorTable.getColumnModel().getColumn(0).setCellRenderer(new RmaColorRenderer());
        JScrollPane jsp = new JScrollPane(this.mColorTable);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.ipady = 0;
        this.add((Component)jsp, gbc);
    }

    @Override
    public void setData(AiShapeGlyphDataRecord dataRecord, AiShapeMap aiShapeMap) {
        this.mGlyphRecord = dataRecord;
        List fieldDescriptors = aiShapeMap.getFieldDescriptors();
        this.mShapeFieldComboBox.setModel(new RmaListModel(false, fieldDescriptors));
        if (!fieldDescriptors.isEmpty()) {
            this.mShapeFieldComboBox.setSelectedIndex(0);
            int fieldIdx = this.mGlyphRecord.getFieldIndex();
            int tempFieldIdx = 0;
            char fieldType = 'c';
            if (fieldIdx >= 0 && fieldIdx < fieldDescriptors.size()) {
                this.mShapeFieldComboBox.setSelectedIndex(fieldIdx);
                tempFieldIdx = fieldIdx;
                fieldType = ((AiShapeFieldDescriptor)this.mShapeFieldComboBox.getSelectedItem()).getType();
            }
            this.setGradationsComponentsEnabled(fieldType);
            this.mColorTableModel.setData(aiShapeMap, dataRecord, tempFieldIdx);
        }
        Color startColor = this.mGlyphRecord.getColorContourStart();
        Color endColor = this.mGlyphRecord.getColorContourEnd();
        if (startColor != null) {
            this.mStartColor.setSelectedColor(startColor);
        }
        if (endColor != null) {
            this.mEndColor.setSelectedColor(endColor);
        }
        int symbol = dataRecord.getSymbolIndex();
        this.mStyleComboBox.setSelectedItem(new Integer(symbol));
        this.mSizeSpinBox.setValue(dataRecord.getPointSize());
        boolean enabled = dataRecord.getUseGradations();
        this.mUseGradationsCheck.setSelected(enabled);
        this.mNumGradationsSpinner.setValue(dataRecord.getNumGradations());
        this.mNumGradationsSpinner.setEnabled(enabled);
        this.mColorTableModel.setNumGradations(dataRecord.getNumGradations());
        this.mColorTableModel.setUseGradations(enabled);
    }

    @Override
    public void saveData() {
        if (this.mGlyphRecord == null) {
            return;
        }
        int size = RMAIO.parseInt(this.mSizeSpinBox.getValue());
        if (RMAConst.isUndefinedValue(size)) {
            size = 5;
        }
        this.mGlyphRecord.setPointSize(size);
        int fieldIdx = this.mShapeFieldComboBox.getSelectedIndex();
        this.mGlyphRecord.setFieldIndex(fieldIdx);
        Object selectedItem = this.mStyleComboBox.getSelectedItem();
        int symbol = RMAIO.parseInt(selectedItem);
        if (RMAConst.isUndefinedValue(symbol)) {
            symbol = 0;
        }
        if (this.mGlyphRecord != null) {
            this.mGlyphRecord.setSymbolIndex(symbol);
        }
        Color startColor = this.mStartColor.getSelectedColor();
        Color endColor = this.mEndColor.getSelectedColor();
        this.mGlyphRecord.setColorContourEnd(endColor);
        this.mGlyphRecord.setColorContourStart(startColor);
        this.mColorTableModel.commitData();
        this.mGlyphRecord.setDrawUsingDefaultColor(false);
        this.mGlyphRecord.setUseGradations(this.mUseGradationsCheck.isSelected());
        this.mGlyphRecord.setNumGradations(RMAIO.parseInt(this.mNumGradationsSpinner.getValue().toString(), 5));
    }

    private void setGradationsComponentsEnabled(char fieldType) {
        boolean enabled = true;
        this.mUseGradationsCheck.setEnabled(enabled &= fieldType == 'F' || fieldType == 'f' || fieldType == 'N' || fieldType == 'n');
        if (enabled) {
            this.mNumGradationsSpinner.setEnabled(this.mUseGradationsCheck.isSelected());
            this.mColorTableModel.setUseGradations(this.mUseGradationsCheck.isSelected());
        } else {
            this.mNumGradationsSpinner.setEnabled(false);
            this.mColorTableModel.setUseGradations(false);
        }
    }

    private class TableClickListener
    implements MouseListener {
        JTable mTable = null;

        public TableClickListener(JTable table) {
            this.mTable = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.mTable == null) {
                return;
            }
            if (e.getClickCount() < 2) {
                return;
            }
            int selectedRow = this.mTable.getSelectedRow();
            if (selectedRow < 0 || selectedRow >= this.mTable.getRowCount()) {
                RMAIO.postWarning(this.mTable, "Select a row first.");
                return;
            }
            Color c2 = (Color)this.mTable.getModel().getValueAt(selectedRow, 0);
            Color newColor = JColorChooser.showDialog(this.mTable, "Select Color", c2);
            if (newColor == null) {
                return;
            }
            this.mTable.getModel().setValueAt(newColor, selectedRow, 0);
            this.mTable.repaint();
            RMAUtil.setParentModified(this.mTable);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

