/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import hec.map.MapGlyph;
import hec.map.MapGlyphFactory;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.annotations.Annotation;
import hec.map.annotations.AnnotationMapObject;
import hec.map.annotations.AnnotationWidget;
import hec.map.annotations.Widget;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class AnnotationMapGlyph
extends MapGlyph
implements PropertyChangeListener {
    List<Widget> widgetList = new ArrayList<Widget>();

    public AnnotationMapGlyph(MapPanel panel, AnnotationMapObject map) {
        super(panel, map);
        AnnotationMapObject aMap = map;
        aMap.addPropertyChangeListener(this);
        List<Annotation> annotations = aMap.getAnnotations();
        for (Annotation annotation : annotations) {
            this.widgetList.add(new AnnotationWidget(panel.scale(), annotation));
        }
    }

    @Override
    public void draw(Graphics graphics, MapScale scl) {
        for (Widget w : this.widgetList) {
            w.paintWidget((Graphics2D)graphics, scl);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "annotation": {
                this.widgetList.add(new AnnotationWidget(this._mapPanel.scale(), (Annotation)evt.getNewValue()));
                this._mapPanel.paintMap();
                break;
            }
        }
    }

    public class AnnotationGlyphMapping
    implements MapGlyphFactory.MapGlyphMappingProvider {
        @Override
        public String getMapObjectInterfaceClass() {
            return AnnotationMapObject.class.getName();
        }

        @Override
        public String getMapGlyphClass() {
            return AnnotationMapGlyph.class.getName();
        }
    }
}

