/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import hec.map.ButtonGifStrings;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface2;
import hec.map.MapToolSet;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.annotations.Annotation;
import hec.map.annotations.AnnotationMapGlyph;
import hec.map.annotations.AnnotationTool;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class AnnotationMapObject
extends MapObject
implements MapObjectInterface2 {
    private List<Annotation> annotations = Collections.EMPTY_LIST;
    MapToolSet mts = null;
    public static final String PROP_ANNOTATION = "annotation";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public AnnotationMapObject(List<Annotation> annotations) {
        super(new MapIdentifier(""));
        this.annotations = annotations;
        this._mapId.setMapShown(true);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public WorldRect getExtent() {
        WorldRect wr = null;
        for (Annotation annotation : this.annotations) {
            if (wr == null) {
                wr = new WorldRect();
            }
            WorldPt annotatedLocation = annotation.getAnnotatedLocation();
            wr.grow(annotatedLocation);
        }
        return wr;
    }

    @Override
    public void setExtent(WorldRect rc) {
    }

    @Override
    public String getName() {
        return "Annotations";
    }

    @Override
    public void load() throws IOException {
    }

    @Override
    public void unload() {
    }

    public void addAnnotation(Annotation a) {
        this.annotations.add(a);
        this.propertyChangeSupport.fireIndexedPropertyChange(PROP_ANNOTATION, this.annotations.size() - 1, null, a);
    }

    @Override
    public MapToolSet getMapTools() {
        if (this.mts == null) {
            this.mts = new MapToolSet();
            ButtonGifStrings toolDef = new ButtonGifStrings();
            toolDef.adapter = AnnotationTool.class.getName();
            toolDef.up = "Images/symbol_blank.gif";
            toolDef.down = "Images/symbol_blank.gif";
            toolDef.over = "Images/symbol_blank.gif";
            toolDef.on = "Images/symbol_blank.gif";
            this.mts.addMapTool(toolDef);
        }
        return this.mts;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    static {
        MapGlyphFactory.addMapping(AnnotationMapObject.class.getName(), AnnotationMapGlyph.class.getName());
    }
}

