/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.annotations.Annotation;
import hec.map.annotations.AnnotationMapGlyph;
import hec.map.annotations.AnnotationMapObject;
import hec.map.annotations.LabelAnnotation;
import hec.map.annotations.ui.AnnotationDialog;
import hec.map.crs.CoordinateReferenceSystem;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class AnnotationTool
extends MapMouseAdapter {
    public AnnotationTool(MapPanel panel, MapCanvas canvas) {
        super(panel, canvas);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() != 2 || e.getButton() != 1) {
            return;
        }
        Point point = e.getPoint();
        WorldPt worldPt = this.getWorldPt(point);
        CoordinateReferenceSystem coordinateRefereceSystem = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        LabelAnnotation annotation = new LabelAnnotation(worldPt, coordinateRefereceSystem, "", "");
        Window parent = SwingUtilities.windowForComponent(this._mapPanel);
        AnnotationDialog dlg = new AnnotationDialog(parent, true);
        dlg.setTitle("New Annotation");
        dlg.setAnnotation(annotation);
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            Annotation a = dlg.getAnnotation();
            AnnotationMapGlyph findGlyphOfClass = this._mapPanel.findGlyphOfClass(AnnotationMapGlyph.class, true);
            AnnotationMapObject mapObject = (AnnotationMapObject)findGlyphOfClass.getMap();
            mapObject.addAnnotation(a);
        }
    }
}

