/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import hec.map.DisplayCoordinateReferenceSystem;
import hec.map.LocalPt;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.annotations.Annotation;
import hec.map.annotations.ShadowRenderer;
import hec.map.annotations.Widget;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class AnnotationWidget
extends Widget {
    MapScale mapScale;
    Point2D annotationPointL;
    JComponent component;
    Annotation annotation;

    public AnnotationWidget(MapScale mapScale, Annotation annotation) {
        this.annotation = annotation;
        this.component = annotation.createComponent();
        Dimension d = this.component.getPreferredSize();
        this.component.setBounds(0, 0, d.width, d.height);
        this.bounds = new Rectangle(this.component.getBounds());
        this.bounds.width += 15;
        this.bounds.height += 15;
        this.preferredBounds = this.bounds;
        this.preferredSize = new Dimension(this.bounds.width, this.bounds.height);
    }

    public Point2D getAnnotationPoint() {
        return this.annotationPointL;
    }

    @Override
    public void paintWidget(Graphics2D g, MapScale mapScale) {
        g = (Graphics2D)g.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        WorldPt location1 = this.annotation.getAnnotatedLocation();
        this.mapScale = mapScale;
        CoordinateReferenceSystem crs = this.annotation.getCoordinateReferenceSystem();
        CoordinateReferenceSystem dCrs = DisplayCoordinateReferenceSystem.getDefault().getCoordinateRefereceSystem();
        Transform findTransform = null;
        double[] xpoints = new double[]{location1.e};
        double[] ypoints = new double[]{location1.n};
        try {
            findTransform = CRS.getDefault().findTransform(crs, dCrs, false);
            findTransform.transform(xpoints, ypoints, 0, xpoints, ypoints, 0, 1);
        }
        catch (CRSException ex) {
            Logger.getLogger(AnnotationWidget.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        LocalPt localPt = mapScale != null ? mapScale.wp2lp(new WorldPt(xpoints[0], ypoints[0])) : new LocalPt((int)location1.e, (int)location1.n);
        this.annotationPointL = new Point2D.Double(localPt.x, localPt.y);
        Point2D widgetLocation = this.location;
        if (widgetLocation == null) {
            int hypot = 50;
            double newX = this.annotationPointL.getX() + (double)hypot * Math.cos(0.7853981633974483);
            double newY = this.annotationPointL.getY() - (double)hypot * Math.sin(0.7853981633974483);
            this.bounds.x = (int)newX;
            this.bounds.y = (int)newY;
            widgetLocation = new Point2D.Double(newX, newY);
        }
        int cornerRound = 5;
        BufferedImage buffImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.component.getWidth() + 2 * cornerRound, this.component.getHeight() + 2 * cornerRound, 3);
        int width = buffImage.getWidth();
        int height = buffImage.getHeight();
        Point2D annotationPt = this.getAnnotationPoint();
        GeometryFactory gf = new GeometryFactory();
        Geometry toGeometry = gf.toGeometry(new Envelope((double)((int)widgetLocation.getX()), (double)((int)widgetLocation.getX() + buffImage.getWidth()), (double)((int)widgetLocation.getY()), (double)((int)widgetLocation.getY() + buffImage.getHeight())));
        Geometry convexGeom = toGeometry = toGeometry.buffer((double)(-cornerRound)).buffer((double)cornerRound);
        Point createPoint = gf.createPoint(new Coordinate(annotationPt.getX(), annotationPt.getY()));
        Coordinate[] nearestPoints = DistanceOp.nearestPoints((Geometry)convexGeom, (Geometry)createPoint);
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(2.0f));
        g.drawLine((int)annotationPt.getX(), (int)annotationPt.getY(), (int)nearestPoints[0].x, (int)nearestPoints[0].y);
        g.setStroke(new BasicStroke(1.0f));
        Graphics2D buffG = buffImage.createGraphics();
        buffG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        buffG.setColor(new Color(0, 0, 0, 0));
        buffG.fillRoundRect(0, 0, width - 1, height - 1, cornerRound, cornerRound);
        buffG.setColor(new Color(4359379));
        buffG.fillRoundRect(0, 0, width - 1, height - 1, cornerRound, cornerRound);
        Color c1 = new Color(255, 255, 255, 150);
        Color c2 = new Color(255, 255, 255, 0);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, c1, 0.0f, height, c2, false);
        buffG.setPaint(gradient);
        buffG.fillRoundRect(0, 0, width - 1, height - 1, cornerRound, cornerRound);
        buffG.setPaint(Color.BLACK);
        buffG.setStroke(new BasicStroke(2.0f));
        buffG.drawRoundRect(0, 0, width - 1, height - 1, cornerRound, cornerRound);
        buffG.translate(buffImage.getWidth() / 2 - this.component.getWidth() / 2, buffImage.getHeight() / 2 - this.component.getHeight() / 2);
        this.component.paint(buffG);
        buffG.dispose();
        ShadowRenderer sr = new ShadowRenderer(5, 0.75f, Color.BLACK);
        BufferedImage createShadow = sr.createShadow(buffImage);
        g.drawImage((Image)createShadow, (int)widgetLocation.getX(), (int)widgetLocation.getY(), null);
        g.drawImage((Image)buffImage, (int)widgetLocation.getX(), (int)widgetLocation.getY(), null);
        g.drawLine((int)annotationPt.getX(), (int)annotationPt.getY(), (int)nearestPoints[0].x, (int)nearestPoints[0].y);
        g.translate(annotationPt.getX() - 5.0, annotationPt.getY() - 5.0);
        g.fillOval(0, 0, 10, 10);
        c1 = new Color(255, 255, 255, 150);
        c2 = new Color(255, 255, 255, 0);
        gradient = new GradientPaint(0.0f, 0.0f, c1, 0.0f, 10.0f, c2, false);
        g.setPaint(gradient);
        g.fillOval(0, 0, 10, 10);
        g.dispose();
    }
}

