/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import hec.map.WorldPt;
import hec.map.annotations.Annotation;
import hec.map.crs.CoordinateReferenceSystem;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import rma.swing.RmaImage;

@XmlRootElement(name="LabelAnnotation")
@XmlType(name="LabelAnnotation")
public class LabelAnnotation
extends Annotation {
    @XmlElement(name="text")
    String text = "";
    @XmlElement(name="iconPath")
    String iconPath = "";

    @Deprecated
    public LabelAnnotation() {
    }

    public LabelAnnotation(WorldPt locationToAnnotate, CoordinateReferenceSystem crs, String text, String iconPath) {
        super(locationToAnnotate, crs);
        this.text = text;
        this.iconPath = iconPath;
        this.component = new JLabel(text);
        ImageIcon icon = RmaImage.getImageIcon(iconPath);
        if (icon != null) {
            ((JLabel)this.component).setIcon(icon);
        }
    }

    @Override
    public JComponent createComponent() {
        JComponent rcomponent = super.createComponent();
        if (rcomponent == null) {
            this.component = new JLabel(this.text);
            ImageIcon icon = RmaImage.getImageIcon(this.iconPath);
            if (icon != null) {
                ((JLabel)this.component).setIcon(icon);
            }
            rcomponent = this.component;
        }
        return rcomponent;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.component = null;
        this.text = text;
    }
}

