/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import hec.map.annotations.GraphicsUtilities;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ShadowRenderer {
    public static final String SIZE_CHANGED_PROPERTY = "shadow_size";
    public static final String OPACITY_CHANGED_PROPERTY = "shadow_opacity";
    public static final String COLOR_CHANGED_PROPERTY = "shadow_color";
    private int size = 5;
    private float opacity = 0.5f;
    private Color color = Color.BLACK;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public ShadowRenderer() {
        this(5, 0.5f, Color.BLACK);
    }

    public ShadowRenderer(int size, float opacity, Color color) {
        this.setSize(size);
        this.setOpacity(opacity);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color shadowColor) {
        if (shadowColor != null) {
            Color oldColor = this.color;
            this.color = shadowColor;
            this.changeSupport.firePropertyChange(COLOR_CHANGED_PROPERTY, oldColor, this.color);
        }
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float shadowOpacity) {
        float oldOpacity = this.opacity;
        this.opacity = (double)shadowOpacity < 0.0 ? 0.0f : (shadowOpacity > 1.0f ? 1.0f : shadowOpacity);
        this.changeSupport.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(oldOpacity), Float.valueOf(this.opacity));
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int shadowSize) {
        int oldSize = this.size;
        this.size = shadowSize < 0 ? 0 : shadowSize;
        this.changeSupport.firePropertyChange(SIZE_CHANGED_PROPERTY, new Integer(oldSize), new Integer(this.size));
    }

    public BufferedImage createShadow(BufferedImage image) {
        int a;
        int aSum;
        int historyIdx;
        int shadowSize = this.size * 2;
        int srcWidth = image.getWidth();
        int srcHeight = image.getHeight();
        int dstWidth = srcWidth + shadowSize;
        int dstHeight = srcHeight + shadowSize;
        int left = this.size;
        int right = shadowSize - left;
        int yStop = dstHeight - right;
        int shadowRgb = this.color.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        BufferedImage dst = new BufferedImage(dstWidth, dstHeight, 2);
        int[] dstBuffer = new int[dstWidth * dstHeight];
        int[] srcBuffer = new int[srcWidth * srcHeight];
        GraphicsUtilities.getPixels(image, 0, 0, srcWidth, srcHeight, srcBuffer);
        int lastPixelOffset = right * dstWidth;
        float hSumDivider = 1.0f / (float)shadowSize;
        float vSumDivider = this.opacity / (float)shadowSize;
        int[] hSumLookup = new int[256 * shadowSize];
        for (int i = 0; i < hSumLookup.length; ++i) {
            hSumLookup[i] = (int)((float)i * hSumDivider);
        }
        int[] vSumLookup = new int[256 * shadowSize];
        for (int i = 0; i < vSumLookup.length; ++i) {
            vSumLookup[i] = (int)((float)i * vSumDivider);
        }
        int dstOffset = left * dstWidth;
        for (int srcY = 0; srcY < srcHeight; ++srcY) {
            historyIdx = 0;
            while (historyIdx < shadowSize) {
                aHistory[historyIdx++] = 0;
            }
            aSum = 0;
            historyIdx = 0;
            int srcOffset = srcY * srcWidth;
            for (int srcX = 0; srcX < srcWidth; ++srcX) {
                a = hSumLookup[aSum];
                dstBuffer[dstOffset++] = a << 24;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = srcBuffer[srcOffset + srcX] >>> 24;
                aSum += a;
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
            for (int i = 0; i < shadowSize; ++i) {
                a = hSumLookup[aSum];
                dstBuffer[dstOffset++] = a << 24;
                aSum -= aHistory[historyIdx];
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
        }
        int x = 0;
        int bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            while (historyIdx < left) {
                aHistory[historyIdx++] = 0;
            }
            int y = 0;
            while (y < right) {
                a = dstBuffer[bufferOffset] >>> 24;
                aHistory[historyIdx++] = a;
                aSum += a;
                ++y;
                bufferOffset += dstWidth;
            }
            bufferOffset = x;
            historyIdx = 0;
            y = 0;
            while (y < yStop) {
                a = vSumLookup[aSum];
                dstBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dstBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y;
                bufferOffset += dstWidth;
            }
            y = yStop;
            while (y < dstHeight) {
                a = vSumLookup[aSum];
                dstBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
        GraphicsUtilities.setPixels(dst, 0, 0, dstWidth, dstHeight, dstBuffer);
        return dst;
    }
}

