/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations;

import hec.map.MapScale;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Widget {
    private HashMap<Widget, Object> constraints;
    protected Dimension preferredSize;
    protected Rectangle preferredBounds;
    protected Point2D location;
    protected Rectangle bounds;
    List<Widget> children = new ArrayList<Widget>();

    public void addChild(Widget w) {
        this.children.add(w);
    }

    public List<Widget> getChildren() {
        return this.children;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public boolean isVisible() {
        return true;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public final void resolveBounds(Point2D location, Rectangle bounds) {
        this.location = location != null ? location : new Point2D.Double();
        this.bounds = bounds != null ? new Rectangle(bounds) : new Rectangle(this.getPreferredBounds());
    }

    public final Object getChildConstraint(Widget child) {
        return this.constraints != null ? this.constraints.get(child) : null;
    }

    public final Dimension getPreferredSize() {
        return this.preferredSize != null ? new Dimension(this.preferredSize) : null;
    }

    public final Rectangle getPreferredBounds() {
        return new Rectangle(this.preferredBounds);
    }

    public final Rectangle getClientArea() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        Insets insets = new Insets(0, 0, 0, 0);
        return new Rectangle(bounds.x + insets.left, bounds.y + insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
    }

    public void paintWidget(Graphics2D g, MapScale mapScale) {
    }
}

