/*
 * Decompiled with CFR 0.152.
 */
package hec.map.annotations.layout;

import hec.map.annotations.Widget;
import hec.map.annotations.layout.Layout;
import hec.map.annotations.layout.LayoutFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;

public final class FlowLayout
implements Layout {
    private boolean verticalOrientation;
    private LayoutFactory.SerialAlignment alignment;
    private int gap;

    public FlowLayout(boolean verticalOrientation, LayoutFactory.SerialAlignment alignment, int gap) {
        this.verticalOrientation = verticalOrientation;
        this.alignment = alignment;
        this.gap = 5;
    }

    @Override
    public void layout(Widget widget) {
        int max = 0;
        List<Widget> children = widget.getChildren();
        if (this.verticalOrientation) {
            for (Widget widget2 : children) {
                if (!widget2.isVisible()) continue;
                Rectangle preferredBounds = widget2.getPreferredBounds();
                int i = preferredBounds.width;
                if (i <= max) continue;
                max = i;
            }
            int pos = 0;
            for (Widget child : children) {
                Rectangle preferredBounds = child.getPreferredBounds();
                int x = preferredBounds.x;
                int y = preferredBounds.y;
                int width = preferredBounds.width;
                int height = preferredBounds.height;
                int lx = x;
                int ly = pos + y;
                switch (this.alignment) {
                    case CENTER: {
                        lx += (max - width) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        width = max;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        lx += max - width;
                    }
                }
                if (child.isVisible()) {
                    child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, width, height));
                    pos += height + this.gap;
                    continue;
                }
                child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, 0, 0));
            }
        } else {
            for (Widget widget3 : children) {
                if (!widget3.isVisible()) continue;
                Rectangle preferredBounds = widget3.getPreferredBounds();
                int i = preferredBounds.height;
                if (i <= max) continue;
                max = i;
            }
            int pos = 0;
            for (Widget child : children) {
                Rectangle preferredBounds = child.getPreferredBounds();
                int x = preferredBounds.x;
                int y = preferredBounds.y;
                int width = preferredBounds.width;
                int height = preferredBounds.height;
                int lx = pos - x;
                int ly = -y;
                switch (this.alignment) {
                    case CENTER: {
                        ly += (max - height) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        height = max;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        ly += max - height;
                    }
                }
                if (child.isVisible()) {
                    child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, width, height));
                    pos += width + this.gap;
                    continue;
                }
                child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, 0, 0));
            }
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return true;
    }

    @Override
    public void justify(Widget widget) {
        Rectangle parentBounds = widget.getClientArea();
        int totalWeight = 0;
        int totalGap = 0;
        List<Widget> children = widget.getChildren();
        for (int a = 0; a < children.size(); ++a) {
            Widget child = children.get(a);
            if (!child.isVisible()) continue;
            totalWeight += FlowLayout.resolveWeight(widget, child);
            if (a > 0) {
                totalGap -= this.gap;
            }
            if (this.verticalOrientation) {
                totalGap -= child.getBounds().height;
                continue;
            }
            totalGap -= child.getBounds().width;
        }
        if ((totalGap += this.verticalOrientation ? parentBounds.height : parentBounds.width) < 0) {
            totalGap = 0;
            totalWeight = 0;
        }
        int gapAdd = 0;
        int weightAdd = 0;
        int parentX1 = parentBounds.x;
        int parentX2 = parentX1 + parentBounds.width;
        int parentY1 = parentBounds.y;
        int parentY2 = parentY1 + parentBounds.height;
        for (Widget child : widget.getChildren()) {
            int gap;
            int weight;
            Point2D childLocation = child.getLocation();
            Rectangle childBounds = child.getBounds();
            if (this.verticalOrientation) {
                switch (this.alignment) {
                    case CENTER: {
                        childLocation.setLocation((parentX1 + parentX2 - childBounds.width) / 2, childLocation.getY());
                        break;
                    }
                    case JUSTIFY: {
                        childLocation.setLocation(parentX1, childLocation.getY());
                        childBounds.width = parentX2 - parentX1;
                        break;
                    }
                    case LEFT_TOP: {
                        childLocation.setLocation(parentX1, childLocation.getY());
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        childLocation.setLocation(parentX2 - childBounds.width, childLocation.getY());
                    }
                }
                if (totalWeight > 0 && child.isVisible()) {
                    childLocation.setLocation(childLocation.getX(), childLocation.getX() + (double)gapAdd);
                    weight = FlowLayout.resolveWeight(widget, child);
                    gap = (weightAdd + weight) * totalGap / totalWeight;
                    childBounds.height += gap - gapAdd;
                    gapAdd = gap;
                    weightAdd += weight;
                }
                childLocation.setLocation(childLocation.getX() - (double)childBounds.x, childLocation.getY() + (double)parentY1);
            } else {
                switch (this.alignment) {
                    case CENTER: {
                        childLocation.setLocation(childLocation.getX(), (parentY1 + parentY2 - childBounds.height) / 2);
                        break;
                    }
                    case JUSTIFY: {
                        childBounds.height = parentY2 - parentY1;
                        childLocation.setLocation(childLocation.getX(), parentY1);
                        break;
                    }
                    case LEFT_TOP: {
                        childLocation.setLocation(childLocation.getX(), parentY1);
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        childLocation.setLocation(childLocation.getX(), parentY2 - childBounds.height);
                    }
                }
                if (totalWeight > 0 && child.isVisible()) {
                    childLocation.setLocation(childLocation.getX() + (double)gapAdd, childLocation.getY());
                    weight = FlowLayout.resolveWeight(widget, child);
                    gap = (weightAdd + weight) * totalGap / totalWeight;
                    childBounds.width += gap - gapAdd;
                    gapAdd = gap;
                    weightAdd += weight;
                }
                childLocation.setLocation(parentX1, childLocation.getY() - (double)childBounds.y);
            }
            child.resolveBounds(childLocation, childBounds);
        }
    }

    private static int resolveWeight(Widget widget, Widget child) {
        int weight;
        Object o = widget.getChildConstraint(child);
        if (o instanceof Number && (weight = ((Number)o).intValue()) > 0) {
            return weight;
        }
        return 0;
    }
}

