/*
 * Decompiled with CFR 0.152.
 */
package hec.map.crs;

import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.IdentityTransformImpl;
import hec.map.crs.Transform;
import rma.util.lookup.Lookup;

public abstract class CRS {
    private static CRS DEFAULT_CRS = null;

    public static CRS getDefault() {
        if (DEFAULT_CRS == null) {
            DEFAULT_CRS = (CRS)Lookup.getDefault().lookup(CRS.class);
        }
        if (DEFAULT_CRS == null) {
            DEFAULT_CRS = new TrivialCRS();
        }
        return DEFAULT_CRS;
    }

    public abstract CoordinateReferenceSystem parseWkt(String var1) throws CRSException;

    public abstract Transform findTransform(CoordinateReferenceSystem var1, CoordinateReferenceSystem var2, boolean var3) throws CRSException;

    private static class TrivialCRS
    extends CRS {
        private TrivialCRS() {
        }

        @Override
        public CoordinateReferenceSystem parseWkt(String wkt) throws CRSException {
            return null;
        }

        @Override
        public Transform findTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws CRSException {
            return new IdentityTransformImpl();
        }
    }
}

