/*
 * Decompiled with CFR 0.152.
 */
package hec.map.crs;

import hec.map.crs.CRSException;
import hec.map.crs.Transform;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class IdentityTransformImpl
implements Transform {
    @Override
    public void transform(double[] srcXPts, double[] srcYPts, int srcOffset, double[] dstXPts, double[] dstYPts, int dstOffset, int numPts) throws CRSException {
        System.arraycopy(srcXPts, srcOffset, dstXPts, dstOffset, numPts);
        System.arraycopy(srcYPts, srcOffset, dstYPts, dstOffset, numPts);
    }

    @Override
    public void transform(float[] srcXPts, float[] srcYPts, int srcOffset, float[] dstXPts, float[] dstYPts, int dstOffset, int numPts) throws CRSException {
        System.arraycopy(srcXPts, srcOffset, dstXPts, dstOffset, numPts);
        System.arraycopy(srcYPts, srcOffset, dstYPts, dstOffset, numPts);
    }

    @Override
    public Image transform(RenderedImage rImage, Rectangle2D extent) throws CRSException {
        Raster raster = rImage.getData();
        WritableRaster wraster = raster.createCompatibleWritableRaster();
        wraster.setDataElements(0, 0, raster);
        return new BufferedImage(ColorModel.getRGBdefault(), wraster, false, new Hashtable());
    }

    @Override
    public double[] transform(double srcXPt, double srcYPt, double[] returnPts) {
        double[] rtnValue = returnPts == null || returnPts.length < 2 ? new double[2] : returnPts;
        rtnValue[0] = srcXPt;
        rtnValue[1] = srcYPt;
        return rtnValue;
    }

    @Override
    public float[] transform(float srcXPt, float srcYPt, float[] returnPts) {
        float[] rtnValue = returnPts == null || returnPts.length < 2 ? new float[2] : returnPts;
        rtnValue[0] = srcXPt;
        rtnValue[1] = srcYPt;
        return rtnValue;
    }
}

