/*
 * Decompiled with CFR 0.152.
 */
package hec.map.crs.ui;

import hec.map.crs.CoordinateReferenceSystem;
import hec.map.crs.ui.DialogListener;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;
import rma.util.lookup.Lookup;

public abstract class DialogDisplayer {
    public static final String DIALOG_ENABLED = "DialogEnabled";

    public static void displayDialog(Component parent, String title, boolean modal, CoordinateReferenceSystem editingSystem, DialogListener listener) {
        DialogDisplayer.displayDialog(parent, title, modal, editingSystem, listener, new HashMap<String, String>());
    }

    public static void displayDialog(Component parent, String title, boolean modal, CoordinateReferenceSystem editingSystem, DialogListener listener, Map<String, String> parameters) {
        DialogDisplayer lookup = (DialogDisplayer)Lookup.getDefault().lookup(DialogDisplayer.class);
        if (lookup == null) {
            String msg = ResourceBundle.getBundle("hec/map/crs/ui/Bundle").getString("DialogDispalyer.Error.NoImplementation.label");
            Logger.getLogger(DialogDisplayer.class.getName()).log(Level.SEVERE, msg);
            RMAIO.postError(parent, msg);
            return;
        }
        lookup.showEditor(parent, title, modal, editingSystem, listener, parameters);
    }

    public abstract void showEditor(Component var1, String var2, boolean var3, CoordinateReferenceSystem var4, DialogListener var5, Map<String, String> var6);
}

