/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dem;

import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.dem.DemMap;
import hec.map.dem.ElevationProfile;
import java.util.List;

public class DemEnumerator {
    protected DemMap _map = null;
    protected WorldRect _boundingBox = null;
    protected List _profileSet = null;
    protected int _layer = 0;
    protected int _areaCols = 0;
    protected int _areaRows = 0;
    protected int _curCol = 0;
    protected int _curRow = -1;
    protected double _mapResZ = Double.NEGATIVE_INFINITY;
    protected double _mapResY = Double.NEGATIVE_INFINITY;
    protected double _mapResX = Double.NEGATIVE_INFINITY;
    protected ElevationProfile _curProfile = null;

    public DemEnumerator(DemMap map, int pSet, int layer) {
        this._map = map;
        this._boundingBox = map.getExtent();
        this._areaCols = map.getAreaWidth();
        this._areaRows = map.getAreaHeight();
        this._mapResZ = this._map.getResolutionZ();
        this._mapResY = this._map.getResolutionY();
        this._mapResX = this._map.getResolutionX();
        List[] allSets = map.getProfiles();
        this._profileSet = allSets[pSet];
        System.out.println("ProfileSet width  " + this._profileSet.size());
        System.out.println("Area width  " + this._areaCols);
        System.out.println("Area height " + this._areaRows);
        this._layer = layer;
        this._curProfile = (ElevationProfile)this._profileSet.get(this._curCol);
    }

    public boolean hasMoreElevations() {
        return this._curCol < this._areaCols;
    }

    public double nextElevation() {
        double dval = Double.NEGATIVE_INFINITY;
        ++this._curRow;
        if (this._curRow >= this._areaRows) {
            this._curRow = 0;
            ++this._curCol;
            if (!this.hasMoreElevations()) {
                return Double.POSITIVE_INFINITY;
            }
            this._curProfile = (ElevationProfile)this._profileSet.get(this._curCol);
        }
        int pSize = this._curProfile.getSize(this._layer);
        int rowOff = this._curProfile.getRowOff();
        int pIdx = this._curRow - rowOff;
        if (this._curRow >= rowOff && this._curRow <= rowOff + pSize - 1) {
            dval = this._curProfile.getElevation(this._layer, pIdx);
        }
        return dval;
    }

    public WorldPt currentLocation() {
        WorldPt pt = new WorldPt();
        pt.e = this._curProfile.getGpX();
        pt.n = this._curProfile.getGpY() + (double)(this._curRow - this._curProfile.getRowOff()) * this._mapResY;
        return pt;
    }

    public double northElevation() {
        double dval = Double.NEGATIVE_INFINITY;
        int rowOff = this._curProfile.getRowOff();
        if (this._curRow + 1 >= rowOff && this._curRow + 1 <= rowOff + this._curProfile.getSize(this._layer) - 1) {
            dval = this._curProfile.getElevation(this._layer, this._curRow - rowOff + 1);
        }
        return dval;
    }

    public double southElevation() {
        double dval = Double.NEGATIVE_INFINITY;
        int rowOff = this._curProfile.getRowOff();
        if (this._curRow - 1 >= rowOff && this._curRow - 1 <= rowOff + this._curProfile.getSize(this._layer) - 1) {
            dval = this._curProfile.getElevation(this._layer, this._curRow - rowOff - 1);
        }
        return dval;
    }

    public double westElevation() {
        ElevationProfile wProfile;
        int wRowOff;
        double dval = Double.NEGATIVE_INFINITY;
        if (this._curCol > 0 && this._curRow >= (wRowOff = (wProfile = (ElevationProfile)this._profileSet.get(this._curCol - 1)).getRowOff()) && this._curRow <= wRowOff + wProfile.getSize(this._layer) - 1) {
            dval = wProfile.getElevation(this._layer, this._curRow - wRowOff);
        }
        return dval;
    }

    public double eastElevation() {
        ElevationProfile eProfile;
        int eRowOff;
        double dval = Double.NEGATIVE_INFINITY;
        if (this._curCol < this._areaCols - 1 && this._curRow >= (eRowOff = (eProfile = (ElevationProfile)this._profileSet.get(this._curCol + 1)).getRowOff()) && this._curRow <= eRowOff + eProfile.getSize(this._layer) - 1) {
            dval = eProfile.getElevation(this._layer, this._curRow - eRowOff);
        }
        return dval;
    }
}

