/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dem;

import hec.map.ElevationGlyph;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.dem.DemEnumerator;
import hec.map.dem.DemGlyphDataRecord;
import hec.map.dem.DemMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Date;
import rma.util.ColorContour;
import rma.util.RMAIO;

public class DemGlyph
extends MapGlyph
implements Serializable,
ImageObserver,
ElevationGlyph {
    protected Image _img = null;
    protected int _areaWidth = Integer.MIN_VALUE;
    protected int _areaHeight = Integer.MIN_VALUE;
    protected MediaTracker _tracker = null;

    public DemGlyph(MapPanel panel, DemMap map) {
        this.setMapPanel(panel);
        this.setMap(map);
        this._areaWidth = map.getAreaWidth();
        this._areaHeight = map.getAreaHeight();
    }

    @Override
    public void fillMap(boolean load) {
        super.fillMap(load);
        if (load) {
            this.createImage();
        } else if (this._img != null) {
            try {
                this._tracker.removeImage(this._img);
            }
            catch (Exception e) {
                System.out.println("Error removing image from tracker.  " + e);
            }
            this._img = null;
        }
    }

    @Override
    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getElevation(WorldPt pt) {
        DemMap map = (DemMap)this._map;
        return map.getElevation(0, 0, pt);
    }

    @Override
    public double getMaximumElevation() {
        DemMap map = (DemMap)this._map;
        return map.getMaximumElevation();
    }

    @Override
    public double getMinimumElevation() {
        DemMap map = (DemMap)this._map;
        return map.getMinimumElevation();
    }

    protected void createImage() {
        if (this._mapPanel == null) {
            return;
        }
        try {
            long t1 = new Date().getTime();
            DemGlyphDataRecord data = (DemGlyphDataRecord)this.getDataRecord();
            if (data == null) {
                data = new DemGlyphDataRecord();
                this.setDataRecord(data);
            }
            if (!data.getSet()) {
                data.setGlyph(this);
            }
            DemMap map = (DemMap)this._map;
            this._areaWidth = map.getAreaWidth();
            this._areaHeight = map.getAreaHeight();
            WorldRect boundingBox = map.getExtent();
            int[] pix = new int[this._areaHeight * this._areaWidth];
            int pixIdx = this._areaHeight * this._areaWidth - this._areaWidth;
            int ii = 0;
            double aa = data.getAspectAngle();
            double theta = -Math.PI / 180 * (aa - 90.0);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double sinPhi = 0.5;
            double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
            cosTheta /= aaMag;
            sinTheta /= aaMag;
            sinPhi /= aaMag;
            double[] vec0 = new double[3];
            double[] vec1 = new double[3];
            double[] cross = new double[3];
            DemEnumerator enumaration = map.getEnumerator(0, 0);
            while (enumaration.hasMoreElevations()) {
                int rgb;
                double val = enumaration.nextElevation();
                if (val == Double.POSITIVE_INFINITY) continue;
                if (val == Double.NEGATIVE_INFINITY) {
                    pix[pixIdx] = 0;
                    if ((pixIdx -= this._areaWidth) >= 0) continue;
                    pixIdx = this._areaHeight * this._areaWidth - this._areaWidth + ++ii;
                    continue;
                }
                ColorContour cc = data.getColorContour();
                double lafc = 1.0;
                if (data.getAspectEnabled()) {
                    double eleN = enumaration.northElevation();
                    double eleE = enumaration.eastElevation();
                    double eleS = enumaration.southElevation();
                    double eleW = enumaration.westElevation();
                    if (eleN == Double.NEGATIVE_INFINITY) {
                        eleN = val;
                    }
                    if (eleS == Double.NEGATIVE_INFINITY) {
                        eleS = val;
                    }
                    if (eleW == Double.NEGATIVE_INFINITY) {
                        eleW = val;
                    }
                    if (eleE == Double.NEGATIVE_INFINITY) {
                        eleE = val;
                    }
                    vec0[0] = 2.0 * map.getResolutionX();
                    vec0[1] = 0.0;
                    vec0[2] = (eleE - eleW) * 10.0;
                    vec1[0] = 0.0;
                    vec1[1] = 2.0 * map.getResolutionY();
                    vec1[2] = (eleN - eleS) * 10.0;
                    cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                    cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                    cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                    double nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                    double dot = 1.0;
                    if (nMag != 0.0) {
                        dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                    }
                    if (cross[2] < 0.0) {
                        dot *= -1.0;
                    }
                    lafc = (dot + 1.25) / 2.25;
                }
                Color color = cc.getColor(val, lafc);
                pix[pixIdx] = rgb = color.getRGB();
                if ((pixIdx -= this._areaWidth) >= 0) continue;
                pixIdx = this._areaHeight * this._areaWidth - this._areaWidth + ++ii;
            }
            if (this._tracker == null) {
                this._tracker = new MediaTracker(this._mapPanel);
            }
            MemoryImageSource mis = new MemoryImageSource(this._areaWidth, this._areaHeight, pix, 0, this._areaWidth);
            if (this._img != null) {
                try {
                    this._tracker.removeImage(this._img);
                }
                catch (Exception e) {
                    System.out.println("Error removing image from tracker.  " + e);
                }
            }
            this._img = Toolkit.getDefaultToolkit().createImage(mis);
            this._tracker.addImage(this._img, 0);
            try {
                this._tracker.waitForAll();
            }
            catch (Exception e) {
                System.out.println("Error waiting for image from tracker.  " + e);
            }
            long t2 = new Date().getTime();
            System.out.println("**  Dem Glyph Image Build took  " + new Long(t2 - t1).toString() + " ms.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        if (this._img == null) {
            return;
        }
        DemGlyphDataRecord data = (DemGlyphDataRecord)this.getDataRecord();
        if (data.isModified()) {
            this.createImage();
            data.setModified(false);
        }
        WorldRect swr = scl.getWorldRect();
        WorldRect mwr = this._map.getExtent();
        WorldRect iwr = swr.getIntersection(mwr);
        if (_paintOk && iwr != null) {
            if (this._areaWidth == Integer.MIN_VALUE || this._areaHeight == Integer.MIN_VALUE) {
                return;
            }
            double xscl = (double)this._areaWidth / (mwr.e - mwr.w);
            double yscl = (double)this._areaHeight / (mwr.n - mwr.s);
            LocalRect ilr = scl.wr2lr(iwr);
            double zoom = scl.getZoom();
            int dx1 = ilr.l;
            int dy1 = ilr.t;
            int dx2 = ilr.r;
            int dy2 = ilr.b;
            int sx1 = (int)((iwr.w - mwr.w) * xscl);
            int sy1 = (int)((mwr.n - iwr.n) * yscl);
            int sx2 = (int)((iwr.e - mwr.w) * xscl);
            int sy2 = (int)((mwr.n - iwr.s) * yscl);
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Composite oldac = g2.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, data.getAlpha());
                g2.setComposite(ac);
                g.drawImage(this._img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        WorldPt wpt = new WorldPt(this._mapPanel.scale().x2e(ix), this._mapPanel.scale().y2n(iy));
        return (float)this.getElevation(wpt);
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
        MapScale scl = this._mapPanel.scale();
        WorldRegion wreg = new WorldRegion();
        for (int kk = 0; kk < region.pts.size(); ++kk) {
            wreg.pts.addElement(scl.lp2wp((LocalPt)region.pts.elementAt(kk)));
        }
        LocalPt dp = new LocalPt();
        double elmax = Double.MIN_VALUE;
        double elmin = Double.MAX_VALUE;
        double elmean = 0.0;
        double elarea = 0.0;
        int icnt = 0;
        g.setPaintMode();
        g.setColor(Color.lightGray);
        DemMap map = (DemMap)this._map;
        DemEnumerator enumeration = map.getEnumerator(0, 0);
        while (enumeration.hasMoreElevations()) {
            WorldPt pt;
            double val = enumeration.nextElevation();
            if (val == Double.POSITIVE_INFINITY || val == Double.NEGATIVE_INFINITY || !wreg.contains(pt = enumeration.currentLocation())) continue;
            if (elmax < val) {
                elmax = val;
            }
            if (elmin > val) {
                elmin = val;
            }
            elmean += val;
            ++icnt;
        }
        if (icnt > 0) {
            elmean /= (double)icnt;
            elarea = (double)icnt * map.getResolutionX() * map.getResolutionY();
        }
        LocalPt lp = region.getCenterPt();
        g.setPaintMode();
        g.setFont(new Font("SansSerif", 0, 12));
        FontMetrics fm = g.getFontMetrics();
        if (icnt > 0) {
            String str1 = "MAX: " + RMAIO.setPrecision2(elmax, 0);
            String str2 = "MIN: " + RMAIO.setPrecision2(elmin, 0);
            String str3 = "AVG: " + RMAIO.setPrecision2(elmean, 0);
            String str4 = "AREA: " + RMAIO.setPrecision2(elarea, 0);
            int h = fm.getHeight() * 4;
            int w = fm.stringWidth(str4);
            g.setColor(Color.white);
            g.fillRect(lp.x - 1, lp.y - fm.getMaxAscent() - 1, w + 2, h + 2);
            g.setColor(Color.black);
            g.drawString(str1, lp.x, lp.y);
            lp.y += fm.getHeight();
            g.drawString(str2, lp.x, lp.y);
            lp.y += fm.getHeight();
            g.drawString(str3, lp.x, lp.y);
            lp.y += fm.getHeight();
            g.drawString(str4, lp.x, lp.y);
        } else {
            String str1 = "NO POINTS SELECTED";
            int h = fm.getHeight();
            int w = fm.stringWidth(str1);
            g.setColor(Color.white);
            g.fillRect(lp.x - 1, lp.y - fm.getMaxAscent() - 1, w + 2, h + 2);
            g.setColor(Color.black);
            g.drawString(str1, lp.x, lp.y);
        }
    }
}

