/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dem;

import hec.map.MapPanel;
import hec.map.dem.DemGlyph;
import hec.map.dem.DemGlyphDataRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.util.AspectShadingColorContour;
import rma.util.Clipping;
import rma.util.ColorContour;
import rma.util.GrayscaleColorContour;
import rma.util.RGBColorContour;
import rma.util.RMAIO;
import rma.util.RMAUtil;
import rma.util.TerrainColorContour;

public class DemGlyphOptionJDlg
extends JDialog
implements ImageObserver {
    MapPanel _mapPanel = null;
    DemGlyph _glyph = null;
    DemGlyphDataRecord _data = null;
    Frame _parent = null;
    Image _img = null;
    int _height = 0;
    int _width = 0;
    boolean fComponentsAdjusted = false;
    JLabel jLabelName;
    JPanel jPanelOptions;
    JRadioButton jRadioButtonRGB;
    JRadioButton jRadioButtonTerrain;
    JRadioButton jRadioButtonGrayscale;
    JRadioButton jRadioButtonAspectShading;
    JLabel jLabelAspectColor;
    ColorButton jButtonAspectColor;
    JPanel jPanelContourLimits;
    JCheckBox jCheckBoxAuto;
    JLabel jLabelMax;
    JTextField jTextFieldMax;
    JLabel jLabelMin;
    JTextField jTextFieldMin;
    JPanel jPanelBody;
    JLabel jLabelBright;
    JSlider jSliderBright;
    JTextField jTextFieldBright;
    JLabel jLabelSat;
    JSlider jSliderSat;
    JTextField jTextFieldSat;
    JCheckBox jCheckBoxAspect;
    JLabel jLabelAngle;
    JSlider jSliderAspect;
    JTextField jTextFieldAspect;
    JCheckBox jCheckBoxMin;
    JLabel jLabelMinVal;
    JSlider jSliderMinVal;
    JTextField jTextFieldMinVal;
    JLabel jLabelMinColor;
    ColorButton jButtonMinColor;
    JCheckBox jCheckBoxMax;
    JLabel jLabelMaxVal;
    JSlider jSliderMaxVal;
    JTextField jTextFieldMaxVal;
    JLabel jLabelMaxColor;
    ColorButton jButtonMaxColor;
    JPanel jPanelColorScale;
    JPanel jPanelColorSample;
    JLabel jLabelSampleMax;
    JLabel jLabelSampleMin;
    JPanel jPanelButtons;
    JButton jButtonOk;
    JButton jButtonApply;
    JButton jButtonCancel;

    public DemGlyphOptionJDlg(Frame parent, boolean modal, MapPanel panel, DemGlyph glyph) {
        this(parent, modal);
        this.getContentPane().setBackground(this.getBackground());
        EtchedBorder eBorder = new EtchedBorder();
        TitledBorder tBorder = new TitledBorder(eBorder, "Scale");
        this.jPanelColorScale.setBorder(tBorder);
        eBorder = new EtchedBorder();
        tBorder = new TitledBorder(eBorder, "Contour Limits");
        this.jPanelContourLimits.setBorder(tBorder);
        ButtonGroup colorGroup = new ButtonGroup();
        colorGroup.add(this.jRadioButtonRGB);
        colorGroup.add(this.jRadioButtonTerrain);
        colorGroup.add(this.jRadioButtonGrayscale);
        colorGroup.add(this.jRadioButtonAspectShading);
        this._mapPanel = panel;
        this._glyph = glyph;
        DemGlyphDataRecord gData = (DemGlyphDataRecord)this._glyph.getDataRecord();
        this._data = (DemGlyphDataRecord)gData.clone();
        this.jLabelName.setText(this._glyph.getName());
        ColorContour cc = this._data.getColorContour();
        this.jLabelSampleMin.setText(RMAIO.toTable(cc.getMinValue()));
        this.jLabelSampleMax.setText(RMAIO.toTable(cc.getMaxValue()));
        this.setColorContour(cc);
        this.setAutoContour(this._data.getAutoContour());
        this.setBrightness(this._data.getBrightness());
        this.setSaturation(this._data.getSaturation());
        this.setAspect(this._data.getAspectEnabled(), this._data.getAspectAngle());
        Clipping clip = this._data.getMaxClipping();
        this.setMaxClipping(clip);
        clip = this._data.getMinClipping();
        this.setMinClipping(clip);
        this.jButtonAspectColor.setEnabled(this.jRadioButtonAspectShading.isSelected());
        this.jButtonAspectColor.setIcon(this.getColorIcon(this.jButtonAspectColor.getColor()));
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.jButtonOk.addActionListener(lSymAction);
        this.jButtonApply.addActionListener(lSymAction);
        this.jButtonCancel.addActionListener(lSymAction);
        this.jButtonMinColor.addActionListener(lSymAction);
        this.jButtonMaxColor.addActionListener(lSymAction);
        this.jButtonAspectColor.addActionListener(lSymAction);
        this.jCheckBoxMax.addActionListener(lSymAction);
        this.jRadioButtonRGB.addActionListener(lSymAction);
        this.jRadioButtonTerrain.addActionListener(lSymAction);
        this.jRadioButtonGrayscale.addActionListener(lSymAction);
        this.jRadioButtonAspectShading.addActionListener(lSymAction);
        this.jCheckBoxAuto.addActionListener(lSymAction);
        SymChange lSymChange = new SymChange();
        this.jSliderBright.addChangeListener(lSymChange);
        this.jSliderSat.addChangeListener(lSymChange);
        this.jSliderMinVal.addChangeListener(lSymChange);
        this.jSliderMaxVal.addChangeListener(lSymChange);
        this.jCheckBoxAspect.addActionListener(lSymAction);
        this.jCheckBoxMin.addActionListener(lSymAction);
        this.jSliderAspect.addChangeListener(lSymChange);
        SymKey aSymKey = new SymKey();
        this.jTextFieldMin.addKeyListener(aSymKey);
        this.jTextFieldMax.addKeyListener(aSymKey);
        this.jTextFieldBright.addKeyListener(aSymKey);
        this.jTextFieldSat.addKeyListener(aSymKey);
        this.jTextFieldAspect.addKeyListener(aSymKey);
        this.jTextFieldMinVal.addKeyListener(aSymKey);
        this.jTextFieldMaxVal.addKeyListener(aSymKey);
    }

    protected void paintScale() {
        if (this._data == null) {
            return;
        }
        this._width = this.jPanelColorSample.getWidth();
        this._height = this.jPanelColorSample.getHeight();
        int[] pix = new int[this._width * this._height];
        ColorContour cc = this._data.getColorContour();
        double max = cc.getMaxValue();
        double min = cc.getMinValue();
        double scl = (max - min) / (double)this._height;
        double sat = 1.0 - cc.getSaturation();
        double brite = cc.getBrightness();
        for (int ii = 0; ii < this._height; ++ii) {
            double val = max - (double)ii * scl;
            Color c2 = cc.getColor(val);
            for (int jj = 0; jj < this._width; ++jj) {
                pix[ii * this._width + jj] = c2.getRGB();
            }
        }
        MemoryImageSource mis = new MemoryImageSource(this._width, this._height, pix, 0, this._width);
        this._img = Toolkit.getDefaultToolkit().createImage(mis);
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this._img, 0);
        try {
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    protected ImageIcon getColorIcon(Color c2) {
        int w = 12;
        int h = 12;
        int rgb = c2.getRGB();
        int[] pix = new int[h * w];
        for (int ii = 0; ii < pix.length; ++ii) {
            pix[ii] = rgb;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        ImageIcon imgIcon = new ImageIcon(img);
        return imgIcon;
    }

    protected void setMaxClipping(Clipping clip) {
        Color c2 = clip.getColor();
        double val = clip.getValue();
        boolean enabled = clip.getEnabled();
        this.jSliderMaxVal.setValue((int)val);
        this.jSliderMaxVal.invalidate();
        this.jSliderMaxVal.validate();
        this.jSliderMaxVal.repaint();
        if (!this.jTextFieldMaxVal.hasFocus()) {
            this.jTextFieldMaxVal.setText(RMAIO.toTable(val));
        }
        this.jButtonMaxColor.setIcon(this.getColorIcon(c2));
        this.jButtonMaxColor.repaint();
        this.jCheckBoxMax.setSelected(enabled);
        this.jSliderMaxVal.setEnabled(enabled);
        this.jButtonMaxColor.setEnabled(enabled);
        this.jTextFieldMaxVal.setEnabled(enabled);
    }

    protected void setMinClipping(Clipping clip) {
        Color c2 = clip.getColor();
        double val = clip.getValue();
        boolean enabled = clip.getEnabled();
        this.jSliderMinVal.setValue((int)val);
        this.jSliderMinVal.invalidate();
        this.jSliderMinVal.validate();
        this.jSliderMinVal.repaint();
        if (!this.jTextFieldMinVal.hasFocus()) {
            this.jTextFieldMinVal.setText(RMAIO.toTable(val));
        }
        this.jButtonMinColor.setIcon(this.getColorIcon(c2));
        this.jButtonMinColor.repaint();
        this.jCheckBoxMin.setSelected(enabled);
        this.jSliderMinVal.setEnabled(enabled);
        this.jButtonMinColor.setEnabled(enabled);
        this.jTextFieldMinVal.setEnabled(enabled);
    }

    protected void setColorContour(ColorContour cc) {
        if (cc instanceof TerrainColorContour) {
            this.jRadioButtonTerrain.setSelected(true);
        } else if (cc instanceof GrayscaleColorContour) {
            this.jRadioButtonGrayscale.setSelected(true);
        } else if (cc instanceof RGBColorContour) {
            this.jRadioButtonRGB.setSelected(true);
        }
    }

    protected void setAutoContour(boolean tf) {
        this.jCheckBoxAuto.setSelected(tf);
        this.jTextFieldMax.setEnabled(!tf);
        this.jTextFieldMin.setEnabled(!tf);
        double max = this._data.getColorContour().getMaxValue();
        double min = this._data.getColorContour().getMinValue();
        if (tf && !this.jTextFieldMax.hasFocus() && this.jTextFieldMax.getText().equals("")) {
            this.jTextFieldMax.setText(RMAIO.toTable(max));
        }
        if (tf && !this.jTextFieldMin.hasFocus() && this.jTextFieldMin.getText().equals("")) {
            this.jTextFieldMin.setText(RMAIO.toTable(min));
        }
        if (!tf && !this.jTextFieldMax.hasFocus()) {
            this.jTextFieldMax.setText(RMAIO.toTable(max));
        }
        if (!tf && !this.jTextFieldMin.hasFocus()) {
            this.jTextFieldMin.setText(RMAIO.toTable(min));
        }
        this.jLabelSampleMin.setText(RMAIO.toTable(min));
        this.jLabelSampleMax.setText(RMAIO.toTable(max));
        this.jSliderMinVal.setMinimum((int)min);
        this.jSliderMinVal.setMaximum((int)max);
        this.jSliderMaxVal.setMinimum((int)min);
        this.jSliderMaxVal.setMaximum((int)max);
    }

    protected void setAspect(boolean enabled, double val) {
        this.jCheckBoxAspect.setSelected(enabled);
        this.jSliderAspect.setEnabled(enabled);
        this.jTextFieldAspect.setEnabled(enabled);
        this.jSliderAspect.setValue((int)val);
        if (!this.jTextFieldAspect.hasFocus()) {
            this.jTextFieldAspect.setText(RMAIO.toTable(val));
        }
    }

    protected void setBrightness(double val) {
        if (val < 0.0 || val > 1.0) {
            val = 1.0;
        }
        int sliderVal = (int)(val * 100.0);
        this.jSliderBright.setValue(sliderVal);
        if (!this.jTextFieldBright.hasFocus()) {
            this.jTextFieldBright.setText(RMAIO.toTable(val));
        }
    }

    protected void setSaturation(double val) {
        if (val < 0.0 || val > 1.0) {
            val = 1.0;
        }
        int sliderVal = (int)(val * 100.0);
        this.jSliderSat.setValue(sliderVal);
        if (!this.jTextFieldSat.hasFocus()) {
            this.jTextFieldSat.setText(RMAIO.toTable(val));
        }
    }

    public static void main(String[] args) {
        new DemGlyphOptionJDlg(new Frame(), false).setVisible(true);
    }

    public DemGlyphOptionJDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("DEM Options Dialog");
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setSize(300, 500);
        this.setBackground(new Color(0xC0C0C0));
        this.jLabelName = new JLabel();
        this.jLabelName.setText("Glyph Name");
        this.jLabelName.setHorizontalAlignment(0);
        this.jLabelName.setBounds(2, 2, 295, 15);
        this.jLabelName.setFont(new Font("Dialog", 1, 12));
        this.jLabelName.setForeground(new Color(-10066279));
        this.jLabelName.setBackground(new Color(-3355444));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.jLabelName, gbc);
        this.getContentPane().add(this.jLabelName);
        this.jPanelOptions = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanelOptions.setLayout(gridBagLayout);
        this.jPanelOptions.setBounds(2, 21, 256, 439);
        this.jPanelOptions.setFont(new Font("Dialog", 0, 12));
        this.jPanelOptions.setForeground(new Color(0));
        this.jPanelOptions.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 2.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.jPanelOptions, gbc);
        this.getContentPane().add(this.jPanelOptions);
        this.jRadioButtonRGB = new JRadioButton();
        this.jRadioButtonRGB.setText("Red-Green-Blue");
        this.jRadioButtonRGB.setActionCommand("Red-Green-Blue");
        this.jRadioButtonRGB.setBounds(2, 2, 252, 25);
        this.jRadioButtonRGB.setFont(new Font("Dialog", 1, 12));
        this.jRadioButtonRGB.setForeground(new Color(0));
        this.jRadioButtonRGB.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jRadioButtonRGB, gbc);
        this.jPanelOptions.add(this.jRadioButtonRGB);
        this.jRadioButtonTerrain = new JRadioButton();
        this.jRadioButtonTerrain.setText("Terrain");
        this.jRadioButtonTerrain.setActionCommand("Terrain");
        this.jRadioButtonTerrain.setBounds(2, 31, 252, 25);
        this.jRadioButtonTerrain.setFont(new Font("Dialog", 1, 12));
        this.jRadioButtonTerrain.setForeground(new Color(0));
        this.jRadioButtonTerrain.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jRadioButtonTerrain, gbc);
        this.jPanelOptions.add(this.jRadioButtonTerrain);
        this.jRadioButtonGrayscale = new JRadioButton();
        this.jRadioButtonGrayscale.setText("Grayscale");
        this.jRadioButtonGrayscale.setActionCommand("Grayscale");
        this.jRadioButtonGrayscale.setBounds(2, 60, 252, 25);
        this.jRadioButtonGrayscale.setFont(new Font("Dialog", 1, 12));
        this.jRadioButtonGrayscale.setForeground(new Color(0));
        this.jRadioButtonGrayscale.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jRadioButtonGrayscale, gbc);
        this.jPanelOptions.add(this.jRadioButtonGrayscale);
        this.jRadioButtonAspectShading = new JRadioButton();
        this.jRadioButtonAspectShading.setText("Aspect Shading");
        this.jRadioButtonAspectShading.setActionCommand("Aspect Shading");
        this.jRadioButtonAspectShading.setFont(new Font("Dialog", 1, 12));
        this.jRadioButtonAspectShading.setForeground(new Color(0));
        this.jRadioButtonAspectShading.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jRadioButtonAspectShading, gbc);
        this.jPanelOptions.add(this.jRadioButtonAspectShading);
        this.jLabelAspectColor = new JLabel();
        this.jLabelAspectColor.setText("Color");
        this.jLabelAspectColor.setHorizontalAlignment(4);
        this.jLabelAspectColor.setBounds(2, 164, 126, 15);
        this.jLabelAspectColor.setFont(new Font("Dialog", 1, 12));
        this.jLabelAspectColor.setForeground(new Color(-10066279));
        this.jLabelAspectColor.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jLabelAspectColor, gbc);
        this.jPanelOptions.add(this.jLabelAspectColor);
        this.jButtonAspectColor = new ColorButton();
        this.jButtonAspectColor.setColor(Color.white);
        this.jButtonAspectColor.setFont(new Font("Dialog", 1, 12));
        this.jButtonAspectColor.setForeground(new Color(0));
        this.jButtonAspectColor.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jButtonAspectColor, gbc);
        this.jPanelOptions.add(this.jButtonAspectColor);
        this.jPanelContourLimits = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanelContourLimits.setLayout(gridBagLayout);
        this.jPanelContourLimits.setBounds(2, 89, 252, 84);
        this.jPanelContourLimits.setFont(new Font("Dialog", 0, 12));
        this.jPanelContourLimits.setForeground(new Color(0));
        this.jPanelContourLimits.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jPanelContourLimits, gbc);
        this.jPanelOptions.add(this.jPanelContourLimits);
        this.jCheckBoxAuto = new JCheckBox();
        this.jCheckBoxAuto.setText("Automatic");
        this.jCheckBoxAuto.setActionCommand("Automatic");
        this.jCheckBoxAuto.setBounds(2, 6, 248, 25);
        this.jCheckBoxAuto.setFont(new Font("Dialog", 1, 12));
        this.jCheckBoxAuto.setForeground(new Color(0));
        this.jCheckBoxAuto.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelContourLimits.getLayout()).setConstraints(this.jCheckBoxAuto, gbc);
        this.jPanelContourLimits.add(this.jCheckBoxAuto);
        this.jLabelMax = new JLabel();
        this.jLabelMax.setText("Maximum");
        this.jLabelMax.setHorizontalAlignment(4);
        this.jLabelMax.setBounds(2, 37, 56, 15);
        this.jLabelMax.setFont(new Font("Dialog", 1, 12));
        this.jLabelMax.setForeground(new Color(-10066279));
        this.jLabelMax.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelContourLimits.getLayout()).setConstraints(this.jLabelMax, gbc);
        this.jPanelContourLimits.add(this.jLabelMax);
        this.jTextFieldMax = new JTextField();
        this.jTextFieldMax.setText("");
        this.jTextFieldMax.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldMax.setBounds(62, 35, 188, 19);
        this.jTextFieldMax.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldMax.setForeground(new Color(0));
        this.jTextFieldMax.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelContourLimits.getLayout()).setConstraints(this.jTextFieldMax, gbc);
        this.jPanelContourLimits.add(this.jTextFieldMax);
        this.jLabelMin = new JLabel();
        this.jLabelMin.setText("Minimum");
        this.jLabelMin.setHorizontalAlignment(4);
        this.jLabelMin.setBounds(2, 60, 56, 15);
        this.jLabelMin.setFont(new Font("Dialog", 1, 12));
        this.jLabelMin.setForeground(new Color(-10066279));
        this.jLabelMin.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelContourLimits.getLayout()).setConstraints(this.jLabelMin, gbc);
        this.jPanelContourLimits.add(this.jLabelMin);
        this.jTextFieldMin = new JTextField();
        this.jTextFieldMin.setText("");
        this.jTextFieldMin.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldMin.setBounds(62, 58, 188, 19);
        this.jTextFieldMin.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldMin.setForeground(new Color(0));
        this.jTextFieldMin.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelContourLimits.getLayout()).setConstraints(this.jTextFieldMin, gbc);
        this.jPanelContourLimits.add(this.jTextFieldMin);
        this.jPanelBody = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanelBody.setLayout(gridBagLayout);
        this.jPanelBody.setBounds(2, 177, 252, 259);
        this.jPanelBody.setFont(new Font("Dialog", 0, 12));
        this.jPanelBody.setForeground(new Color(0));
        this.jPanelBody.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelOptions.getLayout()).setConstraints(this.jPanelBody, gbc);
        this.jPanelOptions.add(this.jPanelBody);
        this.jLabelBright = new JLabel();
        this.jLabelBright.setText("Brightness (0.0-1.0)");
        this.jLabelBright.setHorizontalAlignment(4);
        this.jLabelBright.setBounds(2, 9, 126, 15);
        this.jLabelBright.setFont(new Font("Dialog", 1, 12));
        this.jLabelBright.setForeground(new Color(-10066279));
        this.jLabelBright.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelBright, gbc);
        this.jPanelBody.add(this.jLabelBright);
        this.jSliderBright = new JSlider();
        this.jSliderBright.setSnapToTicks(false);
        this.jSliderBright.setBounds(132, 6, 73, 21);
        this.jSliderBright.setForeground(new Color(-6710836));
        this.jSliderBright.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jSliderBright, gbc);
        this.jPanelBody.add(this.jSliderBright);
        this.jTextFieldBright = new JTextField();
        this.jTextFieldBright.setText("0000");
        this.jTextFieldBright.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldBright.setBounds(207, 7, 44, 19);
        this.jTextFieldBright.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldBright.setForeground(new Color(0));
        this.jTextFieldBright.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jTextFieldBright, gbc);
        this.jPanelBody.add(this.jTextFieldBright);
        this.jLabelSat = new JLabel();
        this.jLabelSat.setText("Saturation (0.0-1.0)");
        this.jLabelSat.setHorizontalAlignment(4);
        this.jLabelSat.setBounds(2, 34, 126, 15);
        this.jLabelSat.setFont(new Font("Dialog", 1, 12));
        this.jLabelSat.setForeground(new Color(-10066279));
        this.jLabelSat.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelSat, gbc);
        this.jPanelBody.add(this.jLabelSat);
        this.jSliderSat = new JSlider();
        this.jSliderSat.setSnapToTicks(false);
        this.jSliderSat.setBounds(132, 31, 73, 21);
        this.jSliderSat.setForeground(new Color(-6710836));
        this.jSliderSat.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jSliderSat, gbc);
        this.jPanelBody.add(this.jSliderSat);
        this.jTextFieldSat = new JTextField();
        this.jTextFieldSat.setText("0000");
        this.jTextFieldSat.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldSat.setBounds(207, 32, 44, 19);
        this.jTextFieldSat.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldSat.setForeground(new Color(0));
        this.jTextFieldSat.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jTextFieldSat, gbc);
        this.jPanelBody.add(this.jTextFieldSat);
        this.jCheckBoxAspect = new JCheckBox();
        this.jCheckBoxAspect.setText("Aspect Shading");
        this.jCheckBoxAspect.setActionCommand("Aspect Shading");
        this.jCheckBoxAspect.setBounds(2, 56, 247, 25);
        this.jCheckBoxAspect.setFont(new Font("Dialog", 1, 12));
        this.jCheckBoxAspect.setForeground(new Color(0));
        this.jCheckBoxAspect.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jCheckBoxAspect, gbc);
        this.jPanelBody.add(this.jCheckBoxAspect);
        this.jLabelAngle = new JLabel();
        this.jLabelAngle.setText("Angle (0-360 Degrees)");
        this.jLabelAngle.setHorizontalAlignment(4);
        this.jLabelAngle.setBounds(2, 88, 126, 15);
        this.jLabelAngle.setFont(new Font("Dialog", 1, 12));
        this.jLabelAngle.setForeground(new Color(-10066279));
        this.jLabelAngle.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelAngle, gbc);
        this.jPanelBody.add(this.jLabelAngle);
        this.jSliderAspect = new JSlider();
        this.jSliderAspect.setRequestFocusEnabled(false);
        this.jSliderAspect.setValue(100);
        this.jSliderAspect.setMaximum(360);
        this.jSliderAspect.setBounds(132, 85, 73, 21);
        this.jSliderAspect.setForeground(new Color(-6710836));
        this.jSliderAspect.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jSliderAspect, gbc);
        this.jPanelBody.add(this.jSliderAspect);
        this.jTextFieldAspect = new JTextField();
        this.jTextFieldAspect.setText("0000");
        this.jTextFieldAspect.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldAspect.setBounds(207, 86, 44, 19);
        this.jTextFieldAspect.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldAspect.setForeground(new Color(0));
        this.jTextFieldAspect.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jTextFieldAspect, gbc);
        this.jPanelBody.add(this.jTextFieldAspect);
        this.jCheckBoxMax = new JCheckBox();
        this.jCheckBoxMax.setText("Maximum Clipping");
        this.jCheckBoxMax.setActionCommand("Maximum Clipping");
        this.jCheckBoxMax.setBounds(2, 183, 247, 25);
        this.jCheckBoxMax.setFont(new Font("Dialog", 1, 12));
        this.jCheckBoxMax.setForeground(new Color(0));
        this.jCheckBoxMax.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jCheckBoxMax, gbc);
        this.jPanelBody.add(this.jCheckBoxMax);
        this.jLabelMaxVal = new JLabel();
        this.jLabelMaxVal.setText("Value");
        this.jLabelMaxVal.setHorizontalAlignment(4);
        this.jLabelMaxVal.setBounds(2, 215, 126, 15);
        this.jLabelMaxVal.setFont(new Font("Dialog", 1, 12));
        this.jLabelMaxVal.setForeground(new Color(-10066279));
        this.jLabelMaxVal.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelMaxVal, gbc);
        this.jPanelBody.add(this.jLabelMaxVal);
        this.jSliderMaxVal = new JSlider();
        this.jSliderMaxVal.setSnapToTicks(false);
        this.jSliderMaxVal.setBounds(132, 212, 73, 21);
        this.jSliderMaxVal.setForeground(new Color(-6710836));
        this.jSliderMaxVal.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jSliderMaxVal, gbc);
        this.jPanelBody.add(this.jSliderMaxVal);
        this.jTextFieldMaxVal = new JTextField();
        this.jTextFieldMaxVal.setText("0000");
        this.jTextFieldMaxVal.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldMaxVal.setBounds(207, 213, 44, 19);
        this.jTextFieldMaxVal.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldMaxVal.setForeground(new Color(0));
        this.jTextFieldMaxVal.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jTextFieldMaxVal, gbc);
        this.jPanelBody.add(this.jTextFieldMaxVal);
        this.jLabelMaxColor = new JLabel();
        this.jLabelMaxColor.setText("Color");
        this.jLabelMaxColor.setHorizontalAlignment(4);
        this.jLabelMaxColor.setBounds(2, 237, 126, 15);
        this.jLabelMaxColor.setFont(new Font("Dialog", 1, 12));
        this.jLabelMaxColor.setForeground(new Color(-10066279));
        this.jLabelMaxColor.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelMaxColor, gbc);
        this.jPanelBody.add(this.jLabelMaxColor);
        this.jButtonMaxColor = new ColorButton();
        this.jButtonMaxColor.setBounds(132, 235, 35, 19);
        this.jButtonMaxColor.setFont(new Font("Dialog", 1, 12));
        this.jButtonMaxColor.setForeground(new Color(0));
        this.jButtonMaxColor.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jButtonMaxColor, gbc);
        this.jPanelBody.add(this.jButtonMaxColor);
        this.jCheckBoxMin = new JCheckBox();
        this.jCheckBoxMin.setText("Minimum Clipping");
        this.jCheckBoxMin.setActionCommand("Minimum Clipping");
        this.jCheckBoxMin.setBounds(2, 110, 247, 25);
        this.jCheckBoxMin.setFont(new Font("Dialog", 1, 12));
        this.jCheckBoxMin.setForeground(new Color(0));
        this.jCheckBoxMin.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jCheckBoxMin, gbc);
        this.jPanelBody.add(this.jCheckBoxMin);
        this.jLabelMinVal = new JLabel();
        this.jLabelMinVal.setText("Value");
        this.jLabelMinVal.setHorizontalAlignment(4);
        this.jLabelMinVal.setBounds(2, 142, 126, 15);
        this.jLabelMinVal.setFont(new Font("Dialog", 1, 12));
        this.jLabelMinVal.setForeground(new Color(-10066279));
        this.jLabelMinVal.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelMinVal, gbc);
        this.jPanelBody.add(this.jLabelMinVal);
        this.jSliderMinVal = new JSlider();
        this.jSliderMinVal.setSnapToTicks(false);
        this.jSliderMinVal.setBounds(132, 139, 73, 21);
        this.jSliderMinVal.setForeground(new Color(-6710836));
        this.jSliderMinVal.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 3.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jSliderMinVal, gbc);
        this.jPanelBody.add(this.jSliderMinVal);
        this.jTextFieldMinVal = new JTextField();
        this.jTextFieldMinVal.setText("0000");
        this.jTextFieldMinVal.setMargin(new Insets(0, 0, 0, 0));
        this.jTextFieldMinVal.setBounds(207, 140, 44, 19);
        this.jTextFieldMinVal.setFont(new Font("SansSerif", 0, 12));
        this.jTextFieldMinVal.setForeground(new Color(0));
        this.jTextFieldMinVal.setBackground(new Color(0xFFFFFF));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jTextFieldMinVal, gbc);
        this.jPanelBody.add(this.jTextFieldMinVal);
        this.jLabelMinColor = new JLabel();
        this.jLabelMinColor.setText("Color");
        this.jLabelMinColor.setHorizontalAlignment(4);
        this.jLabelMinColor.setBounds(2, 164, 126, 15);
        this.jLabelMinColor.setFont(new Font("Dialog", 1, 12));
        this.jLabelMinColor.setForeground(new Color(-10066279));
        this.jLabelMinColor.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jLabelMinColor, gbc);
        this.jPanelBody.add(this.jLabelMinColor);
        this.jButtonMinColor = new ColorButton();
        this.jButtonMinColor.setBounds(132, 162, 35, 19);
        this.jButtonMinColor.setFont(new Font("Dialog", 1, 12));
        this.jButtonMinColor.setForeground(new Color(0));
        this.jButtonMinColor.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        ((GridBagLayout)this.jPanelBody.getLayout()).setConstraints(this.jButtonMinColor, gbc);
        this.jPanelBody.add(this.jButtonMinColor);
        this.jPanelColorScale = new JPanel();
        this.jPanelColorScale.setFont(new Font("Dialog", 0, 12));
        gridBagLayout = new GridBagLayout();
        this.jPanelColorScale.setLayout(gridBagLayout);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.jPanelColorScale, gbc);
        this.getContentPane().add(this.jPanelColorScale);
        this.jLabelSampleMax = new JLabel();
        this.jLabelSampleMax.setText("0000");
        this.jLabelSampleMax.setHorizontalAlignment(4);
        this.jLabelSampleMax.setFont(new Font("Dialog", 1, 12));
        this.jLabelSampleMax.setForeground(new Color(-10066279));
        this.jLabelSampleMax.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        ((GridBagLayout)this.jPanelColorScale.getLayout()).setConstraints(this.jLabelSampleMax, gbc);
        this.jPanelColorScale.add(this.jLabelSampleMax);
        this.jPanelColorSample = new ImageJPanel();
        this.jPanelColorSample.setFont(new Font("Dialog", 0, 12));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        ((GridBagLayout)this.jPanelColorScale.getLayout()).setConstraints(this.jPanelColorSample, gbc);
        this.jPanelColorScale.add(this.jPanelColorSample);
        this.jLabelSampleMin = new JLabel();
        this.jLabelSampleMin.setText("0000");
        this.jLabelSampleMin.setHorizontalAlignment(4);
        this.jLabelSampleMin.setFont(new Font("Dialog", 1, 12));
        this.jLabelSampleMin.setForeground(new Color(-10066279));
        this.jLabelSampleMin.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        ((GridBagLayout)this.jPanelColorScale.getLayout()).setConstraints(this.jLabelSampleMin, gbc);
        this.jPanelColorScale.add(this.jLabelSampleMin);
        this.jPanelButtons = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanelButtons.setLayout(gridBagLayout);
        this.jPanelButtons.setBounds(2, 469, 295, 29);
        this.jPanelButtons.setFont(new Font("Dialog", 0, 12));
        this.jPanelButtons.setForeground(new Color(0));
        this.jPanelButtons.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.jPanelButtons, gbc);
        this.getContentPane().add(this.jPanelButtons);
        this.jButtonOk = new JButton();
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setActionCommand("Ok");
        this.jButtonOk.setBounds(8, 2, 70, 25);
        this.jButtonOk.setFont(new Font("Dialog", 1, 12));
        this.jButtonOk.setForeground(new Color(0));
        this.jButtonOk.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 8, 2, 8);
        ((GridBagLayout)this.jPanelButtons.getLayout()).setConstraints(this.jButtonOk, gbc);
        this.jPanelButtons.add(this.jButtonOk);
        this.jButtonApply = new JButton();
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setActionCommand("Apply");
        this.jButtonApply.setBounds(94, 2, 84, 25);
        this.jButtonApply.setFont(new Font("Dialog", 1, 12));
        this.jButtonApply.setForeground(new Color(0));
        this.jButtonApply.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 8, 2, 8);
        ((GridBagLayout)this.jPanelButtons.getLayout()).setConstraints(this.jButtonApply, gbc);
        this.jPanelButtons.add(this.jButtonApply);
        this.jButtonCancel = new JButton();
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setActionCommand("Cancel");
        this.jButtonCancel.setBounds(194, 2, 92, 25);
        this.jButtonCancel.setFont(new Font("Dialog", 1, 12));
        this.jButtonCancel.setForeground(new Color(0));
        this.jButtonCancel.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 8, 2, 8);
        ((GridBagLayout)this.jPanelButtons.getLayout()).setConstraints(this.jButtonCancel, gbc);
        this.jPanelButtons.add(this.jButtonCancel);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            DemGlyphDataRecord gData = (DemGlyphDataRecord)this._glyph.getDataRecord();
            this._data = (DemGlyphDataRecord)gData.clone();
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            this.paintScale();
            this.pack();
            super.setVisible(b);
            this.repaint(10L);
            this.paintScale();
        } else {
            super.setVisible(b);
        }
    }

    void DemGlyphOptionJDlg_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    void jButtonOk_actionPerformed(ActionEvent event) {
        this.jButtonApply_actionPerformed(event);
        this.setVisible(false);
    }

    void jButtonApply_actionPerformed(ActionEvent event) {
        this._glyph.setDataRecord(this._data);
        this.jTextFieldMin.setForeground(Color.black);
        this.jTextFieldMax.setForeground(Color.black);
        this.jTextFieldBright.setForeground(Color.black);
        this.jTextFieldSat.setForeground(Color.black);
        this.jTextFieldAspect.setForeground(Color.black);
        this.jTextFieldMinVal.setForeground(Color.black);
        this.jTextFieldMaxVal.setForeground(Color.black);
        this._mapPanel.paintMap();
        DemGlyphDataRecord gData = (DemGlyphDataRecord)this._glyph.getDataRecord();
        this._data = (DemGlyphDataRecord)gData.clone();
    }

    void jButtonCancel_actionPerformed(ActionEvent event) {
        this._data = null;
        this.setVisible(false);
    }

    void jButtonMinColor_actionPerformed(ActionEvent event) {
        Color oldColor = this._data.getMinClipping().getColor();
        Color newColor = RMAUtil.colorChooser(this, oldColor);
        this._data.getMinClipping().setColor(newColor);
        this._data.setModified(true);
        this.setMinClipping(this._data.getMinClipping());
        this.paintScale();
    }

    void jButtonMaxColor_actionPerformed(ActionEvent event) {
        Color oldColor = this._data.getMaxClipping().getColor();
        Color newColor = RMAUtil.colorChooser(this, oldColor);
        this._data.getMaxClipping().setColor(newColor);
        this._data.setModified(true);
        this.setMaxClipping(this._data.getMaxClipping());
        this.paintScale();
    }

    void jButtonAspectColor_actionPerformed(ActionEvent event) {
        Color oldColor = this.jButtonAspectColor.getColor();
        Color newColor = RMAUtil.colorChooser(this, oldColor);
        this.jButtonAspectColor.setColor(newColor);
        this.jButtonAspectColor.setIcon(this.getColorIcon(newColor));
        ColorContour cc = this._data.getColorContour();
        if (cc instanceof AspectShadingColorContour) {
            ((AspectShadingColorContour)cc).setColor(newColor);
            this._data.setModified(true);
            this.paintScale();
        }
    }

    void jCheckBoxMin_actionPerformed(ActionEvent event) {
        Clipping clip = this._data.getMinClipping();
        Object o = event.getSource();
        AbstractButton jCheckBox = (AbstractButton)o;
        clip.setEnabled(jCheckBox.isSelected());
        this._data.setModified(true);
        this.setMinClipping(clip);
        this.paintScale();
    }

    void jCheckBoxMax_actionPerformed(ActionEvent event) {
        Clipping clip = this._data.getMaxClipping();
        Object o = event.getSource();
        AbstractButton jCheckBox = (AbstractButton)o;
        clip.setEnabled(jCheckBox.isSelected());
        this._data.setModified(true);
        this.setMaxClipping(clip);
        this.paintScale();
    }

    void jRadioButtonRGB_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        if (jRadioButton.isSelected()) {
            RGBColorContour cc = new RGBColorContour();
            this._data.getColorContour().copyInto(cc);
            this._data.setColorContour(cc);
            this._data.setModified(true);
            this.setColorContour(this._data.getColorContour());
            this.paintScale();
        }
    }

    void jRadioButtonTerrain_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        if (jRadioButton.isSelected()) {
            TerrainColorContour cc = new TerrainColorContour();
            this._data.getColorContour().copyInto(cc);
            this._data.setColorContour(cc);
            this._data.setModified(true);
            this.setColorContour(this._data.getColorContour());
            this.paintScale();
        }
    }

    void jRadioButtonGrayscale_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        if (jRadioButton.isSelected()) {
            GrayscaleColorContour cc = new GrayscaleColorContour();
            this._data.getColorContour().copyInto(cc);
            this._data.setColorContour(cc);
            this._data.setModified(true);
            this.setColorContour(this._data.getColorContour());
            this.paintScale();
        }
    }

    void jRadioButtonAspectShading_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        if (jRadioButton.isSelected()) {
            this.jButtonAspectColor.setEnabled(true);
            AspectShadingColorContour cc = new AspectShadingColorContour();
            this._data.getColorContour().copyInto(cc);
            cc.setColor(this.jButtonAspectColor.getColor());
            this._data.setColorContour(cc);
            this._data.setModified(true);
            this.setColorContour(this._data.getColorContour());
            this.paintScale();
        } else {
            this.jButtonAspectColor.setEnabled(false);
        }
    }

    void jCheckBoxAuto_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        this._data.setAutoContour(jRadioButton.isSelected());
        this._data.setModified(true);
        ColorContour cc = this._data.getColorContour();
        if (jRadioButton.isSelected()) {
            cc.setMaxValue(this._glyph.getMaximumElevation());
            cc.setMinValue(this._glyph.getMinimumElevation());
        } else {
            double min;
            double max = this.validateText(this.jTextFieldMax, -1.7976931348623157E308, Double.MAX_VALUE);
            if (max != Double.NEGATIVE_INFINITY) {
                cc.setMaxValue(max);
            }
            if ((min = this.validateText(this.jTextFieldMin, -1.7976931348623157E308, Double.MAX_VALUE)) != Double.NEGATIVE_INFINITY) {
                cc.setMinValue(min);
            }
        }
        this.setAutoContour(this._data.getAutoContour());
        this.setMinClipping(cc.getMinClipping());
        this.setMaxClipping(cc.getMaxClipping());
        this.paintScale();
    }

    void jCheckBoxAspect_actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        AbstractButton jRadioButton = (AbstractButton)o;
        this._data.setAspectEnabled(jRadioButton.isSelected());
        this._data.setModified(true);
        this.setAspect(this._data.getAspectEnabled(), this._data.getAspectAngle());
    }

    void jSliderBright_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = (double)val / 100.0;
        if (!this.jTextFieldBright.hasFocus()) {
            this.jTextFieldBright.setText(RMAIO.toTable(dval));
        }
        this._data.setBrightness(dval);
        this._data.setModified(true);
        this.jTextFieldBright.setForeground(Color.red);
        this.paintScale();
    }

    void jSliderSat_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = (double)val / 100.0;
        if (!this.jTextFieldSat.hasFocus()) {
            this.jTextFieldSat.setText(RMAIO.toTable(dval));
        }
        this._data.setSaturation(dval);
        this._data.setModified(true);
        this.jTextFieldSat.setForeground(Color.red);
        this.paintScale();
    }

    void jSliderMinVal_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = val;
        if (!this.jTextFieldMinVal.hasFocus()) {
            this.jTextFieldMinVal.setText(RMAIO.toTable(dval));
        }
        this._data.getMinClipping().setValue(dval);
        this._data.setModified(true);
        this.jTextFieldMinVal.setForeground(Color.red);
        this.paintScale();
    }

    void jSliderMaxVal_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = val;
        if (!this.jTextFieldMaxVal.hasFocus()) {
            this.jTextFieldMaxVal.setText(RMAIO.toTable(dval));
        }
        this._data.getMaxClipping().setValue(dval);
        this._data.setModified(true);
        this.jTextFieldMaxVal.setForeground(Color.red);
        this.paintScale();
    }

    void jSliderAspect_stateChanged(ChangeEvent event) {
        JSlider jSlider = (JSlider)event.getSource();
        int val = jSlider.getValue();
        double dval = val;
        if (!this.jTextFieldAspect.hasFocus()) {
            this.jTextFieldAspect.setText(RMAIO.toTable(dval));
        }
        this._data.setAspectAngle(dval);
        this._data.setModified(true);
        this.jTextFieldAspect.setForeground(Color.red);
        this.paintScale();
    }

    protected double validateText(JTextField jTextField, double min, double max) {
        String text = jTextField.getText();
        double dval = RMAIO.parseDouble(text);
        if (dval == Double.NEGATIVE_INFINITY) {
            if (text.length() == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (text.length() == 1 && (text.equals("-") || text.equals("."))) {
                return Double.NEGATIVE_INFINITY;
            }
            if (text.length() == 2 && text.equals("-.")) {
                return Double.NEGATIVE_INFINITY;
            }
            String newText = text.substring(0, text.length() - 1);
            jTextField.setText(newText);
            return this.validateText(jTextField, min, max);
        }
        if (dval > max) {
            dval = max;
        } else if (dval < min) {
            dval = min;
        }
        return dval;
    }

    void jTextFieldMin_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, -1.7976931348623157E308, Double.MAX_VALUE);
        if (dval != Double.NEGATIVE_INFINITY) {
            ColorContour cc = this._data.getColorContour();
            cc.setMinValue(dval);
            this.setAutoContour(this.jCheckBoxAuto.isSelected());
            Clipping clip = cc.getMinClipping();
            clip.setValue(dval);
            this._data.setModified(true);
            this.setMinClipping(clip);
        }
        jTextField.setForeground(Color.red);
        this.paintScale();
    }

    void jTextFieldMax_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, -1.7976931348623157E308, Double.MAX_VALUE);
        if (dval != Double.NEGATIVE_INFINITY) {
            ColorContour cc = this._data.getColorContour();
            cc.setMaxValue(dval);
            this.setAutoContour(this.jCheckBoxAuto.isSelected());
            Clipping clip = cc.getMaxClipping();
            clip.setValue(dval);
            this._data.setModified(true);
            this.setMaxClipping(clip);
        }
        jTextField.setForeground(Color.red);
        this.paintScale();
    }

    void jTextFieldBright_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, 0.0, 1.0);
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setBrightness(dval);
            this._data.setModified(true);
            this.setBrightness(dval);
        }
        jTextField.setForeground(Color.red);
        this.paintScale();
    }

    void jTextFieldSat_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, 0.0, 1.0);
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setSaturation(dval);
            this._data.setModified(true);
            this.setSaturation(dval);
        }
        jTextField.setForeground(Color.red);
        this.paintScale();
    }

    void jTextFieldAspect_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, 0.0, 360.0);
        if (dval != Double.NEGATIVE_INFINITY) {
            this._data.setAspectAngle(dval);
            this._data.setModified(true);
            this.setAspect(this.jCheckBoxAspect.isSelected(), dval);
        }
        jTextField.setForeground(Color.red);
    }

    void jTextFieldMinVal_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, this._glyph.getMinimumElevation(), this._glyph.getMaximumElevation());
        if (dval != Double.NEGATIVE_INFINITY) {
            Clipping clip = this._data.getMinClipping();
            clip.setValue(dval);
            this._data.setModified(true);
            this.setMinClipping(clip);
        }
        jTextField.setForeground(Color.red);
        this.paintScale();
    }

    void jTextFieldMaxVal_keyReleased(KeyEvent event) {
        JTextField jTextField = (JTextField)event.getSource();
        double dval = this.validateText(jTextField, this._glyph.getMinimumElevation(), this._glyph.getMaximumElevation());
        if (dval != Double.NEGATIVE_INFINITY) {
            Clipping clip = this._data.getMaxClipping();
            clip.setValue(dval);
            this._data.setModified(true);
            this.setMaxClipping(clip);
        }
        jTextField.setForeground(Color.red);
        this.paintScale();
    }

    class ColorButton
    extends JButton {
        protected Color _color = Color.gray;

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color c2) {
            this._color = c2;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == DemGlyphOptionJDlg.this) {
                DemGlyphOptionJDlg.this.DemGlyphOptionJDlg_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == DemGlyphOptionJDlg.this.jButtonOk) {
                DemGlyphOptionJDlg.this.jButtonOk_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jButtonApply) {
                DemGlyphOptionJDlg.this.jButtonApply_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jButtonCancel) {
                DemGlyphOptionJDlg.this.jButtonCancel_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jButtonMinColor) {
                DemGlyphOptionJDlg.this.jButtonMinColor_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jButtonMaxColor) {
                DemGlyphOptionJDlg.this.jButtonMaxColor_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jButtonAspectColor) {
                DemGlyphOptionJDlg.this.jButtonAspectColor_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jCheckBoxMax) {
                DemGlyphOptionJDlg.this.jCheckBoxMax_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jRadioButtonRGB) {
                DemGlyphOptionJDlg.this.jRadioButtonRGB_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jRadioButtonTerrain) {
                DemGlyphOptionJDlg.this.jRadioButtonTerrain_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jRadioButtonGrayscale) {
                DemGlyphOptionJDlg.this.jRadioButtonGrayscale_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jRadioButtonAspectShading) {
                DemGlyphOptionJDlg.this.jRadioButtonAspectShading_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jCheckBoxAuto) {
                DemGlyphOptionJDlg.this.jCheckBoxAuto_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jCheckBoxAspect) {
                DemGlyphOptionJDlg.this.jCheckBoxAspect_actionPerformed(event);
            } else if (object == DemGlyphOptionJDlg.this.jCheckBoxMin) {
                DemGlyphOptionJDlg.this.jCheckBoxMin_actionPerformed(event);
            }
            DemGlyphOptionJDlg.this.repaint(10L);
        }
    }

    class SymChange
    implements ChangeListener {
        SymChange() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Object object = event.getSource();
            if (object == DemGlyphOptionJDlg.this.jSliderBright) {
                DemGlyphOptionJDlg.this.jSliderBright_stateChanged(event);
            } else if (object == DemGlyphOptionJDlg.this.jSliderSat) {
                DemGlyphOptionJDlg.this.jSliderSat_stateChanged(event);
            } else if (object == DemGlyphOptionJDlg.this.jSliderMinVal) {
                DemGlyphOptionJDlg.this.jSliderMinVal_stateChanged(event);
            } else if (object == DemGlyphOptionJDlg.this.jSliderMaxVal) {
                DemGlyphOptionJDlg.this.jSliderMaxVal_stateChanged(event);
            } else if (object == DemGlyphOptionJDlg.this.jSliderAspect) {
                DemGlyphOptionJDlg.this.jSliderAspect_stateChanged(event);
            }
            DemGlyphOptionJDlg.this.repaint(10L);
        }
    }

    class SymKey
    extends KeyAdapter {
        SymKey() {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            Object object = event.getSource();
            if (object == DemGlyphOptionJDlg.this.jTextFieldMin) {
                DemGlyphOptionJDlg.this.jTextFieldMin_keyReleased(event);
            } else if (object == DemGlyphOptionJDlg.this.jTextFieldMax) {
                DemGlyphOptionJDlg.this.jTextFieldMax_keyReleased(event);
            } else if (object == DemGlyphOptionJDlg.this.jTextFieldBright) {
                DemGlyphOptionJDlg.this.jTextFieldBright_keyReleased(event);
            } else if (object == DemGlyphOptionJDlg.this.jTextFieldSat) {
                DemGlyphOptionJDlg.this.jTextFieldSat_keyReleased(event);
            } else if (object == DemGlyphOptionJDlg.this.jTextFieldAspect) {
                DemGlyphOptionJDlg.this.jTextFieldAspect_keyReleased(event);
            } else if (object == DemGlyphOptionJDlg.this.jTextFieldMinVal) {
                DemGlyphOptionJDlg.this.jTextFieldMinVal_keyReleased(event);
            } else if (object == DemGlyphOptionJDlg.this.jTextFieldMaxVal) {
                DemGlyphOptionJDlg.this.jTextFieldMaxVal_keyReleased(event);
            }
            DemGlyphOptionJDlg.this.repaint(10L);
        }
    }

    class ImageJPanel
    extends JPanel {
        @Override
        public void paint(Graphics g) {
            if (g != null && DemGlyphOptionJDlg.this._img != null) {
                g.drawImage(DemGlyphOptionJDlg.this._img, 0, 0, DemGlyphOptionJDlg.this);
            }
        }
    }
}

