/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dem;

import hec.io.HecFile;
import hec.map.ElevationMap;
import hec.map.GridMap;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.dem.DemEnumerator;
import hec.map.dem.ElevationProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import rma.util.RMAIO;

public class DemMap
extends MapObject
implements Serializable,
MapObjectInterface,
ElevationMap,
GridMap {
    protected List[] _profiles;
    protected int _coordSys;
    protected int _coordUnits;
    protected int _unitSys;
    protected WorldPt _boundSW;
    protected WorldPt _boundNW;
    protected WorldPt _boundNE;
    protected WorldPt _boundSE;
    protected double _demMinEle;
    protected double _demMaxEle;
    protected double _demResX;
    protected double _demResY;
    protected double _demResZ;
    protected int _demProRow;
    protected int _demProCol;

    public DemMap(String fileName) {
        super(fileName);
        this.init();
    }

    public DemMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public DemMap() {
        this.init();
    }

    void init() {
        this._profiles = null;
        this._coordSys = Integer.MIN_VALUE;
        this._coordUnits = Integer.MIN_VALUE;
        this._unitSys = Integer.MIN_VALUE;
        this._boundSW = null;
        this._boundNW = null;
        this._boundNE = null;
        this._boundSE = null;
        this._demResX = Double.NEGATIVE_INFINITY;
        this._demResY = Double.NEGATIVE_INFINITY;
        this._demResZ = Double.NEGATIVE_INFINITY;
        this._demMinEle = -2.147483648E9;
        this._demMaxEle = -2.147483648E9;
        this._demProRow = Integer.MIN_VALUE;
        this._demProCol = Integer.MIN_VALUE;
        this._loaded = false;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            HecFile file = this._mapId.getFile();
            this.loadAscii(file);
            this._loaded = true;
        }
    }

    @Override
    public void unload() {
        this.init();
    }

    @Override
    public WorldRect getGridCellSize() {
        WorldRect r = new WorldRect();
        r.w = 0.0;
        r.s = 0.0;
        r.e = this._demResX;
        r.n = this._demResY;
        return r;
    }

    protected void loadAscii(HecFile file) {
        BufferedReader in = null;
        char[] chr1024 = new char[1024];
        try {
            double s;
            double e;
            double n;
            long t1 = new Date().getTime();
            in = file.getBufferedReader();
            CharIterator ci = new CharIterator(in, chr1024);
            ci.skip(156);
            this._coordSys = RMAIO.parseInt(String.valueOf(ci.read(6)));
            ci.skip(6);
            ci.skip(360);
            this._coordUnits = RMAIO.parseInt(String.valueOf(ci.read(6)));
            this._unitSys = RMAIO.parseInt(String.valueOf(ci.read(6)));
            ci.skip(6);
            double gcE = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            double gcN = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            this._boundSW = new WorldPt(gcE, gcN);
            gcE = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            gcN = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            this._boundNW = new WorldPt(gcE, gcN);
            gcE = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            gcN = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            this._boundNE = new WorldPt(gcE, gcN);
            gcE = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            gcN = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            this._boundSE = new WorldPt(gcE, gcN);
            this._demMinEle = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            this._demMaxEle = RMAIO.parseDouble(String.valueOf(ci.read(24)));
            ci.skip(24);
            ci.skip(6);
            this._demResX = RMAIO.parseDouble(String.valueOf(ci.read(12)));
            this._demResY = RMAIO.parseDouble(String.valueOf(ci.read(12)));
            this._demResZ = RMAIO.parseDouble(String.valueOf(ci.read(12)));
            this._demProRow = RMAIO.parseInt(String.valueOf(ci.read(6)));
            this._demProCol = RMAIO.parseInt(String.valueOf(ci.read(6)));
            double w = this.getBoundSW().e;
            if (this.getBoundNW().e < w) {
                w = this.getBoundNW().e;
            }
            if (this.getBoundNE().n > (n = this.getBoundNW().n)) {
                n = this.getBoundNE().n;
            }
            if (this.getBoundSE().e > (e = this.getBoundNE().e)) {
                e = this.getBoundSE().e;
            }
            if (this.getBoundSW().n < (s = this.getBoundSE().n)) {
                s = this.getBoundSW().n;
            }
            WorldRect rec = new WorldRect(w, n, e, s);
            this.setExtent(rec);
            this._profiles = new ArrayList[this._demProRow];
            block2: for (int kk = 0; kk < this._demProRow; ++kk) {
                this._profiles[kk] = new ArrayList();
                for (int ll = 0; ll < this._demProCol; ++ll) {
                    ci.refill();
                    if (ci.isFinished()) continue block2;
                    int proRow = RMAIO.parseInt(String.valueOf(ci.read(6)));
                    int proCol = RMAIO.parseInt(String.valueOf(ci.read(6)));
                    int eleProRows = RMAIO.parseInt(String.valueOf(ci.read(6)));
                    int eleProCols = RMAIO.parseInt(String.valueOf(ci.read(6)));
                    double gpX = RMAIO.parseDouble(String.valueOf(ci.read(24)));
                    double gpY = RMAIO.parseDouble(String.valueOf(ci.read(24)));
                    double datumEle = RMAIO.parseDouble(String.valueOf(ci.read(24)));
                    double minEle = RMAIO.parseDouble(String.valueOf(ci.read(24)));
                    double maxEle = RMAIO.parseDouble(String.valueOf(ci.read(24)));
                    ElevationProfile profile = new ElevationProfile(this, proRow, proCol, eleProRows, eleProCols, gpX, gpY, datumEle, minEle, maxEle);
                    int[][] ele = new int[eleProCols][eleProRows];
                    for (int ii = 0; ii < eleProRows; ++ii) {
                        for (int jj = 0; jj < eleProCols; ++jj) {
                            int num;
                            ele[jj][ii] = num = RMAIO.parseInt(String.valueOf(ci.read(6)));
                        }
                    }
                    profile.setElevations(ele);
                    this._profiles[kk].add(profile);
                }
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    @Override
    public boolean supportsNoDataValue() {
        return false;
    }

    @Override
    public double getNoDataValue() {
        return -3.4028234663852886E38;
    }

    public List[] getProfiles() {
        return this._profiles;
    }

    public int getCoordinateSystem() {
        return this._coordSys;
    }

    public int getCoordinateSystemUnits() {
        return this._coordUnits;
    }

    public int getUnitSystem() {
        return this._unitSys;
    }

    public WorldPt getBoundSW() {
        return this._boundSW;
    }

    public WorldPt getBoundNW() {
        return this._boundNW;
    }

    public WorldPt getBoundNE() {
        return this._boundNE;
    }

    public WorldPt getBoundSE() {
        return this._boundSE;
    }

    @Override
    public double getMinimumElevation() {
        return this._demMinEle;
    }

    @Override
    public double getMaximumElevation() {
        return this._demMaxEle;
    }

    public double getResolutionX() {
        return this._demResX;
    }

    public double getResolutionY() {
        return this._demResY;
    }

    public double getResolutionZ() {
        return this._demResZ;
    }

    public int getProfileRowCount() {
        return this._demProRow;
    }

    public int getProfileColumnCount() {
        return this._demProCol;
    }

    public int getAreaWidth() {
        WorldRect boundingBox = this.getExtent();
        int areaWidth = (int)(boundingBox.width() / this.getResolutionX());
        return areaWidth;
    }

    public int getAreaHeight() {
        WorldRect boundingBox = this.getExtent();
        int areaHeight = (int)(boundingBox.height() / this.getResolutionY());
        return areaHeight;
    }

    public DemEnumerator getEnumerator(int pSet, int layer) {
        return new DemEnumerator(this, pSet, layer);
    }

    @Override
    public float getElevation(WorldPt pt) {
        return (float)this.getElevation(0, 0, pt);
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        float[] elevations = new float[northing != null ? northing.length : 0];
        WorldPt wp = new WorldPt();
        for (int i = 0; i < elevations.length; ++i) {
            wp.e = easting[i];
            wp.n = northing[i];
            elevations[i] = this.getElevation(wp);
        }
        return elevations;
    }

    public double getElevation(int pSet, int layer, WorldPt pt) {
        double dval = Double.NEGATIVE_INFINITY;
        List profileSet = this._profiles[pSet];
        WorldRect bounds = this.getExtent();
        int dE = (int)((pt.e - bounds.w) / this.getResolutionX());
        if (dE >= 0 && dE < profileSet.size()) {
            ElevationProfile profile = (ElevationProfile)profileSet.get(dE);
            int dN = (int)((pt.n - bounds.s) / this.getResolutionY()) - profile.getRowOff();
            dval = profile.getElevation(layer, dN);
        }
        return dval;
    }

    public class CharIterator {
        int _off;
        int _len;
        char[] _array;
        BufferedReader _in;
        boolean _finished = false;

        public CharIterator(BufferedReader in, char[] chr) {
            this._in = in;
            this._array = chr;
            this._len = this._array.length;
            this.refill();
        }

        public char[] read(int len) {
            if (this._off + len >= this._len) {
                this.refill();
            }
            char[] chr = new char[len];
            System.arraycopy(this._array, this._off, chr, 0, len);
            this._off += len;
            return chr;
        }

        public void skip(int len) {
            if (this._off + len >= this._len) {
                this.refill();
            }
            this._off += len;
        }

        public void refill() {
            if (!this._finished) {
                try {
                    for (int ii = 0; ii < this._len; ++ii) {
                        int num = this._in.read();
                        if (num == -1) {
                            this._finished = true;
                        }
                        this._array[ii] = (char)num;
                        if (this._array[ii] != '\n' && this._array[ii] != '\r') continue;
                        num = this._in.read();
                        if (num == -1) {
                            this._finished = true;
                        }
                        this._array[ii + 1] = (char)num;
                        for (int jj = ii; jj < this._len; ++jj) {
                            this._array[jj] = 32;
                        }
                        break;
                    }
                    this._off = 0;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }

        public boolean isFinished() {
            return this._finished;
        }
    }
}

