/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dem;

import hec.map.WorldRect;
import hec.map.dem.DemMap;

public class ElevationProfile {
    protected int _proRow;
    protected int _proCol;
    protected double _gpX;
    protected double _gpY;
    protected double _datumEle;
    protected double _minEle;
    protected double _maxEle;
    protected int[][] _ele;
    protected int _eleProRows;
    protected int _eleProCols;
    protected DemMap _map = null;
    protected int _rowOff = Integer.MIN_VALUE;
    protected int _colOff = Integer.MIN_VALUE;
    protected double _mapResZ = Double.NEGATIVE_INFINITY;
    protected double _mapResY = Double.NEGATIVE_INFINITY;
    protected double _mapResX = Double.NEGATIVE_INFINITY;

    public ElevationProfile(DemMap map, int proRow, int proCol, int eleProRows, int eleProCols, double gpX, double gpY, double datumEle, double minEle, double maxEle) {
        this.setProfileRow(proRow);
        this.setProfileColumn(proCol);
        this.setElevationRows(eleProRows);
        this.setElevationColumns(eleProCols);
        this.setGpX(gpX);
        this.setGpY(gpY);
        this.setDatumElevation(datumEle);
        this.setMinimumElevation(minEle);
        this.setMaximumElevation(maxEle);
        this._map = map;
        this._mapResZ = this._map.getResolutionZ();
        this._mapResY = this._map.getResolutionY();
        this._mapResX = this._map.getResolutionX();
        WorldRect boundingBox = map.getExtent();
        this._rowOff = (int)((this._gpY - boundingBox.s) / this._map.getResolutionY());
        this._colOff = (int)((this._gpX - boundingBox.w) / this._map.getResolutionX());
    }

    public void setProfileRow(int num) {
        this._proRow = num;
    }

    public int getProfileRow() {
        return this._proRow;
    }

    public void setProfileColumn(int num) {
        this._proCol = num;
    }

    public int getProfileColumn() {
        return this._proCol;
    }

    public void setElevationRows(int num) {
        this._eleProRows = num;
    }

    public int getElevationRows() {
        return this._eleProRows;
    }

    public void setElevationColumns(int num) {
        this._eleProCols = num;
    }

    public int getElevationColumns() {
        return this._eleProCols;
    }

    public void setGpX(double num) {
        this._gpX = num;
    }

    public double getGpX() {
        return this._gpX;
    }

    public void setGpY(double num) {
        this._gpY = num;
    }

    public double getGpY() {
        return this._gpY;
    }

    public void setMinimumElevation(double num) {
        this._minEle = num;
    }

    public double getMinimumElevation() {
        return this._minEle;
    }

    public void setMaximumElevation(double num) {
        this._maxEle = num;
    }

    public double setMaximumElevation() {
        return this._maxEle;
    }

    public void setElevations(int[][] num) {
        this._ele = num;
    }

    public int[][] getElevations() {
        return this._ele;
    }

    public double getElevation(int layer, int row) {
        double dval = Double.NEGATIVE_INFINITY;
        if (layer >= 0 && layer < this._ele.length && row >= 0 && row < this._ele[layer].length) {
            int ival = this._ele[layer][row];
            dval = (double)ival * this._mapResZ + this._datumEle;
        }
        return dval;
    }

    public void setDatumElevation(double num) {
        this._datumEle = num;
    }

    public double getDatumElevation() {
        return this._datumEle;
    }

    public int getSize(int layer) {
        return this._ele[layer].length;
    }

    public int getRowOff() {
        return this._rowOff;
    }

    public int getColOff() {
        return this._colOff;
    }
}

