/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dlg;

import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.dlg.DlgArea;
import hec.map.dlg.DlgAttrib;
import hec.map.dlg.DlgGlyphDataRecord;
import hec.map.dlg.DlgILine;
import hec.map.dlg.DlgLine;
import hec.map.dlg.DlgMap;
import hec.map.dlg.DlgNode;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import rma.util.ColorContour;
import rma.util.RGBColorContour;

public class DlgGlyph
extends MapGlyph
implements Serializable {
    LocalPt lpt = new LocalPt();
    ColorContour _cc = null;
    transient DlgGlyphDataRecord _dataRec;
    int[] rgb = new int[3];

    public DlgGlyph() {
        this._cc = new RGBColorContour();
        this._cc.setMaxValue(1000.0);
        this._cc.setMinValue(450.0);
    }

    public DlgGlyph(MapPanel panel, DlgMap map) {
        super(panel, map);
        if (this._mapIdentifier.getGlyphDataRecord() == null) {
            this._mapIdentifier.setGlyphDataRecord(new DlgGlyphDataRecord());
        }
    }

    @Override
    protected void init() {
        if (this._mapIdentifier == null) {
            return;
        }
        if (this._mapIdentifier.getGlyphDataRecord() == null) {
            this._mapIdentifier.setGlyphDataRecord(new DlgGlyphDataRecord());
        }
    }

    @Override
    public void draw(Graphics g, MapScale scale) {
        DlgNode nd;
        WorldPt pt;
        DlgLine l;
        DlgAttrib att;
        int j;
        Color color;
        int i;
        DlgGlyphDataRecord dataRecord;
        if (this._map == null || this._mapPanel == null) {
            return;
        }
        DlgMap dlgmap = (DlgMap)this._map;
        this._dataRec = dataRecord = (DlgGlyphDataRecord)this.getDataRecord();
        Color defaultcolor = dataRecord.getDefaultColor();
        WorldRect rc = scale.getWorldRect();
        int[] locxarray = new int[dlgmap._ptVec.size()];
        int[] locyarray = new int[dlgmap._ptVec.size()];
        if (_paintOk && dataRecord.getDrawAreas()) {
            int size = dlgmap._areaVec.size();
            for (i = 0; _paintOk && i < size; ++i) {
                int z;
                int np;
                int iline;
                int k;
                DlgArea a = (DlgArea)dlgmap._areaVec.elementAt(i);
                if (a == null || a.numAttrib == 0) continue;
                color = null;
                for (j = 0; _paintOk && j < a.numAttrib && (color = this.dlgColor(att = (DlgAttrib)dlgmap._attribVec.elementAt(a.attrib0 + j), defaultcolor)) == null; ++j) {
                }
                if (color == null) continue;
                g.setColor(color);
                int nll = a.numLines;
                int icnt = 0;
                int icontain = 1;
                boolean lcontain = true;
                for (k = 0; _paintOk && k < nll && Math.abs(iline = ((DlgILine)dlgmap._ilineVec.elementAt((int)(a.line0 + k))).id) >= 1; ++k) {
                    l = (DlgLine)dlgmap._lineVec.elementAt(Math.abs(iline) - 1);
                    np = l.numPts;
                    pt = (WorldPt)dlgmap._ptVec.elementAt(l.pt0);
                    lcontain = true;
                    if (iline > 0) {
                        for (z = 0; z < l.numPts; ++z) {
                            pt = (WorldPt)dlgmap._ptVec.get(l.pt0 + z);
                            locxarray[icnt + z] = scale.e2x(pt.e);
                            locyarray[icnt + z] = scale.n2y(pt.n);
                        }
                        icnt += l.numPts;
                    } else {
                        for (z = 0; z < l.numPts; ++z) {
                            pt = (WorldPt)dlgmap._ptVec.get(l.pt0 + l.numPts - 1 - z);
                            locxarray[icnt + z] = scale.e2x(pt.e);
                            locyarray[icnt + z] = scale.n2y(pt.n);
                        }
                        icnt += l.numPts;
                    }
                    if (!lcontain) {
                        icnt -= np;
                    }
                    if (icnt >= 10000) break;
                }
                if (icontain > 0) {
                    g.fillPolygon(locxarray, locyarray, icnt);
                }
                if (!_paintOk || k >= nll) continue;
                g.setColor(Color.white);
                while (_paintOk && k < nll) {
                    ++k;
                    icnt = 0;
                    icontain = 1;
                    while (_paintOk && k < nll && Math.abs(iline = ((DlgILine)dlgmap._ilineVec.elementAt((int)(a.line0 + k))).id) >= 1) {
                        l = (DlgLine)dlgmap._lineVec.elementAt(Math.abs(iline) - 1);
                        np = l.numPts;
                        pt = (WorldPt)dlgmap._ptVec.elementAt(l.pt0);
                        lcontain = true;
                        if (iline > 0) {
                            for (z = 0; z < l.numPts; ++z) {
                                pt = (WorldPt)dlgmap._ptVec.get(l.pt0 + z);
                                locxarray[icnt + z] = scale.e2x(pt.e);
                                locyarray[icnt + z] = scale.n2y(pt.n);
                            }
                            icnt += l.numPts;
                        } else {
                            for (z = 0; z < l.numPts; ++z) {
                                pt = (WorldPt)dlgmap._ptVec.get(l.pt0 + l.numPts - 1 - z);
                                locxarray[icnt + z] = scale.e2x(pt.e);
                                locyarray[icnt + z] = scale.n2y(pt.n);
                            }
                            icnt += l.numPts;
                        }
                        if (!lcontain) {
                            icnt -= np;
                        }
                        if (icnt >= 10000) break;
                        ++k;
                    }
                    if (icontain <= 0) continue;
                    g.fillPolygon(locxarray, locyarray, icnt);
                }
            }
        }
        if (_paintOk && dataRecord.getDrawLines()) {
            int numLines = dlgmap._lineVec.size();
            for (i = 0; _paintOk && i < numLines; ++i) {
                l = (DlgLine)dlgmap._lineVec.elementAt(i);
                if (l == null || !rc.intersects(l.rc)) continue;
                int numberOfPoints = l.numPts + 2;
                color = null;
                for (j = 0; _paintOk && j < l.numAttrib && (color = this.dlgColor(att = (DlgAttrib)dlgmap._attribVec.elementAt(l.attrib0 + j), defaultcolor)) == null; ++j) {
                }
                if (color == null) {
                    color = defaultcolor;
                }
                g.setColor(color);
                nd = (DlgNode)dlgmap._nodeVec.elementAt(l.upNode);
                locxarray[0] = scale.e2x(nd.pt.e);
                locyarray[0] = scale.n2y(nd.pt.n);
                for (int z = 0; z < l.numPts; ++z) {
                    pt = (WorldPt)dlgmap._ptVec.get(l.pt0 + z);
                    locxarray[1 + z] = scale.e2x(pt.e);
                    locyarray[1 + z] = scale.n2y(pt.n);
                }
                nd = (DlgNode)dlgmap._nodeVec.elementAt(l.dwnNode);
                locxarray[l.numPts + 1] = scale.e2x(nd.pt.e);
                locyarray[l.numPts + 1] = scale.n2y(nd.pt.n);
                g.drawPolyline(locxarray, locyarray, numberOfPoints);
            }
        }
        if (_paintOk && dataRecord.getDrawNodes()) {
            g.setColor(Color.red);
            for (i = 0; _paintOk && i < dlgmap._numNodes; ++i) {
                nd = (DlgNode)dlgmap._nodeVec.elementAt(i);
                if (nd == null || !rc.contains(nd.pt)) continue;
                scale.wp2lp(nd.pt, this.lpt);
                g.fillRect(this.lpt.x - 2, this.lpt.y - 2, 4, 4);
            }
        }
    }

    Color dlgColor(DlgAttrib attrib, Color defaultcolor) {
        Color color = null;
        switch (attrib.major) {
            case 0: {
                break;
            }
            case 50: {
                switch (attrib.minor) {
                    case 100: {
                        color = new Color(128, 128, 0);
                        break;
                    }
                    case 101: {
                        color = new Color(196, 255, 255);
                        break;
                    }
                    case 102: {
                        color = new Color(0, 128, 128);
                        break;
                    }
                    case 103: {
                        color = new Color(255, 255, 255);
                        break;
                    }
                    case 104: 
                    case 118: {
                        color = new Color(255, 128, 0);
                        break;
                    }
                    case 106: {
                        color = new Color(255, 255, 0);
                        break;
                    }
                    case 107: {
                        color = new Color(128, 255, 196);
                        break;
                    }
                    case 109: {
                        color = new Color(196, 255, 128);
                        break;
                    }
                    case 110: {
                        color = new Color(128, 255, 0);
                        break;
                    }
                    case 111: 
                    case 112: 
                    case 114: {
                        color = new Color(0, 255, 0);
                        break;
                    }
                    case 113: {
                        color = new Color(0, 128, 0);
                        break;
                    }
                    case 115: 
                    case 117: {
                        color = new Color(128, 128, 64);
                        break;
                    }
                    case 116: {
                        color = new Color(128, 255, 255);
                        break;
                    }
                    case 119: {
                        color = new Color(128, 255, 128);
                        break;
                    }
                    case 200: 
                    case 201: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 207: {
                        color = new Color(64, 128, 255);
                        break;
                    }
                    case 412: {
                        color = Color.cyan;
                        break;
                    }
                    case 413: {
                        color = new Color(128, 192, 255);
                        break;
                    }
                    case 414: {
                        color = new Color(128, 255, 255);
                        break;
                    }
                    case 415: {
                        color = new Color(255, 255, 128);
                        break;
                    }
                    case 419: {
                        color = new Color(128, 255, 255);
                        break;
                    }
                    case 421: {
                        color = new Color(32, 255, 255);
                        break;
                    }
                    case 423: {
                        color = new Color(255, 196, 128);
                        break;
                    }
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 416: 
                    case 417: 
                    case 418: {
                        color = new Color(255, 0, 0);
                        break;
                    }
                    case 424: 
                    case 425: {
                        color = new Color(128, 0, 0);
                        break;
                    }
                    case 610: {
                        color = Color.cyan;
                        break;
                    }
                    default: {
                        color = defaultcolor;
                    }
                }
            }
            case 22: {
                color = this._cc.getColor(attrib.minor);
                break;
            }
            default: {
                color = defaultcolor;
            }
        }
        if (color == null || this._dataRec == null) {
            return color;
        }
        double _sat = this._dataRec.getSaturation();
        double _bright = this._dataRec.getBrightness();
        this.rgb[0] = color.getRed();
        this.rgb[1] = color.getGreen();
        this.rgb[2] = color.getBlue();
        double sat = 1.0 - _sat;
        double dr = (255.0 - (double)this.rgb[0]) * sat;
        double dg = (255.0 - (double)this.rgb[1]) * sat;
        double db = (255.0 - (double)this.rgb[2]) * sat;
        int ir = (int)(((double)this.rgb[0] + dr) * _bright);
        if (ir < 0) {
            ir = 0;
        } else if (ir > 255) {
            ir = 255;
        }
        int ig = (int)(((double)this.rgb[1] + dg) * _bright);
        if (ig < 0) {
            ig = 0;
        } else if (ig > 255) {
            ig = 255;
        }
        int ib = (int)(((double)this.rgb[2] + db) * _bright);
        if (ib < 0) {
            ib = 0;
        } else if (ib > 255) {
            ib = 255;
        }
        return new Color(ir, ig, ib);
    }
}

