/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dlg;

import hec.map.GlyphDataRecord;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import rma.swing.RmaColor;

public class DlgGlyphDataRecord
extends GlyphDataRecord {
    protected Color _defaultColor = Color.gray;
    protected boolean _drawNodes = false;
    protected boolean _drawLines = true;
    protected boolean _drawAreas = true;
    protected double _saturation = 1.0;
    protected double _brightness = 1.0;

    public double getSaturation() {
        return this._saturation;
    }

    public void setSaturation(double sat) {
        this._saturation = sat < 0.0 ? 0.0 : (sat > 1.0 ? 1.0 : sat);
    }

    public double getBrightness() {
        return this._brightness;
    }

    public void setBrightness(double bright) {
        this._brightness = bright < 0.0 ? 0.0 : (bright > 1.0 ? 1.0 : bright);
    }

    public Color getDefaultColor() {
        return this._defaultColor;
    }

    public void setDefaultColor(Color color) {
        this._defaultColor = color;
        this.notifyObservers();
    }

    public boolean getDrawNodes() {
        return this._drawNodes;
    }

    public void setDrawNodes(boolean tf) {
        this._drawNodes = tf;
        this.notifyObservers();
    }

    public boolean getDrawLines() {
        return this._drawLines;
    }

    public void setDrawLines(boolean tf) {
        this._drawLines = tf;
        this.notifyObservers();
    }

    public boolean getDrawAreas() {
        return this._drawAreas;
    }

    public void setDrawAreas(boolean tf) {
        this._drawAreas = tf;
        this.notifyObservers();
    }

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        if (type.compareTo("DefaultColor") == 0) {
            Color color;
            block9: {
                color = null;
                try {
                    int rgb = Integer.parseInt(param);
                    color = new Color(rgb);
                }
                catch (Exception e) {
                    color = RmaColor.parseColorString(param);
                    if (color != null) break block9;
                    color = Color.gray;
                }
            }
            this.setDefaultColor(color);
        } else if (type.compareTo("DrawNodes") == 0) {
            this.setDrawNodes(Boolean.valueOf(param));
        } else if (type.compareTo("DrawLines") == 0) {
            this.setDrawLines(Boolean.valueOf(param));
        } else if (type.compareTo("DrawAreas") == 0) {
            this.setDrawAreas(Boolean.valueOf(param));
        }
    }

    @Override
    protected void write0(BufferedWriter output) throws IOException {
        output.write("DefaultColor=" + this.getDefaultColor().getRGB());
        output.newLine();
        output.write("DrawNodes=" + this.getDrawNodes());
        output.newLine();
        output.write("DrawLines=" + this.getDrawLines());
        output.newLine();
        output.write("DrawAreas=" + this.getDrawAreas());
        output.newLine();
    }
}

