/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dlg;

import hec.map.JLayerSelection;
import hec.map.MapPanel;
import hec.map.MapScaleEditorPanel;
import hec.map.dlg.DlgGlyph;
import hec.map.dlg.DlgGlyphDataRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.util.RMAUtil;

public class DlgGlyphOptionDlg
extends JDialog {
    MapPanel _mapPanel;
    DlgGlyph _glyph;
    DlgGlyphDataRecord _data;
    JLayerSelection _layerSel;
    Frame _parent;
    JLabel labelName;
    JLabel label1;
    JButton buttonColor;
    JCheckBox checkboxNodes;
    JCheckBox checkboxLines;
    JCheckBox checkboxAreas;
    RmaJLabel satLabel;
    RmaJDecimalField satText;
    RmaJLabel brightLabel;
    RmaJDecimalField brightText;
    MapScaleEditorPanel m_mapScalePanel = new MapScaleEditorPanel();

    public DlgGlyphOptionDlg(Frame parent, boolean modal, MapPanel panel, DlgGlyph glyph, DlgGlyphDataRecord datarec, JLayerSelection jls) {
        this(parent, modal);
        this._layerSel = jls;
        this._mapPanel = panel;
        this._glyph = glyph;
        this._parent = parent;
        this.setDataRecord(datarec);
        this.m_mapScalePanel.setMapPanel(this._mapPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setDataRecord(DlgGlyphDataRecord datarec) {
        this._data = datarec;
        this.labelName.setText(this._glyph.getName());
        this.setColor(this._data.getDefaultColor());
        this.checkboxNodes.setSelected(this._data.getDrawNodes());
        this.checkboxLines.setSelected(this._data.getDrawLines());
        this.checkboxAreas.setSelected(this._data.getDrawAreas());
        this.satText.setValue(this._data.getSaturation());
        this.brightText.setValue(this._data.getBrightness());
        this.m_mapScalePanel.setScale(this._glyph.getMinimumScale(), this._glyph.getMaximumScale());
    }

    public DlgGlyphOptionDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("USGS Digital Line Graph Editor");
        this.setVisible(false);
        this.setFont(new Font("Dialog", 0, 11));
        this.setBackground(Color.lightGray);
        this.labelName = new JLabel("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.labelName, gbc);
        this.getContentPane().add(this.labelName);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        tabbedPane.add("Properties", propertiesPanel);
        tabbedPane.add("Scale", this.m_mapScalePanel);
        this.getContentPane().add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.label1 = new JLabel("Default Color:");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.label1, gbc);
        propertiesPanel.add(this.label1);
        this.buttonColor = new JButton();
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.buttonColor, gbc);
        propertiesPanel.add(this.buttonColor);
        this.checkboxNodes = new JCheckBox("Draw Nodes");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.checkboxNodes, gbc);
        propertiesPanel.add(this.checkboxNodes);
        this.checkboxLines = new JCheckBox("Draw Lines");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.checkboxLines, gbc);
        propertiesPanel.add(this.checkboxLines);
        this.checkboxAreas = new JCheckBox("Draw Areas");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.checkboxAreas, gbc);
        propertiesPanel.add(this.checkboxAreas);
        this.satLabel = new RmaJLabel("Saturation (0-1):");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.satLabel, gbc);
        propertiesPanel.add(this.satLabel);
        this.satText = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.ipadx = 75;
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.satText, gbc);
        propertiesPanel.add(this.satText);
        this.brightLabel = new RmaJLabel("Brightness (0-1):");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.brightLabel, gbc);
        propertiesPanel.add(this.brightLabel);
        this.brightText = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.ipadx = 75;
        ((GridBagLayout)propertiesPanel.getLayout()).setConstraints(this.brightText, gbc);
        propertiesPanel.add(this.brightText);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)cmdPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 14, 2, new Insets(5, 5, 5, 5), 0, 0));
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        DlgGlyphOptionDlg.this.buttonOK_Action(e);
                        break;
                    }
                    case 2: {
                        DlgGlyphOptionDlg.this.buttonApply_Action(e);
                        break;
                    }
                    case 4: {
                        DlgGlyphOptionDlg.this.buttonCancel_Action(e);
                    }
                }
            }
        });
        this.buttonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgGlyphOptionDlg.this.buttonColor_Action(e);
            }
        });
    }

    public Color getColor() {
        return this.buttonColor.getBackground();
    }

    public void setColor(Color color) {
        this.buttonColor.setBackground(color);
    }

    void buttonColor_Action(ActionEvent event) {
        Color newColor = RMAUtil.colorChooser(this, this.getColor());
        this.setColor(newColor);
    }

    void buttonCancel_Action(ActionEvent event) {
        this.setVisible(false);
    }

    void buttonOK_Action(ActionEvent event) {
        this.applyChanges();
        this.setVisible(false);
    }

    void buttonApply_Action(ActionEvent event) {
        this.applyChanges();
    }

    void applyChanges() {
        this._data.setDefaultColor(this.getColor());
        this._data.setDrawNodes(this.checkboxNodes.isSelected());
        this._data.setDrawLines(this.checkboxLines.isSelected());
        this._data.setDrawAreas(this.checkboxAreas.isSelected());
        this._data.setSaturation(this.satText.getValue());
        this._data.setBrightness(this.brightText.getValue());
        this._layerSel.setDataRecord(this._data);
        this._data.setModified(true);
        this._data.notifyObservers(this._layerSel);
        this._glyph.setMinimumScale(this.m_mapScalePanel.getMinimumScale());
        this._glyph.setMaximumScale(this.m_mapScalePanel.getMaximumScale());
    }
}

