/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dlg;

import hec.map.JLayerSelection;
import hec.map.JLayerSelectionParent;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.dlg.DlgGlyph;
import hec.map.dlg.DlgGlyphDataRecord;
import hec.map.dlg.DlgGlyphOptionDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DlgLayerSelection
extends JLayerSelection {
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    DlgGlyphOptionDlg _dialog = null;
    JLabel _layerSquare = new JLabel();
    protected Color _color = null;

    public DlgLayerSelection(JLayerSelectionParent parent, JFrame parentFrame, MapPanel mapPanel, MapGlyph glyph) {
        super(parent, parentFrame, mapPanel, glyph);
        this._layerSquare.setBounds(35, 35, 16, 16);
        this._extraPanel.add((Component)this._layerSquare, "West");
        this._layerSquare.addMouseListener(this._aSymMouse);
        this.addOptionsPopupMenu();
        this.refresh();
    }

    @Override
    protected boolean allowScaleAdjustment() {
        return true;
    }

    public void setLayerColor(Color color) {
        this._color = color;
        if (this._layerSquare == null) {
            return;
        }
        ImageIcon icon = new ImageIcon();
        Image image = icon.getImage();
        if (image == null) {
            image = new BufferedImage(16, 16, 1);
            icon.setImage(image);
        }
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 16, 16);
        g.setColor(Color.black);
        g.drawRect(0, 0, 15, 15);
        this._layerSquare.setIcon(icon);
    }

    public Color getLayerColor() {
        return this._color;
    }

    @Override
    public boolean hasOptionDialog() {
        return true;
    }

    @Override
    public void showOptionDialog() {
        Object dialog = null;
        if (!(this._glyph instanceof DlgGlyph)) {
            return;
        }
        if (this._dialog == null) {
            this._dialog = new DlgGlyphOptionDlg(this._parentFrame, false, this._mapPanel, (DlgGlyph)this._glyph, (DlgGlyphDataRecord)this._copyOfData, this);
        } else {
            this._dialog.setDataRecord((DlgGlyphDataRecord)this._copyOfData);
        }
        this._dialog.setVisible(true);
        this.refresh();
    }

    @Override
    public void closeOptionDialog() {
        if (this._dialog != null) {
            this._dialog.setVisible(false);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this._copyOfData == null) {
            return;
        }
        Color color = ((DlgGlyphDataRecord)this._copyOfData).getDefaultColor();
        this.setLayerColor(color);
    }
}

