/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dlg;

import hec.appInterface.AppDaddy;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.dlg.DlgArea;
import hec.map.dlg.DlgAttrib;
import hec.map.dlg.DlgILine;
import hec.map.dlg.DlgLine;
import hec.map.dlg.DlgNode;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import rma.util.RMAIO;

public class DlgMap
extends MapObject
implements Serializable,
MapObjectInterface {
    boolean _isUTM;
    String _title;
    WorldPt _swUTM;
    WorldPt _seUTM;
    WorldPt _nwUTM;
    WorldPt _neUTM;
    WorldPt _sw;
    WorldPt _se;
    WorldPt _nw;
    WorldPt _ne;
    int _numNodes;
    int _numAreas;
    int _numLines;
    int _numPts;
    int _numAttrib;
    int _numILines;
    Vector _nodeVec;
    Vector _areaVec;
    Vector _lineVec;
    Vector _ptVec;
    Vector _attribVec;
    Vector _ilineVec;
    private double _a1;
    private double _a2;
    private double _a3;
    private double _a4;
    private WorldRect _rc;

    public DlgMap(String fileName) {
        super(fileName);
        this.init();
    }

    public DlgMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public DlgMap() {
        this.init();
    }

    void init() {
        this._swUTM = new WorldPt();
        this._seUTM = new WorldPt();
        this._nwUTM = new WorldPt();
        this._neUTM = new WorldPt();
        this._sw = new WorldPt();
        this._se = new WorldPt();
        this._nw = new WorldPt();
        this._ne = new WorldPt();
        this._nodeVec = new Vector();
        this._areaVec = new Vector();
        this._lineVec = new Vector();
        this._ptVec = new Vector();
        this._attribVec = new Vector();
        this._ilineVec = new Vector();
        this._rc = new WorldRect();
    }

    public Vector getElements() {
        Vector<DlgMap> elements = new Vector<DlgMap>();
        elements.addElement(this);
        return elements;
    }

    @Override
    public String toString() {
        return "Dlg map " + this.getName();
    }

    @Override
    public WorldRect getExtent() {
        return new WorldRect(this._rc.w, this._rc.n, this._rc.e, this._rc.s);
    }

    public double parseDouble(String s) {
        double val;
        String tmp = s;
        if (tmp.length() == 0) {
            return 0.0;
        }
        int idx = tmp.indexOf(68);
        if (idx >= 0) {
            tmp = tmp.replace('D', 'E');
        }
        if ((idx = tmp.indexOf(100)) >= 0) {
            tmp = tmp.replace('d', 'E');
        }
        try {
            val = Double.valueOf(tmp);
        }
        catch (Exception e) {
            val = 0.0;
            System.out.println(e);
        }
        return val;
    }

    public int parseInt(String s) {
        int val;
        String tmp = s.trim();
        if (tmp.length() == 0) {
            return 0;
        }
        try {
            val = Integer.valueOf(tmp);
        }
        catch (Exception e) {
            val = 0;
            System.out.println(e);
        }
        return val;
    }

    public short parseShort(String s) {
        short val;
        String tmp = s.trim();
        if (tmp.length() == 0) {
            return 0;
        }
        try {
            val = Integer.valueOf(tmp).shortValue();
        }
        catch (Exception e) {
            val = 0;
            System.out.println(e);
        }
        return val;
    }

    @Override
    public void unload() {
        this._swUTM = new WorldPt();
        this._seUTM = new WorldPt();
        this._nwUTM = new WorldPt();
        this._neUTM = new WorldPt();
        this._sw = new WorldPt();
        this._se = new WorldPt();
        this._nw = new WorldPt();
        this._ne = new WorldPt();
        this._nodeVec.removeAllElements();
        this._areaVec.removeAllElements();
        this._lineVec.removeAllElements();
        this._ptVec.removeAllElements();
        this._attribVec.removeAllElements();
        this._ilineVec.removeAllElements();
        this._rc = new WorldRect();
        this._loaded = false;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            String ext;
            HecFile file = this._mapId.getFile();
            boolean binary = false;
            String name = file.getName();
            int idx = name.lastIndexOf(".");
            if (idx > -1 && (ext = name.substring(idx + 1)).lastIndexOf("bin") > -1) {
                binary = true;
            }
            if (binary) {
                this.loadBin(file);
            } else {
                String pathname = this._mapId.getPath() + "bin";
                Identifier pathId = new Identifier(pathname);
                pathId.setName(RMAIO.getFileFromPath(pathname));
                Identifier idOut = AppDaddy.getWorkspace().createFile(pathId);
                if (idOut == null) {
                    idOut = AppDaddy.getWorkspace().openFile(pathId, true);
                    if (idOut != null) {
                        this.loadBin(idOut.getFile());
                    }
                } else {
                    this.loadAsciiWriteBin(file, idOut.getFile());
                }
                this.getMapIdentifier().setIdentifier(pathId);
                this.getMapIdentifier().setFile(idOut.getFile());
            }
            this._loaded = true;
        }
    }

    public void loadBin(HecFile file) throws IOException {
        DataInputStream in = null;
        int[] major = new int[6];
        int[] minor = new int[6];
        double[] ee = new double[3];
        double[] nn = new double[3];
        try {
            int k;
            int imax;
            int j;
            double n;
            double e;
            String type;
            int i;
            long t1 = new Date().getTime();
            in = file.getDataInputStream();
            int length = in.readInt();
            byte[] firstTitleLine = new byte[length];
            in.read(firstTitleLine);
            length = in.readInt();
            byte[] secondTitleLine = new byte[length];
            in.read(secondTitleLine);
            this._title = new String(secondTitleLine);
            this._a1 = in.readDouble();
            this._a2 = in.readDouble();
            this._a3 = in.readDouble();
            this._a4 = in.readDouble();
            this._sw.n = in.readDouble();
            this._sw.e = in.readDouble();
            this._swUTM.e = in.readDouble();
            this._swUTM.n = in.readDouble();
            if (this._sw.n == 0.0) {
                this._sw.n = Double.NEGATIVE_INFINITY;
            }
            if (this._sw.e == 0.0) {
                this._sw.e = Double.NEGATIVE_INFINITY;
            }
            if (this._swUTM.e == 0.0) {
                this._swUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._swUTM.n == 0.0) {
                this._swUTM.n = Double.NEGATIVE_INFINITY;
            }
            this._nw.n = in.readDouble();
            this._nw.e = in.readDouble();
            this._nwUTM.e = in.readDouble();
            this._nwUTM.n = in.readDouble();
            if (this._nw.n == 0.0) {
                this._nw.n = Double.NEGATIVE_INFINITY;
            }
            if (this._nw.e == 0.0) {
                this._nw.e = Double.NEGATIVE_INFINITY;
            }
            if (this._nwUTM.e == 0.0) {
                this._nwUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._nwUTM.n == 0.0) {
                this._nwUTM.n = Double.NEGATIVE_INFINITY;
            }
            this._ne.n = in.readDouble();
            this._ne.e = in.readDouble();
            this._neUTM.e = in.readDouble();
            this._neUTM.n = in.readDouble();
            if (this._ne.n == 0.0) {
                this._ne.n = Double.NEGATIVE_INFINITY;
            }
            if (this._ne.e == 0.0) {
                this._ne.e = Double.NEGATIVE_INFINITY;
            }
            if (this._neUTM.e == 0.0) {
                this._neUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._neUTM.n == 0.0) {
                this._neUTM.n = Double.NEGATIVE_INFINITY;
            }
            this._se.n = in.readDouble();
            this._se.e = in.readDouble();
            this._seUTM.e = in.readDouble();
            this._seUTM.n = in.readDouble();
            if (this._se.n == 0.0) {
                this._se.n = Double.NEGATIVE_INFINITY;
            }
            if (this._se.e == 0.0) {
                this._se.e = Double.NEGATIVE_INFINITY;
            }
            if (this._seUTM.e == 0.0) {
                this._seUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._seUTM.n == 0.0) {
                this._seUTM.n = Double.NEGATIVE_INFINITY;
            }
            int nnodes = in.readInt();
            int nareas = in.readInt();
            int nlines = in.readInt();
            this._nodeVec.setSize(nnodes);
            this._areaVec.setSize(nareas);
            this._lineVec.setSize(nlines);
            this._ptVec.setSize(nlines * 50);
            this._attribVec.setSize((nnodes + nareas + nlines) * 2);
            this._ilineVec.setSize((nnodes + nareas) * 10);
            this._numPts = 0;
            this._numAttrib = 0;
            this._numILines = 0;
            long t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg BINARY Load - read header took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._numNodes = 0;
            byte[] typeByte = new byte[1];
            int icnt = 0;
            int[] tmpInt = new int[12];
            for (i = 0; i < nnodes; ++i) {
                int jj;
                DlgNode nd = new DlgNode();
                this._nodeVec.setElementAt(nd, i);
                in.read(typeByte);
                type = new String(typeByte);
                e = in.readDouble();
                n = in.readDouble();
                nd.numLines = in.readInt();
                nd.numAttrib = in.readInt();
                nd.pt.e = this._a1 * e + this._a2 * n + this._a3;
                nd.pt.n = this._a1 * n - this._a2 * e + this._a4;
                nd.line0 = this._numILines;
                for (j = 0; j < (nd.numLines + 11) / 12; ++j) {
                    imax = in.readInt();
                    for (jj = 0; jj < imax; ++jj) {
                        tmpInt[jj] = in.readInt();
                    }
                    k = 0;
                    if (this._ilineVec.size() <= this._numILines + nd.numLines) {
                        this._ilineVec.setSize(this._numILines + nd.numLines + 50);
                    }
                    while (icnt < nd.numLines && k < 12) {
                        this._ilineVec.setElementAt(new DlgILine(tmpInt[k]), this._numILines);
                        ++this._numILines;
                        ++icnt;
                        ++k;
                    }
                }
                nd.attrib0 = this._numAttrib;
                icnt = 0;
                for (j = 0; j < (nd.numAttrib + 5) / 6; ++j) {
                    imax = in.readInt();
                    for (jj = 0; jj < imax; ++jj) {
                        major[jj] = in.readInt();
                        minor[jj] = in.readInt();
                    }
                    k = 0;
                    if (this._attribVec.size() <= this._numAttrib + nd.numAttrib) {
                        this._attribVec.setSize(this._numAttrib + nd.numAttrib + 50);
                    }
                    while (icnt < nd.numAttrib && k < 6) {
                        this._attribVec.setElementAt(new DlgAttrib(major[k], minor[k]), this._numAttrib);
                        ++this._numAttrib;
                        ++icnt;
                        ++k;
                    }
                }
                ++this._numNodes;
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg Binary Load - read nodes took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._numAreas = 0;
            for (i = 0; i < nareas; ++i) {
                int jj;
                DlgArea a = new DlgArea();
                this._areaVec.setElementAt(a, i);
                in.read(typeByte);
                type = new String(typeByte);
                e = in.readDouble();
                n = in.readDouble();
                a.numLines = in.readInt();
                a.numAttrib = in.readInt();
                a.pt.e = this._a1 * e + this._a2 * n + this._a3;
                a.pt.n = this._a1 * n - this._a2 * e + this._a4;
                a.line0 = this._numILines;
                icnt = 0;
                for (j = 0; j < (a.numLines + 11) / 12; ++j) {
                    imax = in.readInt();
                    for (jj = 0; jj < imax; ++jj) {
                        tmpInt[jj] = in.readInt();
                    }
                    for (k = 0; icnt < a.numLines && k < 12; ++icnt, ++k) {
                        this._ilineVec.setElementAt(new DlgILine(tmpInt[k]), this._numILines);
                        ++this._numILines;
                    }
                }
                a.attrib0 = this._numAttrib;
                icnt = 0;
                for (j = 0; j < (a.numAttrib + 5) / 6; ++j) {
                    imax = in.readInt();
                    for (jj = 0; jj < imax; ++jj) {
                        major[jj] = in.readInt();
                        minor[jj] = in.readInt();
                    }
                    k = 0;
                    if (this._attribVec.size() <= this._numAttrib + a.numAttrib) {
                        this._attribVec.setSize(this._numAttrib + a.numAttrib + 50);
                    }
                    while (icnt < a.numAttrib && k < 6) {
                        this._attribVec.setElementAt(new DlgAttrib(major[k], minor[k]), this._numAttrib);
                        ++this._numAttrib;
                        ++icnt;
                        ++k;
                    }
                }
                ++this._numAreas;
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg Binary Load - read areas took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._numLines = 0;
            for (i = 0; i < nlines; ++i) {
                DlgLine l = new DlgLine();
                this._lineVec.setElementAt(l, i);
                in.read(typeByte);
                type = new String(typeByte);
                l.upNode = in.readInt();
                l.dwnNode = in.readInt();
                l.leftArea = in.readInt();
                l.rightArea = in.readInt();
                l.numPts = in.readInt();
                l.numAttrib = in.readInt();
                l.pt0 = this._numPts;
                icnt = 0;
                for (j = 0; j < (l.numPts + 2) / 3; ++j) {
                    imax = in.readInt();
                    for (k = 0; k < imax; ++k) {
                        ee[k] = in.readDouble();
                        nn[k] = in.readDouble();
                    }
                    k = 0;
                    if (this._ptVec.size() <= this._numPts + l.numPts) {
                        this._ptVec.setSize(this._numPts + l.numPts + 50);
                    }
                    while (icnt < l.numPts && k < 3) {
                        WorldPt pt = new WorldPt();
                        pt.e = this._a1 * ee[k] + this._a2 * nn[k] + this._a3;
                        pt.n = this._a1 * nn[k] - this._a2 * ee[k] + this._a4;
                        this._ptVec.setElementAt(pt, this._numPts);
                        ++this._numPts;
                        ++icnt;
                        ++k;
                    }
                }
                l.attrib0 = this._numAttrib;
                icnt = 0;
                for (j = 0; j < (l.numAttrib + 5) / 6; ++j) {
                    imax = in.readInt();
                    for (k = 0; k < imax; ++k) {
                        major[k] = in.readInt();
                        minor[k] = in.readInt();
                    }
                    k = 0;
                    if (this._attribVec.size() <= this._numAttrib + l.numAttrib) {
                        this._attribVec.setSize(this._numAttrib + l.numAttrib + 50);
                    }
                    while (icnt < l.numAttrib && k < 6) {
                        this._attribVec.setElementAt(new DlgAttrib(major[k], minor[k]), this._numAttrib);
                        ++this._numAttrib;
                        ++icnt;
                        ++k;
                    }
                }
                ++this._numLines;
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg Binary Load - read lines took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._ptVec.trimToSize();
            this._ilineVec.trimToSize();
            this._attribVec.trimToSize();
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg Binary Load - trimed vectors took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._isUTM = true;
            for (i = 0; i < this._numLines; ++i) {
                int np = ((DlgLine)this._lineVec.elementAt((int)i)).numPts;
                int ip0 = ((DlgLine)this._lineVec.elementAt((int)i)).pt0;
                ((DlgLine)this._lineVec.elementAt((int)i)).rc.initToPoint((WorldPt)this._ptVec.elementAt(ip0));
                for (j = ip0; j < np + ip0; ++j) {
                    ((DlgLine)this._lineVec.elementAt((int)i)).rc.growToPoint((WorldPt)this._ptVec.elementAt(j));
                }
                if (i == 0) {
                    this._rc.copy(((DlgLine)this._lineVec.elementAt((int)i)).rc);
                    continue;
                }
                this._rc.growToRect(((DlgLine)this._lineVec.elementAt((int)i)).rc);
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg Binary Load - build bounding boxes took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this.setExtent(new WorldRect(this._rc.w, this._rc.n, this._rc.e, this._rc.s));
            in.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void loadAsciiWriteBin(HecFile inFile, HecFile outFile) throws IOException {
        BufferedReader in = null;
        int[] major = new int[6];
        int[] minor = new int[6];
        double[] ee = new double[3];
        double[] nn = new double[3];
        try {
            int k;
            int imax;
            int j;
            double n;
            double e;
            String type;
            int i;
            long t1 = new Date().getTime();
            DataOutputStream out = outFile.getDataOutputStream();
            in = inFile.getBufferedReader();
            String line = in.readLine();
            byte[] byteArray = line.getBytes();
            int length = byteArray.length;
            if (length > 80) {
                length = 80;
            }
            out.writeInt(length);
            out.write(byteArray, 0, length);
            this._title = line = in.readLine();
            byteArray = line.getBytes();
            length = byteArray.length;
            if (length > 80) {
                length = 80;
            }
            out.writeInt(length);
            out.write(byteArray, 0, length);
            for (i = 0; i < 7; ++i) {
                line = in.readLine();
            }
            line = in.readLine();
            this._a1 = this.parseDouble(line.substring(0, 18));
            this._a2 = this.parseDouble(line.substring(18, 36));
            this._a3 = this.parseDouble(line.substring(36, 54));
            this._a4 = this.parseDouble(line.substring(54, 72));
            out.writeDouble(this._a1);
            out.writeDouble(this._a2);
            out.writeDouble(this._a3);
            out.writeDouble(this._a4);
            line = in.readLine();
            this._sw.n = this.parseDouble(line.substring(6, 18));
            this._sw.e = this.parseDouble(line.substring(18, 30));
            this._swUTM.e = this.parseDouble(line.substring(36, 48));
            this._swUTM.n = this.parseDouble(line.substring(48, 60));
            out.writeDouble(this._sw.e);
            out.writeDouble(this._sw.n);
            out.writeDouble(this._swUTM.e);
            out.writeDouble(this._swUTM.n);
            if (this._sw.n == 0.0) {
                this._sw.n = Double.NEGATIVE_INFINITY;
            }
            if (this._sw.e == 0.0) {
                this._sw.e = Double.NEGATIVE_INFINITY;
            }
            if (this._swUTM.e == 0.0) {
                this._swUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._swUTM.n == 0.0) {
                this._swUTM.n = Double.NEGATIVE_INFINITY;
            }
            line = in.readLine();
            this._nw.n = this.parseDouble(line.substring(6, 18));
            this._nw.e = this.parseDouble(line.substring(18, 30));
            this._nwUTM.e = this.parseDouble(line.substring(36, 48));
            this._nwUTM.n = this.parseDouble(line.substring(48, 60));
            out.writeDouble(this._nw.n);
            out.writeDouble(this._nw.e);
            out.writeDouble(this._nwUTM.e);
            out.writeDouble(this._nwUTM.n);
            if (this._nw.n == 0.0) {
                this._nw.n = Double.NEGATIVE_INFINITY;
            }
            if (this._nw.e == 0.0) {
                this._nw.e = Double.NEGATIVE_INFINITY;
            }
            if (this._nwUTM.e == 0.0) {
                this._nwUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._nwUTM.n == 0.0) {
                this._nwUTM.n = Double.NEGATIVE_INFINITY;
            }
            line = in.readLine();
            this._ne.n = this.parseDouble(line.substring(6, 18));
            this._ne.e = this.parseDouble(line.substring(18, 30));
            this._neUTM.e = this.parseDouble(line.substring(36, 48));
            this._neUTM.n = this.parseDouble(line.substring(48, 60));
            out.writeDouble(this._ne.n);
            out.writeDouble(this._ne.e);
            out.writeDouble(this._neUTM.e);
            out.writeDouble(this._neUTM.n);
            if (this._ne.n == 0.0) {
                this._ne.n = Double.NEGATIVE_INFINITY;
            }
            if (this._ne.e == 0.0) {
                this._ne.e = Double.NEGATIVE_INFINITY;
            }
            if (this._neUTM.e == 0.0) {
                this._neUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._neUTM.n == 0.0) {
                this._neUTM.n = Double.NEGATIVE_INFINITY;
            }
            line = in.readLine();
            this._se.n = this.parseDouble(line.substring(6, 18));
            this._se.e = this.parseDouble(line.substring(18, 30));
            this._seUTM.e = this.parseDouble(line.substring(36, 48));
            this._seUTM.n = this.parseDouble(line.substring(48, 60));
            out.writeDouble(this._se.n);
            out.writeDouble(this._se.e);
            out.writeDouble(this._seUTM.e);
            out.writeDouble(this._seUTM.n);
            if (this._se.n == 0.0) {
                this._se.n = Double.NEGATIVE_INFINITY;
            }
            if (this._se.e == 0.0) {
                this._se.e = Double.NEGATIVE_INFINITY;
            }
            if (this._seUTM.e == 0.0) {
                this._seUTM.e = Double.NEGATIVE_INFINITY;
            }
            if (this._seUTM.n == 0.0) {
                this._seUTM.n = Double.NEGATIVE_INFINITY;
            }
            line = in.readLine();
            int nnodes = this.parseInt(line.substring(30, 36));
            int nareas = this.parseInt(line.substring(46, 52));
            int nlines = this.parseInt(line.substring(62, 68));
            out.writeInt(nnodes);
            out.writeInt(nareas);
            out.writeInt(nlines);
            this._nodeVec.setSize(nnodes);
            this._areaVec.setSize(nareas);
            this._lineVec.setSize(nlines);
            this._ptVec.setSize(nlines * 50);
            this._attribVec.setSize((nnodes + nareas + nlines) * 2);
            this._ilineVec.setSize((nnodes + nareas) * 10);
            this._numPts = 0;
            this._numAttrib = 0;
            this._numILines = 0;
            long t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg ASCII Load - read header took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._numNodes = 0;
            int icnt = 0;
            int[] tmpInt = new int[12];
            for (i = 0; i < nnodes; ++i) {
                int jj;
                DlgNode nd = new DlgNode();
                this._nodeVec.setElementAt(nd, i);
                line = in.readLine();
                type = line.substring(0, 1);
                e = this.parseDouble(line.substring(6, 18));
                n = this.parseDouble(line.substring(18, 30));
                nd.numLines = this.parseInt(line.substring(36, 42));
                nd.numAttrib = this.parseInt(line.substring(48, 54));
                byteArray = type.getBytes();
                out.write(byteArray, 0, 1);
                out.writeDouble(e);
                out.writeDouble(n);
                out.writeInt(nd.numLines);
                out.writeInt(nd.numAttrib);
                nd.pt.e = this._a1 * e + this._a2 * n + this._a3;
                nd.pt.n = this._a1 * n - this._a2 * e + this._a4;
                nd.line0 = this._numILines;
                for (j = 0; j < (nd.numLines + 11) / 12; ++j) {
                    line = in.readLine();
                    imax = 12;
                    if (line.length() / 6 < 12) {
                        imax = line.length() / 6;
                    }
                    out.writeInt(imax);
                    for (jj = 0; jj < imax; ++jj) {
                        tmpInt[jj] = this.parseInt(line.substring(jj * 6, (jj + 1) * 6));
                        out.writeInt(tmpInt[jj]);
                    }
                    k = 0;
                    if (this._numILines + nd.numLines > this._ilineVec.size()) {
                        this._ilineVec.setSize(this._numILines + nd.numLines + 50);
                    }
                    while (icnt < nd.numLines && k < 12) {
                        this._ilineVec.setElementAt(new DlgILine(tmpInt[k]), this._numILines);
                        ++this._numILines;
                        ++icnt;
                        ++k;
                    }
                }
                nd.attrib0 = this._numAttrib;
                icnt = 0;
                for (j = 0; j < (nd.numAttrib + 5) / 6; ++j) {
                    line = in.readLine();
                    imax = 6;
                    if (line.length() / 12 < imax) {
                        imax = line.length() / 12;
                    }
                    out.writeInt(imax);
                    for (jj = 0; jj < imax; ++jj) {
                        major[jj] = this.parseInt(line.substring(jj * 12, jj * 12 + 6));
                        minor[jj] = this.parseInt(line.substring(jj * 12 + 6, jj * 12 + 12));
                        out.writeInt(major[jj]);
                        out.writeInt(minor[jj]);
                    }
                    k = 0;
                    if (this._numAttrib + nd.numAttrib > this._attribVec.size()) {
                        this._attribVec.setSize(this._numAttrib + nd.numAttrib + 50);
                    }
                    while (icnt < nd.numAttrib && k < 6) {
                        this._attribVec.setElementAt(new DlgAttrib(major[k], minor[k]), this._numAttrib);
                        ++this._numAttrib;
                        ++icnt;
                        ++k;
                    }
                }
                ++this._numNodes;
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg ASCII Load - read nodes took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._numAreas = 0;
            for (i = 0; i < nareas; ++i) {
                int jj;
                DlgArea a = new DlgArea();
                this._areaVec.setElementAt(a, i);
                line = in.readLine();
                type = line.substring(0, 1);
                e = this.parseDouble(line.substring(6, 18));
                n = this.parseDouble(line.substring(18, 30));
                a.numLines = this.parseInt(line.substring(36, 42));
                a.numAttrib = this.parseInt(line.substring(48, 54));
                byteArray = type.getBytes();
                out.write(byteArray, 0, 1);
                out.writeDouble(e);
                out.writeDouble(n);
                out.writeInt(a.numLines);
                out.writeInt(a.numAttrib);
                a.pt.e = this._a1 * e + this._a2 * n + this._a3;
                a.pt.n = this._a1 * n - this._a2 * e + this._a4;
                a.line0 = this._numILines;
                icnt = 0;
                for (j = 0; j < (a.numLines + 11) / 12; ++j) {
                    line = in.readLine();
                    imax = 12;
                    if (line.length() / 6 < imax) {
                        imax = line.length() / 6;
                    }
                    out.writeInt(imax);
                    for (jj = 0; jj < imax; ++jj) {
                        tmpInt[jj] = this.parseInt(line.substring(jj * 6, (jj + 1) * 6));
                        out.writeInt(tmpInt[jj]);
                    }
                    k = 0;
                    if (this._numILines + a.numLines > this._ilineVec.size()) {
                        this._ilineVec.setSize(this._numILines + a.numLines + 50);
                    }
                    while (icnt < a.numLines && k < 12) {
                        this._ilineVec.setElementAt(new DlgILine(tmpInt[k]), this._numILines);
                        ++this._numILines;
                        ++icnt;
                        ++k;
                    }
                }
                a.attrib0 = this._numAttrib;
                icnt = 0;
                for (j = 0; j < (a.numAttrib + 5) / 6; ++j) {
                    line = in.readLine();
                    imax = 6;
                    if (line.length() / 12 < imax) {
                        imax = line.length() / 12;
                    }
                    out.writeInt(imax);
                    for (jj = 0; jj < imax; ++jj) {
                        major[jj] = this.parseInt(line.substring(jj * 12, jj * 12 + 6));
                        minor[jj] = this.parseInt(line.substring(jj * 12 + 6, jj * 12 + 12));
                        out.writeInt(major[jj]);
                        out.writeInt(minor[jj]);
                    }
                    k = 0;
                    if (this._numAttrib + a.numAttrib > this._attribVec.size()) {
                        this._attribVec.setSize(this._numAttrib + a.numAttrib + 50);
                    }
                    while (icnt < a.numAttrib && k < 6) {
                        this._attribVec.setElementAt(new DlgAttrib(major[k], minor[k]), this._numAttrib);
                        ++this._numAttrib;
                        ++icnt;
                        ++k;
                    }
                }
                ++this._numAreas;
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg ASCII Load - read areas took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._numLines = 0;
            for (i = 0; i < nlines; ++i) {
                DlgLine l = new DlgLine();
                this._lineVec.setElementAt(l, i);
                line = in.readLine();
                type = line.substring(0, 1);
                l.upNode = this.parseInt(line.substring(6, 12)) - 1;
                l.dwnNode = this.parseInt(line.substring(12, 18)) - 1;
                l.leftArea = this.parseInt(line.substring(18, 24)) - 1;
                l.rightArea = this.parseInt(line.substring(24, 30)) - 1;
                l.numPts = this.parseInt(line.substring(42, 48));
                l.numAttrib = this.parseInt(line.substring(48, 54));
                byteArray = type.getBytes();
                out.write(byteArray, 0, 1);
                out.writeInt(l.upNode);
                out.writeInt(l.dwnNode);
                out.writeInt(l.leftArea);
                out.writeInt(l.rightArea);
                out.writeInt(l.numPts);
                out.writeInt(l.numAttrib);
                l.pt0 = this._numPts;
                icnt = 0;
                for (j = 0; j < (l.numPts + 2) / 3; ++j) {
                    line = in.readLine();
                    imax = 3;
                    if (line.length() / 24 < imax) {
                        imax = line.length() / 24;
                    }
                    out.writeInt(imax);
                    for (k = 0; k < imax; ++k) {
                        ee[k] = this.parseDouble(line.substring(k * 24, k * 24 + 12));
                        nn[k] = this.parseDouble(line.substring(k * 24 + 12, k * 24 + 24));
                        out.writeDouble(ee[k]);
                        out.writeDouble(nn[k]);
                    }
                    k = 0;
                    if (this._numPts + l.numPts > this._ptVec.size()) {
                        this._ptVec.setSize(this._numPts + l.numPts + 50);
                    }
                    while (icnt < l.numPts && k < 3) {
                        WorldPt pt = new WorldPt();
                        pt.e = this._a1 * ee[k] + this._a2 * nn[k] + this._a3;
                        pt.n = this._a1 * nn[k] - this._a2 * ee[k] + this._a4;
                        this._ptVec.setElementAt(pt, this._numPts);
                        ++this._numPts;
                        ++icnt;
                        ++k;
                    }
                }
                l.attrib0 = this._numAttrib;
                icnt = 0;
                for (j = 0; j < (l.numAttrib + 5) / 6; ++j) {
                    line = in.readLine();
                    imax = 6;
                    if (line.length() / 12 < imax) {
                        imax = line.length() / 12;
                    }
                    out.writeInt(imax);
                    for (k = 0; k < imax; ++k) {
                        major[k] = this.parseInt(line.substring(k * 12, k * 12 + 6));
                        minor[k] = this.parseInt(line.substring(k * 12 + 6, k * 12 + 12));
                        out.writeInt(major[k]);
                        out.writeInt(minor[k]);
                    }
                    k = 0;
                    if (this._numAttrib + l.numAttrib > this._attribVec.size()) {
                        this._attribVec.setSize(this._numAttrib + l.numAttrib + 50);
                    }
                    while (icnt < l.numAttrib && k < 6) {
                        this._attribVec.setElementAt(new DlgAttrib(major[k], minor[k]), this._numAttrib);
                        ++this._numAttrib;
                        ++icnt;
                        ++k;
                    }
                }
                ++this._numLines;
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg ASCII Load - read lines took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._ptVec.trimToSize();
            this._ilineVec.trimToSize();
            this._attribVec.trimToSize();
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg ASCII Load - trimed vectors took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this._isUTM = true;
            for (i = 0; i < this._numLines; ++i) {
                int np = ((DlgLine)this._lineVec.elementAt((int)i)).numPts;
                int ip0 = ((DlgLine)this._lineVec.elementAt((int)i)).pt0;
                ((DlgLine)this._lineVec.elementAt((int)i)).rc.initToPoint((WorldPt)this._ptVec.elementAt(ip0));
                for (j = ip0; j < np + ip0; ++j) {
                    ((DlgLine)this._lineVec.elementAt((int)i)).rc.growToPoint((WorldPt)this._ptVec.elementAt(j));
                }
                if (i == 0) {
                    this._rc.copy(((DlgLine)this._lineVec.elementAt((int)i)).rc);
                    continue;
                }
                this._rc.growToRect(((DlgLine)this._lineVec.elementAt((int)i)).rc);
            }
            t2 = new Date().getTime();
            if (this._debug) {
                System.out.println("*Dlg ASCII Load - build bounding boxes took : " + (t2 - t1) / 1000L + " seconds.");
            }
            this.setExtent(new WorldRect(this._rc.w, this._rc.n, this._rc.e, this._rc.s));
            in.close();
            out.flush();
            out.close();
            outFile.save();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean mapIdentifierEquals(MapIdentifier mapid) {
        String asciiFile;
        if (this.getMapIdentifier().equals(mapid)) {
            return true;
        }
        if (mapid == null) {
            return false;
        }
        String thatExt = RMAIO.getFileExtension(mapid.getPath());
        if (".dlg".equals(thatExt) && (asciiFile = this.getMapIdentifier().getPath()).endsWith(".dlgbin")) {
            asciiFile = asciiFile.substring(0, asciiFile.length() - 3);
            return RMAIO.pathsEqual(mapid.getPath(), asciiFile);
        }
        return false;
    }

    public class DlgFlag {
        public boolean interm;
        public boolean canal;
        public boolean marsh;
    }
}

