/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dxf;

import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldArc;
import hec.map.WorldLine;
import hec.map.dxf.DxfMap;
import hec.map.dxf.DxfVertex;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class DxfGlyph
extends MapGlyph {
    DxfMap _dxfmap;

    public DxfGlyph(MapPanel panel, DxfMap map) {
        super(panel, map);
        this._dxfmap = map;
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        if (this._dxfmap == null) {
            return;
        }
        Vector entityvec = this._dxfmap.getEntityVector();
        for (int i = 0; _paintOk && i < entityvec.size(); ++i) {
            Object obj = entityvec.elementAt(i);
            if (obj instanceof WorldLine) {
                this.drawLine(g, scl, (WorldLine)obj);
                continue;
            }
            if (!(obj instanceof WorldArc)) continue;
            this.drawArc(g, scl, (WorldArc)obj);
        }
    }

    public void drawLine(Graphics g, MapScale scl, WorldLine line) {
        int icnt = 0;
        DxfVertex pt0 = null;
        DxfVertex pt = null;
        for (int i = 0; _paintOk && i < line.pts.size(); ++i) {
            pt = (DxfVertex)line.pts.elementAt(i);
            if (pt0 == null || pt0.bulge == 0.0f) {
                ++icnt;
            } else {
                double ea;
                double e;
                double ang1;
                double hchord;
                double rad;
                double d;
                double n;
                double sa;
                double dist = pt0.distToPoint(pt);
                if (dist == 0.0) {
                    ++icnt;
                    pt0 = pt;
                    continue;
                }
                double bulge = Math.abs(pt0.bulge);
                int dir = 1;
                if ((double)pt0.bulge < 0.0) {
                    dir = -1;
                }
                if ((sa = Math.atan2(pt0.n - (n = pt0.n + (pt.n - pt0.n) / 2.0 + (double)dir * (pt.e - pt0.e) / dist * (d = (rad = (hchord = dist / 2.0) / Math.sin((ang1 = Math.atan(bulge)) * 2.0)) - hchord * bulge)), pt0.e - (e = pt0.e + (pt.e - pt0.e) / 2.0 - (double)dir * (pt.n - pt0.n) / dist * d))) < 0.0) {
                    sa += Math.PI * 2;
                }
                if ((ea = Math.atan2(pt.n - n, pt.e - e)) < 0.0) {
                    ea += Math.PI * 2;
                }
                if (dir == 1) {
                    if (ea < sa) {
                        ea += Math.PI * 2;
                    }
                    for (ang1 = sa + 0.1; _paintOk && ang1 < ea && ++icnt < 9000; ang1 += 0.1) {
                    }
                } else {
                    if (ea > sa) {
                        ea -= Math.PI * 2;
                    }
                    for (ang1 = sa - 0.1; _paintOk && ang1 > ea && ++icnt < 9000; ang1 -= 0.1) {
                    }
                }
                ++icnt;
            }
            pt0 = pt;
            if (icnt >= 9000) break;
        }
        int[] locxarray = new int[icnt];
        int[] locyarray = new int[icnt];
        icnt = 0;
        pt0 = null;
        pt = null;
        for (int i = 0; _paintOk && i < line.pts.size(); ++i) {
            pt = (DxfVertex)line.pts.elementAt(i);
            if (pt0 == null || pt0.bulge == 0.0f) {
                locxarray[icnt] = scl.e2x(pt.e);
                locyarray[icnt] = scl.n2y(pt.n);
                ++icnt;
            } else {
                double ea;
                double e;
                double ang1;
                double hchord;
                double rad;
                double d;
                double n;
                double sa;
                g.setColor(Color.green);
                g.drawRect(locxarray[icnt - 1] - 1, locyarray[icnt - 1] - 1, 3, 3);
                double dist = pt0.distToPoint(pt);
                if (dist == 0.0) {
                    locxarray[icnt] = scl.e2x(pt.e);
                    locyarray[icnt] = scl.n2y(pt.n);
                    ++icnt;
                    pt0 = pt;
                    continue;
                }
                double bulge = Math.abs(pt0.bulge);
                int dir = 1;
                if ((double)pt0.bulge < 0.0) {
                    dir = -1;
                }
                if ((sa = Math.atan2(pt0.n - (n = pt0.n + (pt.n - pt0.n) / 2.0 + (double)dir * (pt.e - pt0.e) / dist * (d = (rad = (hchord = dist / 2.0) / Math.sin((ang1 = Math.atan(bulge)) * 2.0)) - hchord * bulge)), pt0.e - (e = pt0.e + (pt.e - pt0.e) / 2.0 - (double)dir * (pt.n - pt0.n) / dist * d))) < 0.0) {
                    sa += Math.PI * 2;
                }
                if ((ea = Math.atan2(pt.n - n, pt.e - e)) < 0.0) {
                    ea += Math.PI * 2;
                }
                if (dir == 1) {
                    if (ea < sa) {
                        ea += Math.PI * 2;
                    }
                    for (ang1 = sa + 0.1; _paintOk && ang1 < ea; ang1 += 0.1) {
                        locxarray[icnt] = scl.e2x(e + rad * Math.cos(ang1));
                        locyarray[icnt] = scl.n2y(n + rad * Math.sin(ang1));
                        if (++icnt < 9000) {
                            continue;
                        }
                        break;
                    }
                } else {
                    if (ea > sa) {
                        ea -= Math.PI * 2;
                    }
                    for (ang1 = sa - 0.1; _paintOk && ang1 > ea; ang1 -= 0.1) {
                        locxarray[icnt] = scl.e2x(e + rad * Math.cos(ang1));
                        locyarray[icnt] = scl.n2y(n + rad * Math.sin(ang1));
                        if (++icnt < 9000) {
                            continue;
                        }
                        break;
                    }
                }
                locxarray[icnt] = scl.e2x(pt.e);
                locyarray[icnt] = scl.n2y(pt.n);
                ++icnt;
            }
            pt0 = pt;
            if (icnt >= 9000) break;
        }
        if (!_paintOk) {
            return;
        }
        g.setColor(Color.orange);
        g.drawPolyline(locxarray, locyarray, icnt);
        g.setColor(Color.blue);
        if (icnt > 2) {
            g.drawRect(locxarray[icnt - 1] - 2, locyarray[icnt - 1] - 2, 5, 5);
        }
    }

    public void drawArc(Graphics g, MapScale scl, WorldArc arc) {
        double rad;
        double sa;
        double ea;
        double e = arc.pt.e;
        double n = arc.pt.n;
        double dir = 1.0;
        if (e < 0.0) {
            dir = -1.0;
            e *= -1.0;
        }
        if ((ea = arc.endAngle) < (sa = arc.startAngle)) {
            ea += 360.0;
        }
        int icnt = 0;
        int[] locxarray = new int[(int)(ea - sa) + 1];
        int[] locyarray = new int[(int)(ea - sa) + 1];
        for (double a = sa; _paintOk && a < ea; a += 5.0) {
            rad = a * Math.PI / 180.0;
            locxarray[icnt] = scl.e2x(e + dir * arc.radius * Math.cos(rad));
            locyarray[icnt] = scl.n2y(n + arc.radius * Math.sin(rad));
            ++icnt;
        }
        if (!_paintOk) {
            return;
        }
        rad = ea * Math.PI / 180.0;
        locxarray[icnt] = scl.e2x(e + dir * arc.radius * Math.cos(rad));
        locyarray[icnt] = scl.n2y(n + arc.radius * Math.sin(rad));
        g.setColor(Color.red);
        g.drawPolyline(locxarray, locyarray, ++icnt);
    }
}

