/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dxf;

import hec.map.MapScaleEditorPanel;
import hec.map.dxf.DxfGlyph;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDialog;

public class DxfGlyphOptionDlg
extends RmaJDialog {
    DxfGlyph m_glyph = null;
    MapScaleEditorPanel m_mapScalePanel;

    public DxfGlyphOptionDlg(Frame parent, boolean modal, DxfGlyph glyph) {
        super(parent, "DXF Glyph Editor", modal);
        this.buildControls();
        this.m_glyph = glyph;
        this.m_mapScalePanel.setMapPanel(this.m_glyph.getMapPanel());
    }

    public void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_mapScalePanel = new MapScaleEditorPanel();
        this.getContentPane().add((Component)this.m_mapScalePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)cmdPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        DxfGlyphOptionDlg.this.ButtonOKPushed();
                        break;
                    }
                    case 4: {
                        DxfGlyphOptionDlg.this.ButtonCancelPushed();
                        break;
                    }
                    case 2: {
                        DxfGlyphOptionDlg.this.ButtonApplyPushed();
                    }
                }
            }
        });
        this.pack();
    }

    private void ButtonOKPushed() {
        this.ButtonApplyPushed();
        this.setVisible(false);
    }

    private void ButtonCancelPushed() {
        this.setVisible(false);
    }

    private void ButtonApplyPushed() {
        if (this.m_glyph == null) {
            return;
        }
        this.m_glyph.setMaximumScale(this.m_mapScalePanel.getMaximumScale());
        this.m_glyph.setMinimumScale(this.m_mapScalePanel.getMinimumScale());
        this.setModified(false);
    }

    public void fillPanel() {
        this.m_mapScalePanel.setScale(this.m_glyph.getMinimumScale(), this.m_glyph.getMaximumScale());
        this.setModified(false);
    }

    public static void main(String[] args) {
        DxfGlyphOptionDlg dlg = new DxfGlyphOptionDlg((Frame)new JFrame(), true, null);
        dlg.setLocation(250, 250);
        dlg.setVisible(true);
    }
}

