/*
 * Decompiled with CFR 0.152.
 */
package hec.map.dxf;

import hec.io.HecFile;
import hec.io.SimpleHecFileImpl;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldArc;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldText;
import hec.map.dxf.DxfVertex;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import rma.util.RMAIO;

public class DxfMap
extends MapObject
implements MapObjectInterface {
    GroupCode _gc = new GroupCode();
    Vector _entityVector = new Vector();
    boolean _extentInit = false;

    public DxfMap(String path) {
        super(path);
    }

    public DxfMap(MapIdentifier id) {
        super(id);
    }

    public DxfMap() {
    }

    public Vector getEntityVector() {
        return this._entityVector;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            long t1 = new Date().getTime();
            HecFile file = this._mapId.getFile();
            if (file == null) {
                String path = this._mapId.getPath();
                if (path == null) {
                    return;
                }
                file = new SimpleHecFileImpl(path);
                if (file == null) {
                    return;
                }
            }
            try {
                BufferedReader input = file.getBufferedReader();
                this.readData(input);
                input.close();
            }
            catch (IOException e) {
                return;
            }
            this._loaded = true;
        }
    }

    @Override
    public void unload() {
        this._gc = new GroupCode();
        this._entityVector.clear();
        this._loaded = false;
    }

    void readData(BufferedReader input) throws IOException {
        String section = this.nextSection(input);
        while (section.length() > 0) {
            if (section.equals("ENTITIES")) {
                this.readENTITIES(input);
            }
            section = this.nextSection(input);
        }
    }

    String nextSection(BufferedReader input) throws IOException {
        while (this.nextGroup(input, this._gc)) {
            if (this._gc.id != 0 || !this._gc.valstr.equals("SECTION")) continue;
            if (!this.nextGroup(input, this._gc)) {
                return "";
            }
            return this._gc.valstr;
        }
        return "";
    }

    boolean nextGroup(BufferedReader input, GroupCode gc) throws IOException {
        String line = input.readLine();
        if (line == null) {
            return false;
        }
        int id = RMAIO.parseInt(line);
        line = input.readLine();
        if (line == null) {
            return false;
        }
        gc.id = id;
        gc.valstr = line;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean readENTITIES(BufferedReader input) throws IOException {
        while (true) {
            if (this._gc.id == 0) {
                if (this._gc.valstr.equals("ENDSEC")) {
                    return true;
                }
                if (this._gc.valstr.equals("LINE")) {
                    this.readLINE(input);
                    continue;
                }
                if (this._gc.valstr.equals("ARC")) {
                    this.readARC(input);
                    continue;
                }
                if (this._gc.valstr.equals("POLYLINE")) {
                    this.readPOLYLINE(input);
                    continue;
                }
                if (this._gc.valstr.equals("LWPOLYLINE")) {
                    this.readLWPOLYLINE(input);
                    continue;
                }
                if (this._gc.valstr.equals("TEXT")) {
                    this.readTEXT(input);
                    continue;
                }
                if (this.nextGroup(input, this._gc)) continue;
                return false;
            }
            if (!this.nextGroup(input, this._gc)) return false;
        }
    }

    boolean readLINE(BufferedReader input) throws IOException {
        WorldLine line = new WorldLine();
        DxfVertex pt0 = new DxfVertex();
        DxfVertex pt1 = new DxfVertex();
        while (this.nextGroup(input, this._gc)) {
            if (this._gc.id == 10) {
                pt0.e = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 20) {
                pt0.n = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 11) {
                pt1.e = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 21) {
                pt1.n = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id != 0) continue;
            if (!this._extentInit) {
                this._extent.initToPoint(pt0);
                this._extentInit = true;
            } else {
                this._extent.growToPoint(pt0);
            }
            this._extent.growToPoint(pt0);
            line.pts.addElement(pt0);
            line.pts.addElement(pt1);
            this._entityVector.addElement(line);
            return true;
        }
        return false;
    }

    boolean readARC(BufferedReader input) throws IOException {
        WorldArc arc = new WorldArc();
        WorldPt pt = new WorldPt();
        while (this.nextGroup(input, this._gc)) {
            if (this._gc.id == 0) {
                if (pt.isValid()) {
                    arc.pt = pt;
                    this._entityVector.addElement(arc);
                }
                return true;
            }
            if (this._gc.id == 10) {
                pt.e = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 20) {
                pt.n = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 40) {
                arc.radius = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 50) {
                arc.startAngle = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id != 51) continue;
            arc.endAngle = RMAIO.parseDouble(this._gc.valstr);
        }
        return false;
    }

    boolean readPOLYLINE(BufferedReader input) throws IOException {
        WorldLine line = new WorldLine();
        DxfVertex pt = null;
        while (this.nextGroup(input, this._gc)) {
            if (this._gc.id == 0) {
                if (pt != null) {
                    if (!this._extentInit) {
                        this._extent.initToPoint(pt);
                        this._extentInit = true;
                    } else {
                        this._extent.growToPoint(pt);
                    }
                    line.pts.addElement(pt);
                    pt = null;
                }
                if (this._gc.valstr.equals("VERTEX")) {
                    pt = new DxfVertex();
                    continue;
                }
                if (!this._gc.valstr.equals("SEQEND")) continue;
                this._entityVector.addElement(line);
                this.nextGroup(input, this._gc);
                return true;
            }
            if (pt != null && this._gc.id == 10) {
                pt.e = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (pt != null && this._gc.id == 20) {
                pt.n = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (pt != null && this._gc.id == 30) {
                pt.z = RMAIO.parseFloat(this._gc.valstr);
                continue;
            }
            if (pt == null || this._gc.id != 42) continue;
            pt.bulge = RMAIO.parseFloat(this._gc.valstr);
        }
        return false;
    }

    boolean readLWPOLYLINE(BufferedReader input) throws IOException {
        WorldLine line = new WorldLine();
        DxfVertex pt = null;
        int polyLineFlag = 0;
        boolean foundNumPts = false;
        int numPts = 0;
        int icnt = 0;
        float elevation = 0.0f;
        while (this.nextGroup(input, this._gc)) {
            if (this._gc.id == 0) {
                if (polyLineFlag == 1 && icnt > 0) {
                    pt = new DxfVertex();
                    DxfVertex pt0 = (DxfVertex)line.pts.get(0);
                    pt.e = pt0.e;
                    pt.n = pt0.n;
                    pt.z = pt0.z;
                    line.pts.add(pt);
                }
                int nsize = line.pts.size();
                for (int i = 0; i < nsize; ++i) {
                    pt = (DxfVertex)line.pts.get(i);
                    if (!this._extentInit) {
                        this._extent.initToPoint(pt);
                        this._extentInit = true;
                        continue;
                    }
                    this._extent.growToPoint(pt);
                }
                this._entityVector.addElement(line);
                return true;
            }
            if (this._gc.id == 90) {
                numPts = RMAIO.parseInt(this._gc.valstr);
                foundNumPts = true;
                line.pts.ensureCapacity(numPts + 2);
                continue;
            }
            if (this._gc.id == 10) {
                if (!foundNumPts) {
                    // empty if block
                }
                pt = new DxfVertex();
                pt.e = RMAIO.parseDouble(this._gc.valstr);
                pt.z = elevation;
                line.pts.add(pt);
                ++icnt;
                continue;
            }
            if (pt != null && this._gc.id == 20) {
                pt.n = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (pt != null && this._gc.id == 42) {
                pt.bulge = RMAIO.parseFloat(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 38) {
                elevation = RMAIO.parseFloat(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 43 || this._gc.id != 70) continue;
            polyLineFlag = RMAIO.parseInt(this._gc.valstr);
        }
        return false;
    }

    boolean readTEXT(BufferedReader input) throws IOException {
        WorldText pt = new WorldText();
        while (this.nextGroup(input, this._gc)) {
            if (this._gc.id == 0) {
                if (pt.isValid()) {
                    this._entityVector.addElement(pt);
                }
                return true;
            }
            if (this._gc.id == 10) {
                pt.e = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 20) {
                pt.n = RMAIO.parseDouble(this._gc.valstr);
                continue;
            }
            if (this._gc.id == 30) {
                pt.z = RMAIO.parseFloat(this._gc.valstr);
                continue;
            }
            if (this._gc.id != 1) continue;
            pt.text = this._gc.valstr;
        }
        return false;
    }

    class GroupCode {
        int id = -1;
        String valstr = new String();

        GroupCode() {
        }

        float getFloatValue() {
            return RMAIO.parseFloat(this.valstr);
        }
    }
}

