/*
 * Decompiled with CFR 0.152.
 */
package hec.map.flo2d;

import hec.map.LocalRegion;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.flo2d.Flo2dDepthMap;
import hec.map.flo2d.Flo2dGlyph;
import hec.map.flo2d.Flo2dMap;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import rma.util.ColorContour;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.WaterDepthColorContour;

public class Flo2dDepthGlyph
extends Flo2dGlyph {
    private WaterDepthColorContour _cc = new WaterDepthColorContour();

    public Flo2dDepthGlyph() {
        this._drawOutlines = false;
    }

    public Flo2dDepthGlyph(MapPanel panel, Flo2dDepthMap map) {
        super(panel, map);
    }

    @Override
    protected boolean shouldDrawZeroCells() {
        return false;
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
    }

    @Override
    public String getToolTipText(WorldPt wpt, MouseEvent e) {
        Flo2dMap map = (Flo2dMap)this.getMap();
        double elev = map.getElevation(wpt);
        int cell = map.getCell(wpt);
        if (RMAConst.isValidValue(cell)) {
            String s = "<html>Cell:" + cell;
            if (elev != map.getNoDataValue()) {
                s = s + "<br>Depth:" + RMAIO.setPrecision2(elev, 2);
            }
            s = s + "</html>";
            return s;
        }
        return super.getToolTipText(wpt, e);
    }

    @Override
    protected ColorContour getColorContour() {
        return this._cc;
    }
}

