/*
 * Decompiled with CFR 0.152.
 */
package hec.map.flo2d;

import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.Logger;
import hec.map.GridMap;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.flo2d.Flo2dCell;
import hec.map.flo2d.Flo2dDepthGlyph;
import hec.map.flo2d.Flo2dMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import rma.util.RMAIO;

public class Flo2dDepthMap
extends MapObject
implements MapObjectInterface,
GridMap,
Flo2dMap {
    private static final String CADPTS_DAT_FILE = "cadpts.dat";
    private List<Flo2dCell> _cells = new ArrayList<Flo2dCell>();
    private double _cellSize;
    protected double _maxElev = Double.MIN_VALUE;
    protected double _minElev = Double.MAX_VALUE;

    public Flo2dDepthMap() {
        this._debug = Logger.canDebug("maps");
    }

    public Flo2dDepthMap(String path) {
        super(path);
    }

    public Flo2dDepthMap(MapIdentifier id) {
        super(id);
    }

    @Override
    public WorldRect getExtent() {
        return this._extent;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            HecFile file = this._mapId.getFile();
            if (file == null) {
                Identifier id = this.openFile(this._mapId);
                System.out.println("load:loading " + this._mapId.getPath());
                if (id != null) {
                    file = id.getFile();
                    this._mapId.setFile(file);
                } else {
                    System.out.println("load:failed to open file " + this._mapId.getPath());
                    return;
                }
            }
            this._loaded = this.readFile(this._mapId);
        }
    }

    public boolean readFile(MapIdentifier shpId) {
        String basePath = shpId.getPath();
        basePath = RMAIO.getDirectoryFromPath(basePath);
        String cadPtsPath = basePath + CADPTS_DAT_FILE;
        return this.readFinalDep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readFinalDep() {
        HecFile file = this._mapId.getFile();
        if (file == null) {
            System.out.println("readFinalDep: no file for " + this._mapId.getPath());
            return false;
        }
        if (this._debug) {
            System.out.println("opening " + file.getPath());
        }
        if (!file.exists()) {
            System.out.println("readFinalDep:" + file.getPath() + " doesn't exist");
            return false;
        }
        BufferedReader reader = file.getBufferedReader();
        try {
            String line = reader.readLine();
            Flo2dCell c1 = this.createCell(line);
            if (c1.getDepth() > this._maxElev) {
                this._maxElev = c1.getDepth();
            }
            if (c1.getDepth() < this._minElev) {
                this._minElev = c1.getDepth();
            }
            WorldPt wpt1 = c1.getCenterPoint();
            String line2 = reader.readLine();
            Flo2dCell c2 = this.createCell(line2);
            if (c2.getDepth() > this._maxElev) {
                this._maxElev = c1.getDepth();
            }
            if (c2.getDepth() < this._minElev) {
                this._minElev = c1.getDepth();
            }
            WorldPt wpt2 = c2.getCenterPoint();
            this._cellSize = wpt2.distToPoint(wpt1);
            double radius = this._cellSize / 2.0;
            c1.init(c1.getCenterPoint(), radius);
            c2.init(c2.getCenterPoint(), radius);
            this._cells.add(c1);
            this._cells.add(c2);
            this._extent.grow(c1);
            this._extent.grow(c2);
            while ((line = reader.readLine()) != null) {
                c1 = this.createCell(line);
                if (c1 == null) continue;
                c1.init(c1.getCenterPoint(), radius);
                this._extent.grow(c1);
                if (c1.getDepth() > this._maxElev) {
                    this._maxElev = c1.getDepth();
                }
                if (c1.getDepth() < this._minElev) {
                    this._minElev = c1.getDepth();
                }
                this._cells.add(c1);
            }
            this._loaded = true;
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            System.out.println("readFinalDep:Error reading " + file.getPath() + " Error:" + ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void unload() {
    }

    private Flo2dCell createCell(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        if (tokenizer.countTokens() != 4) {
            System.out.println("createCell:invalid line '" + line + "'");
            return null;
        }
        String cellStr = tokenizer.nextToken();
        String xStr = tokenizer.nextToken();
        String yStr = tokenizer.nextToken();
        String depthStr = tokenizer.nextToken();
        int cell = RMAIO.parseInt(cellStr, -1);
        double x = RMAIO.parseDouble(xStr, -1.0);
        double y = RMAIO.parseDouble(yStr, -1.0);
        double depth = RMAIO.parseDouble(depthStr);
        Flo2dCell c2 = new Flo2dCell(cell, new WorldPt(x, y), depth);
        return c2;
    }

    @Override
    public WorldRect getGridCellSize() {
        WorldRect r = new WorldRect();
        r.w = 0.0;
        r.s = 0.0;
        r.e = this._cellSize;
        r.n = this._cellSize;
        return r;
    }

    @Override
    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean supportsNoDataValue() {
        return true;
    }

    @Override
    public float getElevation(WorldPt pt) {
        Flo2dCell cell = this.findCell(pt);
        if (cell == null) {
            return (float)this.getNoDataValue();
        }
        float depth = (float)cell.getDepth();
        return depth > 0.0f ? depth : (float)this.getNoDataValue();
    }

    public Flo2dCell findCell(WorldPt pt) {
        return this.findCell(pt.e, pt.n);
    }

    public Flo2dCell findCell(double e, double n) {
        int size = this._cells.size();
        for (int i = 0; i < size; ++i) {
            if (!this._cells.get(i).contains(e, n)) continue;
            return this._cells.get(i);
        }
        return null;
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        if (northing == null || northing.length == 0 || easting == null || easting.length == 0) {
            return new float[0];
        }
        float[] retDepths = new float[northing.length];
        for (int i = 0; i < northing.length; ++i) {
            float depth;
            Flo2dCell cell = this.findCell(easting[i], northing[i]);
            retDepths[i] = cell != null ? ((depth = (float)cell.getDepth()) > 0.0f ? depth : (float)this.getNoDataValue()) : (float)this.getNoDataValue();
        }
        return retDepths;
    }

    @Override
    public double getMaximumElevation() {
        return this._maxElev;
    }

    @Override
    public double getMinimumElevation() {
        return this._minElev;
    }

    @Override
    public List<Flo2dCell> getCells() {
        return this._cells;
    }

    @Override
    public int getCell(WorldPt wpt) {
        Flo2dCell cell = this.findCell(wpt);
        if (cell != null) {
            return cell.getCellNumber();
        }
        return Integer.MIN_VALUE;
    }

    static {
        MapGlyphFactory.addMapping(Flo2dDepthMap.class.getName(), Flo2dDepthGlyph.class.getName());
    }
}

