/*
 * Decompiled with CFR 0.152.
 */
package hec.map.flo2d;

import hec.map.ElevationGlyph;
import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.flo2d.Flo2dCell;
import hec.map.flo2d.Flo2dMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import rma.util.ColorContour;

public abstract class Flo2dGlyph
extends MapGlyph
implements ElevationGlyph {
    protected LocalRect _lr = new LocalRect();
    protected boolean _drawOutlines = true;

    public Flo2dGlyph(MapPanel panel, MapObjectInterface map) {
        super(panel, map);
    }

    public Flo2dGlyph() {
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        Composite oldac = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            oldac = g2.getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
            g2.setComposite(ac);
        }
        Flo2dMap map = (Flo2dMap)this.getMap();
        List<Flo2dCell> cells = map.getCells();
        System.out.println("Flo2dGlyph.drawing " + cells.size() + " cells");
        int size = cells.size();
        ColorContour cc = this.getColorContour();
        cc.setMaxValue(map.getMaximumElevation());
        cc.setMinValue(map.getMinimumElevation());
        for (int i = 0; i < size; ++i) {
            Flo2dCell cell = cells.get(i);
            this.drawWorldRect(g, scl, cell, Color.BLACK, null);
        }
        if (oldac != null) {
            ((Graphics2D)g).setComposite(oldac);
        }
    }

    protected void drawWorldRect(Graphics g, MapScale scl, Flo2dCell cell, Color lineClr, Color fillClr) {
        double depth = cell.getDepth();
        if (depth == 0.0 && !this.shouldDrawZeroCells()) {
            return;
        }
        ColorContour cc = this.getColorContour();
        if (depth < cc.getMinValue() || depth > cc.getMaxValue()) {
            return;
        }
        Color c2 = fillClr;
        if (c2 == null) {
            c2 = cc.getColor(depth);
        }
        this._lr = scl.wr2lr(cell, this._lr);
        if (scl.getViewRect().intersects(this._lr)) {
            g.setColor(c2);
            g.fillRect(this._lr.l, this._lr.t, this._lr.width(), this._lr.height());
            if (this._drawOutlines) {
                g.setColor(lineClr);
                g.drawRect(this._lr.l, this._lr.t, this._lr.width(), this._lr.height());
            }
        }
    }

    protected boolean shouldDrawZeroCells() {
        return true;
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        if (this._mapPanel == null || this._map == null) {
            return Float.NEGATIVE_INFINITY;
        }
        WorldPt wpt = new WorldPt(this._mapPanel.scale().x2e(ix), this._mapPanel.scale().y2n(iy));
        return (float)this.getElevation(wpt);
    }

    private double getElevation(WorldPt wpt) {
        if (this._map == null) {
            return Double.NEGATIVE_INFINITY;
        }
        Flo2dMap map = (Flo2dMap)this._map;
        return map.getElevation(wpt);
    }

    @Override
    public double getMaximumElevation() {
        Flo2dMap map = (Flo2dMap)this.getMap();
        return map.getMaximumElevation();
    }

    @Override
    public double getMinimumElevation() {
        Flo2dMap map = (Flo2dMap)this.getMap();
        return map.getMinimumElevation();
    }

    @Override
    public double getNoDataValue() {
        Flo2dMap map = (Flo2dMap)this.getMap();
        return map.getNoDataValue();
    }

    protected abstract ColorContour getColorContour();
}

