/*
 * Decompiled with CFR 0.152.
 */
package hec.map.hms;

import hec.map.WorldRect;
import hec.map.hms.HmsMapLine;
import java.io.Serializable;
import java.util.Vector;

public class HmsMapObject
implements Serializable {
    private double _eExt;
    private double _wExt;
    private double _nExt;
    private double _sExt;
    private String name = "";
    private Vector listOfLines = new Vector();

    public HmsMapObject() {
    }

    public HmsMapObject(String name) {
        this.name = name;
    }

    public WorldRect getExtent() {
        return new WorldRect(this._wExt, this._eExt, this._sExt, this._nExt);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addLine(double[] x, double[] y, int numberOfPoints, boolean polygon) {
        HmsMapLine line = new HmsMapLine(x, y, numberOfPoints, polygon);
        this.listOfLines.addElement(line);
        if (this.listOfLines.size() == 1) {
            this._eExt = line.getExtent().e;
            this._wExt = line.getExtent().w;
            this._sExt = line.getExtent().s;
            this._nExt = line.getExtent().n;
        } else {
            this._eExt = Math.max(line.getExtent().e, this._eExt);
            this._wExt = Math.min(line.getExtent().w, this._wExt);
            this._sExt = Math.min(line.getExtent().s, this._sExt);
            this._nExt = Math.max(line.getExtent().n, this._nExt);
        }
    }

    public void trimLine() {
        this.listOfLines.trimToSize();
    }

    public int getNumberOfLines() {
        return this.listOfLines.size();
    }

    public String getName() {
        return this.name;
    }

    public HmsMapLine getLine(int index) {
        return (HmsMapLine)this.listOfLines.elementAt(index);
    }
}

