/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.gui.WizardDialog;
import hec.map.WorldRect;
import hec.map.image.DefineWorldCoordinatesWizardPanel;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public class DefineWorldCoordinatesWizardDialog
extends WizardDialog {
    List<File> mFilesWithoutGeoreferencing;
    List<DefineWorldCoordinatesWizardPanel> mPanels = new ArrayList<DefineWorldCoordinatesWizardPanel>();
    boolean mCanceled = false;

    public DefineWorldCoordinatesWizardDialog(JFrame parent, boolean modal, List<File> filesWithoutGeoreferencing) {
        super((Frame)parent, modal);
        this.mFilesWithoutGeoreferencing = filesWithoutGeoreferencing;
        for (int i = 0; i < this.mFilesWithoutGeoreferencing.size(); ++i) {
            File f = this.mFilesWithoutGeoreferencing.get(i);
            DefineWorldCoordinatesWizardPanel panel = new DefineWorldCoordinatesWizardPanel(f);
            if (i - 1 >= 0) {
                panel.setBackPanelName(this.mFilesWithoutGeoreferencing.get(i - 1).getAbsolutePath());
            }
            if (i + 1 < this.mFilesWithoutGeoreferencing.size()) {
                panel.setNextPanelName(this.mFilesWithoutGeoreferencing.get(i + 1).getAbsolutePath());
            }
            this.addWizardPanel(panel);
            this.mPanels.add(panel);
        }
        this.setTitle("Define Image Extents");
    }

    public Map<File, WorldRect> getImageBounds() {
        HashMap<File, WorldRect> map = new HashMap<File, WorldRect>();
        for (int i = 0; i < this.mPanels.size(); ++i) {
            DefineWorldCoordinatesWizardPanel panel = this.mPanels.get(i);
            WorldRect rect = new WorldRect();
            rect.n = panel.getNorthingCoordinate();
            rect.w = panel.getWestingCoordinate();
            rect.s = panel.getSouthCoordinate();
            rect.e = panel.getEastingCoordinate();
            map.put(this.mFilesWithoutGeoreferencing.get(i), rect);
        }
        return map;
    }

    @Override
    protected void dialogCanceled() {
        this.mCanceled = true;
    }

    @Override
    protected void dialogFinished() {
        this.mCanceled = false;
        this.setVisible(false);
    }

    boolean isCanceled() {
        return this.mCanceled;
    }
}

