/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.gui.WizardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.util.RMAIO;

public class DefineWorldCoordinatesWizardPanel
extends WizardPanel {
    RmaJDecimalField mImageWestTxt;
    RmaJDecimalField mImageNorthTxt;
    RmaJDecimalField mImageEastTxt;
    RmaJDecimalField mImageSouthTxt;
    File mFile = null;

    public DefineWorldCoordinatesWizardPanel(File f) {
        super(new GridBagLayout());
        this.mFile = f;
        this.buildControls();
    }

    @Override
    public String getWindowTitle() {
        return "Define Image Extents";
    }

    @Override
    public String getPanelName() {
        return this.mFile.getAbsolutePath();
    }

    private void buildControls() {
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel jlabel = new JLabel("File: " + RMAIO.getFileFromPath(this.mFile.getAbsolutePath()));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)jlabel, gbc);
        jlabel = new JLabel("Image West");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)jlabel, gbc);
        this.mImageWestTxt = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this.mImageWestTxt, gbc);
        jlabel = new JLabel("Image North");
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)jlabel, gbc);
        this.mImageNorthTxt = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this.mImageNorthTxt, gbc);
        jlabel = new JLabel("Image East");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5500;
        this.add((Component)jlabel, gbc);
        this.mImageEastTxt = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.add((Component)this.mImageEastTxt, gbc);
        jlabel = new JLabel("Image South");
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5550;
        this.add((Component)jlabel, gbc);
        this.mImageSouthTxt = new RmaJDecimalField();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5555;
        this.add((Component)this.mImageSouthTxt, gbc);
    }

    @Override
    public boolean isValidPanel() {
        boolean defined = this.isValidField(this.mImageEastTxt) && this.isValidField(this.mImageNorthTxt) && this.isValidField(this.mImageSouthTxt) && this.isValidField(this.mImageWestTxt);
        boolean southLessThanNorth = true;
        boolean westLessThanEast = true;
        if (defined) {
            southLessThanNorth = this.mImageNorthTxt.getValue() - this.mImageSouthTxt.getValue() > 0.0;
            westLessThanEast = this.mImageEastTxt.getValue() - this.mImageWestTxt.getValue() > 0.0;
        }
        return defined && southLessThanNorth && westLessThanEast;
    }

    public double getEastingCoordinate() {
        return this.mImageEastTxt.getValueUndefined();
    }

    public double getNorthingCoordinate() {
        return this.mImageNorthTxt.getValueUndefined();
    }

    public double getWestingCoordinate() {
        return this.mImageWestTxt.getValueUndefined();
    }

    public double getSouthCoordinate() {
        return this.mImageSouthTxt.getValueUndefined();
    }

    private boolean isValidField(RmaJDecimalField field) {
        if (field == null) {
            return false;
        }
        String txt = field.getText();
        return RMAIO.parseDouble(txt, Double.NEGATIVE_INFINITY) != Double.NEGATIVE_INFINITY;
    }

    void setFile(File f) {
    }
}

