/*
 * Decompiled with CFR 0.152.
 */
package hec.map.image;

import hec.map.LocalRect;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class DragPoint {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int TOP_CENTER = 2;
    public static final int MIDDLE_LEFT = 3;
    public static final int MIDDLE_RIGHT = 4;
    public static final int CENTER = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_RIGHT = 7;
    public static final int BOTTOM_CENTER = 8;
    public static final int ROTATE = 9;
    public static final int DRAG_HANDLE_WIDTH = 10;
    public static final int DRAG_HANDLE_HEIGHT = 10;
    private Point pt = new Point();
    private int _position = 0;
    private Rectangle _boundingBox = new Rectangle();
    public AffineTransform TRANSFORM = new AffineTransform();
    public AffineTransform INV_TRANSFORM = new AffineTransform();
    Point testPoint = new Point();

    public DragPoint(int position) {
        this._position = position;
    }

    public DragPoint(LocalRect rect, int position) {
        this._position = position;
        this.udpate(rect);
    }

    public int getPosition() {
        return this._position;
    }

    public void udpate(LocalRect rect) {
        int y;
        int x;
        int WIDTH = Math.min((int)((double)rect.width() * 0.1), 10);
        int HEIGHT = Math.min((int)((double)rect.height() * 0.1), 10);
        switch (this._position) {
            case 0: {
                x = rect.l;
                y = rect.t;
                break;
            }
            case 1: {
                x = rect.r - WIDTH + 1;
                y = rect.t;
                break;
            }
            case 2: {
                x = rect.l + (rect.r - rect.l) / 2 - WIDTH / 2;
                y = rect.t;
                break;
            }
            case 4: {
                x = rect.r - WIDTH + 1;
                y = rect.t + (rect.b - rect.t) / 2 - HEIGHT / 2;
                break;
            }
            case 3: {
                x = rect.l;
                y = rect.t + (rect.b - rect.t) / 2 - HEIGHT / 2;
                break;
            }
            case 5: {
                x = rect.l + (rect.r - rect.l) / 2 - WIDTH / 2;
                y = rect.t + (rect.b - rect.t) / 2 - HEIGHT / 2;
                break;
            }
            case 7: {
                x = rect.r - WIDTH + 1;
                y = rect.b - HEIGHT;
                break;
            }
            case 6: {
                x = rect.l;
                y = rect.b - HEIGHT;
                break;
            }
            case 8: {
                x = rect.l + (rect.r - rect.l) / 2 - WIDTH / 2;
                y = rect.b - HEIGHT;
                break;
            }
            case 9: {
                x = rect.l + (rect.r - rect.l) / 2 - WIDTH / 2;
                y = rect.t - 2 * WIDTH;
                break;
            }
            default: {
                x = 1;
                y = 1;
            }
        }
        this.pt = new Point(x, y);
        this._boundingBox = new Rectangle(this.pt.x, this.pt.y, WIDTH, HEIGHT);
    }

    public void drawPoint(Graphics2D g) {
        this.TRANSFORM = g.getTransform();
        try {
            this.INV_TRANSFORM = this.TRANSFORM.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getPosition() != 9) {
            g.setColor(Color.RED);
            g.fillRect(this.pt.x, this.pt.y, this._boundingBox.width, this._boundingBox.height);
        } else {
            g.setColor(Color.GREEN);
            g.fillOval(this.pt.x, this.pt.y, this._boundingBox.width, this._boundingBox.height);
            g.setColor(Color.BLACK);
            g.drawOval(this.pt.x, this.pt.y, this._boundingBox.width, this._boundingBox.height);
        }
    }

    public boolean contains(Point p) {
        Point2D.Double pt2d = new Point2D.Double(p.x, p.y);
        Point2D.Double dstPt = new Point2D.Double();
        this.INV_TRANSFORM.transform(pt2d, dstPt);
        this.testPoint.x = (int)((Point2D)dstPt).getX();
        this.testPoint.y = (int)((Point2D)dstPt).getY();
        return this._boundingBox.contains(this.testPoint);
    }

    public Cursor getCursor() {
        int CURSOR_ID = 0;
        switch (this._position) {
            case 0: {
                CURSOR_ID = 6;
                break;
            }
            case 1: {
                CURSOR_ID = 7;
                break;
            }
            case 2: {
                CURSOR_ID = 8;
                break;
            }
            case 3: {
                CURSOR_ID = 10;
                break;
            }
            case 4: {
                CURSOR_ID = 11;
                break;
            }
            case 5: 
            case 9: {
                CURSOR_ID = 13;
                break;
            }
            case 7: {
                CURSOR_ID = 5;
                break;
            }
            case 6: {
                CURSOR_ID = 4;
                break;
            }
            case 8: {
                CURSOR_ID = 9;
                break;
            }
            default: {
                CURSOR_ID = 0;
            }
        }
        return Cursor.getPredefinedCursor(CURSOR_ID);
    }
}

